/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface LongConsumerWithThrowable<E extends Throwable>
extends LongConsumer {
    public static <E extends Throwable> LongConsumerWithThrowable<E> castLongConsumerWithThrowable(LongConsumerWithThrowable<E> longconsumerwiththrowable) {
        return longconsumerwiththrowable;
    }

    public static <E extends Throwable> LongConsumer aLongConsumerThatUnsafelyThrowsUnchecked(LongConsumerWithThrowable<E> longconsumerwiththrowable) throws E {
        return longconsumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> LongConsumerWithThrowable<E> asLongConsumerWithThrowable(LongConsumer longconsumer) {
        return longconsumer::accept;
    }

    @Override
    default public void accept(long v1) {
        try {
            this.acceptWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(long var1) throws E;

    default public LongConsumer thatThrowsNothing() {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public LongConsumer thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public LongConsumerWithThrowable<E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public LongConsumerWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in LongConsumerWithThrowable with the argument [{}]");
    }

    default public LongConsumerWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public LongConsumerWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public LongConsumerWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

