/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.Consumer;
import java.util.function.IntSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface IntSupplierWithThrowable<E extends Throwable>
extends IntSupplier {
    public static <E extends Throwable> IntSupplierWithThrowable<E> castIntSupplierWithThrowable(IntSupplierWithThrowable<E> intsupplierwiththrowable) {
        return intsupplierwiththrowable;
    }

    public static <E extends Throwable> IntSupplier aIntSupplierThatUnsafelyThrowsUnchecked(IntSupplierWithThrowable<E> intsupplierwiththrowable) throws E {
        return intsupplierwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> IntSupplierWithThrowable<E> asIntSupplierWithThrowable(IntSupplier intsupplier) {
        return intsupplier::getAsInt;
    }

    @Override
    default public int getAsInt() {
        try {
            return this.getAsIntWithThrowable();
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public int getAsIntWithThrowable() throws E;

    default public IntSupplier thatReturnsOnCatch(int defaultReturnValue) {
        return () -> {
            try {
                return this.getAsIntWithThrowable();
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public IntSupplier thatUnsafelyThrowsUnchecked() throws E {
        return () -> {
            try {
                return this.getAsIntWithThrowable();
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0;
            }
        };
    }

    default public IntSupplierWithThrowable<E> withLogging(Logger logger, String message) {
        return () -> {
            try {
                return this.getAsIntWithThrowable();
            }
            catch (Throwable throwable) {
                logger.error(message, throwable);
                throw throwable;
            }
        };
    }

    default public IntSupplierWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in IntSupplierWithThrowable");
    }

    default public IntSupplierWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public IntSupplierWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return () -> {
            try {
                return this.getAsIntWithThrowable();
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }
}

