/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface IntPredicateWithThrowable<E extends Throwable>
extends IntPredicate {
    public static <E extends Throwable> IntPredicateWithThrowable<E> castIntPredicateWithThrowable(IntPredicateWithThrowable<E> intpredicatewiththrowable) {
        return intpredicatewiththrowable;
    }

    public static <E extends Throwable> IntPredicate aIntPredicateThatUnsafelyThrowsUnchecked(IntPredicateWithThrowable<E> intpredicatewiththrowable) throws E {
        return intpredicatewiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> IntPredicateWithThrowable<E> asIntPredicateWithThrowable(IntPredicate intpredicate) {
        return intpredicate::test;
    }

    @Override
    default public boolean test(int v1) {
        try {
            return this.testWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public boolean testWithThrowable(int var1) throws E;

    default public IntPredicate thatReturnsOnCatch(boolean defaultReturnValue) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public IntPredicate thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return false;
            }
        };
    }

    default public IntPredicateWithThrowable<E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public IntPredicateWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in IntPredicateWithThrowable with the argument [{}]");
    }

    default public IntPredicateWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public IntPredicateWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public IntPredicateWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.testWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

