/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface IntFunctionWithThrowable<R, E extends Throwable>
extends IntFunction<R> {
    public static <R, E extends Throwable> IntFunctionWithThrowable<R, E> castIntFunctionWithThrowable(IntFunctionWithThrowable<R, E> intfunctionwiththrowable) {
        return intfunctionwiththrowable;
    }

    public static <R, E extends Throwable> IntFunction<R> aIntFunctionThatUnsafelyThrowsUnchecked(IntFunctionWithThrowable<R, E> intfunctionwiththrowable) throws E {
        return intfunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <R, E extends Throwable> IntFunctionWithThrowable<R, E> asIntFunctionWithThrowable(IntFunction<R> intfunction) {
        return intfunction::apply;
    }

    @Override
    default public R apply(int v1) {
        try {
            return this.applyWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public R applyWithThrowable(int var1) throws E;

    default public IntFunction<Optional<R>> thatReturnsOptional() {
        return v1 -> {
            try {
                return Optional.ofNullable(this.applyWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        };
    }

    default public IntFunction<R> thatReturnsOnCatch(R defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public IntFunction<R> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public IntFunctionWithThrowable<R, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public IntFunctionWithThrowable<R, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in IntFunctionWithThrowable with the argument [{}]");
    }

    default public IntFunctionWithThrowable<R, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public IntFunctionWithThrowable<R, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public IntFunctionWithThrowable<R, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

