/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface DoubleUnaryOperatorWithThrowable<E extends Throwable>
extends DoubleUnaryOperator {
    public static <E extends Throwable> DoubleUnaryOperatorWithThrowable<E> castDoubleUnaryOperatorWithThrowable(DoubleUnaryOperatorWithThrowable<E> doubleunaryoperatorwiththrowable) {
        return doubleunaryoperatorwiththrowable;
    }

    public static <E extends Throwable> DoubleUnaryOperator aDoubleUnaryOperatorThatUnsafelyThrowsUnchecked(DoubleUnaryOperatorWithThrowable<E> doubleunaryoperatorwiththrowable) throws E {
        return doubleunaryoperatorwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> DoubleUnaryOperatorWithThrowable<E> asDoubleUnaryOperatorWithThrowable(DoubleUnaryOperator doubleunaryoperator) {
        return doubleunaryoperator::applyAsDouble;
    }

    @Override
    default public double applyAsDouble(double v1) {
        try {
            return this.applyAsDoubleWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public double applyAsDoubleWithThrowable(double var1) throws E;

    default public DoubleUnaryOperator thatReturnsOnCatch(double defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public DoubleUnaryOperator thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0.0;
            }
        };
    }

    default public DoubleUnaryOperatorWithThrowable<E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public DoubleUnaryOperatorWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in DoubleUnaryOperatorWithThrowable with the argument [{}]");
    }

    default public DoubleUnaryOperatorWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public DoubleUnaryOperatorWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public DoubleUnaryOperatorWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyAsDoubleWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

