/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface DoubleSupplierWithThrowable<E extends Throwable>
extends DoubleSupplier {
    public static <E extends Throwable> DoubleSupplierWithThrowable<E> castDoubleSupplierWithThrowable(DoubleSupplierWithThrowable<E> doublesupplierwiththrowable) {
        return doublesupplierwiththrowable;
    }

    public static <E extends Throwable> DoubleSupplier aDoubleSupplierThatUnsafelyThrowsUnchecked(DoubleSupplierWithThrowable<E> doublesupplierwiththrowable) throws E {
        return doublesupplierwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> DoubleSupplierWithThrowable<E> asDoubleSupplierWithThrowable(DoubleSupplier doublesupplier) {
        return doublesupplier::getAsDouble;
    }

    @Override
    default public double getAsDouble() {
        try {
            return this.getAsDoubleWithThrowable();
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public double getAsDoubleWithThrowable() throws E;

    default public DoubleSupplier thatReturnsOnCatch(double defaultReturnValue) {
        return () -> {
            try {
                return this.getAsDoubleWithThrowable();
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public DoubleSupplier thatUnsafelyThrowsUnchecked() throws E {
        return () -> {
            try {
                return this.getAsDoubleWithThrowable();
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0.0;
            }
        };
    }

    default public DoubleSupplierWithThrowable<E> withLogging(Logger logger, String message) {
        return () -> {
            try {
                return this.getAsDoubleWithThrowable();
            }
            catch (Throwable throwable) {
                logger.error(message, throwable);
                throw throwable;
            }
        };
    }

    default public DoubleSupplierWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in DoubleSupplierWithThrowable");
    }

    default public DoubleSupplierWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public DoubleSupplierWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return () -> {
            try {
                return this.getAsDoubleWithThrowable();
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }
}

