/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface DoubleBinaryOperatorWithThrowable<E extends Throwable>
extends DoubleBinaryOperator {
    public static <E extends Throwable> DoubleBinaryOperatorWithThrowable<E> castDoubleBinaryOperatorWithThrowable(DoubleBinaryOperatorWithThrowable<E> doublebinaryoperatorwiththrowable) {
        return doublebinaryoperatorwiththrowable;
    }

    public static <E extends Throwable> DoubleBinaryOperator aDoubleBinaryOperatorThatUnsafelyThrowsUnchecked(DoubleBinaryOperatorWithThrowable<E> doublebinaryoperatorwiththrowable) throws E {
        return doublebinaryoperatorwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> DoubleBinaryOperatorWithThrowable<E> asDoubleBinaryOperatorWithThrowable(DoubleBinaryOperator doublebinaryoperator) {
        return doublebinaryoperator::applyAsDouble;
    }

    @Override
    default public double applyAsDouble(double v1, double v2) {
        try {
            return this.applyAsDoubleWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public double applyAsDoubleWithThrowable(double var1, double var3) throws E;

    default public DoubleBinaryOperator thatReturnsOnCatch(double defaultReturnValue) {
        return (v1, v2) -> {
            try {
                return this.applyAsDoubleWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public DoubleBinaryOperator thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                return this.applyAsDoubleWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0.0;
            }
        };
    }

    default public DoubleBinaryOperatorWithThrowable<E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                return this.applyAsDoubleWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public DoubleBinaryOperatorWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in DoubleBinaryOperatorWithThrowable with the arguments [{}, {}]");
    }

    default public DoubleBinaryOperatorWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public DoubleBinaryOperatorWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsDoubleWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public DoubleBinaryOperatorWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsDoubleWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

