/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface BiFunctionWithThrowable<T, U, R, E extends Throwable>
extends BiFunction<T, U, R> {
    public static <T, U, R, E extends Throwable> BiFunctionWithThrowable<T, U, R, E> castBiFunctionWithThrowable(BiFunctionWithThrowable<T, U, R, E> bifunctionwiththrowable) {
        return bifunctionwiththrowable;
    }

    public static <T, U, R, E extends Throwable> BiFunction<T, U, R> aBiFunctionThatUnsafelyThrowsUnchecked(BiFunctionWithThrowable<T, U, R, E> bifunctionwiththrowable) throws E {
        return bifunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, U, R, E extends Throwable> BiFunctionWithThrowable<T, U, R, E> asBiFunctionWithThrowable(BiFunction<T, U, R> bifunction) {
        return bifunction::apply;
    }

    @Override
    default public R apply(T v1, U v2) {
        try {
            return this.applyWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public R applyWithThrowable(T var1, U var2) throws E;

    default public BiFunction<T, U, Optional<R>> thatReturnsOptional() {
        return (v1, v2) -> {
            try {
                return Optional.ofNullable(this.applyWithThrowable(v1, v2));
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        };
    }

    default public BiFunction<T, U, R> thatReturnsOnCatch(R defaultReturnValue) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public BiFunction<T, U, R> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public BiFunctionWithThrowable<T, U, R, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public BiFunctionWithThrowable<T, U, R, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in BiFunctionWithThrowable with the arguments [{}, {}]");
    }

    default public BiFunctionWithThrowable<T, U, R, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public BiFunctionWithThrowable<T, U, R, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public BiFunctionWithThrowable<T, U, R, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

