/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.auth.user;

import io.conduktor.auth.sub.SubscriptionType;
import io.conduktor.auth.user.IdentityOrigin;
import io.conduktor.auth.user.SubscriptionFallbackReason;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\b\u0086\b\u0018\u0000 D2\u00020\u0001:\u0001DBO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u00101\u001a\u00020\fH\u00c6\u0003J\t\u00102\u001a\u00020\u000eH\u00c2\u0003J\t\u00103\u001a\u00020\u000eH\u00c6\u0003J\t\u00104\u001a\u00020\u0011H\u00c6\u0003Je\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u00106\u001a\u00020\u00052\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00108\u001a\u000209H\u00d6\u0001J\u0006\u0010:\u001a\u00020\u0005J\u0006\u0010;\u001a\u00020\u0005J\u0014\u0010<\u001a\u00020\u00052\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0>J\u0006\u0010?\u001a\u00020\u0005J\u0006\u0010@\u001a\u00020\u0005J\u0006\u0010A\u001a\u00020\bJ\b\u0010B\u001a\u00020\u0003H\u0016J\u0006\u0010C\u001a\u00020\u0005R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0015R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0017R\u0011\u0010*\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0015\u00a8\u0006E"}, d2={"Lio/conduktor/auth/user/ConduktorUser;", "", "email", "", "emailVerified", "", "username", "originalSubscriptionType", "Lio/conduktor/auth/sub/SubscriptionType;", "fallback", "Lio/conduktor/auth/user/SubscriptionFallbackReason;", "subscriptionExpiry", "Ljava/time/LocalDate;", "tokenIssueAt", "Ljava/util/Date;", "tokenExpirationDate", "identityOrigin", "Lio/conduktor/auth/user/IdentityOrigin;", "(Ljava/lang/String;ZLjava/lang/String;Lio/conduktor/auth/sub/SubscriptionType;Lio/conduktor/auth/user/SubscriptionFallbackReason;Ljava/time/LocalDate;Ljava/util/Date;Ljava/util/Date;Lio/conduktor/auth/user/IdentityOrigin;)V", "currentPlanMessage", "getEmail", "()Ljava/lang/String;", "getEmailVerified", "()Z", "expirationMessage", "getFallback", "()Lio/conduktor/auth/user/SubscriptionFallbackReason;", "getIdentityOrigin", "()Lio/conduktor/auth/user/IdentityOrigin;", "inTrial", "getOriginalSubscriptionType", "()Lio/conduktor/auth/sub/SubscriptionType;", "getSubscriptionExpiry", "()Ljava/time/LocalDate;", "subscriptionMessage", "getSubscriptionMessage", "getTokenExpirationDate", "()Ljava/util/Date;", "trialMessage", "getUsername", "wasTrial", "getWasTrial", "welcomeMessage", "getWelcomeMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "isAwesomeDev", "isOffline", "isOneOf", "types", "", "isOnline", "subscriptionExpired", "subscriptionToConsider", "toString", "tokenExpired", "Companion", "auth"})
public final class ConduktorUser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String email;
    private final boolean emailVerified;
    @NotNull
    private final String username;
    @NotNull
    private final SubscriptionType originalSubscriptionType;
    @Nullable
    private final SubscriptionFallbackReason fallback;
    @NotNull
    private final LocalDate subscriptionExpiry;
    @NotNull
    private final Date tokenIssueAt;
    @NotNull
    private final Date tokenExpirationDate;
    @NotNull
    private final IdentityOrigin identityOrigin;
    private final boolean wasTrial;
    private final boolean inTrial;
    @NotNull
    private final String expirationMessage;
    @NotNull
    private final String trialMessage;
    @NotNull
    private final String currentPlanMessage;
    @NotNull
    private final String welcomeMessage;
    @NotNull
    private final String subscriptionMessage;
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.ENGLISH).withZone(ZoneId.systemDefault());
    @NotNull
    private static final String ns = "https://conduktor.io/";

    public ConduktorUser(@NotNull String email, boolean emailVerified, @NotNull String username, @NotNull SubscriptionType originalSubscriptionType, @Nullable SubscriptionFallbackReason fallback, @NotNull LocalDate subscriptionExpiry, @NotNull Date tokenIssueAt, @NotNull Date tokenExpirationDate, @NotNull IdentityOrigin identityOrigin) {
        this.email = email;
        this.emailVerified = emailVerified;
        this.username = username;
        this.originalSubscriptionType = originalSubscriptionType;
        this.fallback = fallback;
        this.subscriptionExpiry = subscriptionExpiry;
        this.tokenIssueAt = tokenIssueAt;
        this.tokenExpirationDate = tokenExpirationDate;
        this.identityOrigin = identityOrigin;
        this.wasTrial = this.originalSubscriptionType == SubscriptionType.TRIALING;
        boolean bl = this.inTrial = this.subscriptionToConsider() == SubscriptionType.TRIALING;
        this.expirationMessage = this.wasTrial ? "Free" : (this.originalSubscriptionType == SubscriptionType.DEVELOPER ? "Your " + SubscriptionType.PROFESSIONAL.getLabel() + " plan has expired" : "Your " + this.originalSubscriptionType.getLabel() + " plan has expired");
        this.trialMessage = "On trial until " + dateFormatter.format(this.subscriptionExpiry);
        this.currentPlanMessage = this.subscriptionToConsider().printLabel() + " plan";
        this.welcomeMessage = "Hello, " + this.username + "!";
        this.subscriptionMessage = this.subscriptionExpired() ? this.expirationMessage : (this.inTrial ? this.trialMessage : this.currentPlanMessage);
    }

    @NotNull
    public final String getEmail() {
        return this.email;
    }

    public final boolean getEmailVerified() {
        return this.emailVerified;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final SubscriptionType getOriginalSubscriptionType() {
        return this.originalSubscriptionType;
    }

    @Nullable
    public final SubscriptionFallbackReason getFallback() {
        return this.fallback;
    }

    @NotNull
    public final LocalDate getSubscriptionExpiry() {
        return this.subscriptionExpiry;
    }

    @NotNull
    public final Date getTokenExpirationDate() {
        return this.tokenExpirationDate;
    }

    @NotNull
    public final IdentityOrigin getIdentityOrigin() {
        return this.identityOrigin;
    }

    public final boolean getWasTrial() {
        return this.wasTrial;
    }

    @NotNull
    public final String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    @NotNull
    public final String getSubscriptionMessage() {
        return this.subscriptionMessage;
    }

    public final boolean isOneOf(@NotNull List<? extends SubscriptionType> types) {
        return types.isEmpty() || types.contains((Object)this.subscriptionToConsider());
    }

    public final boolean tokenExpired() {
        return this.tokenExpirationDate.before(Date.from(Instant.now()));
    }

    public final boolean isOnline() {
        return this.identityOrigin instanceof IdentityOrigin.OnlineIdentityOrigin;
    }

    public final boolean isOffline() {
        return this.identityOrigin instanceof IdentityOrigin.OfflineIdentityOrigin;
    }

    public final boolean subscriptionExpired() {
        return this.originalSubscriptionType != SubscriptionType.FREE && this.subscriptionExpiry.compareTo(LocalDate.now(ZoneOffset.UTC)) < 0;
    }

    @NotNull
    public final SubscriptionType subscriptionToConsider() {
        return this.tokenExpired() || this.subscriptionExpired() ? SubscriptionType.FREE : (this.originalSubscriptionType == SubscriptionType.DEVELOPER ? SubscriptionType.PROFESSIONAL : this.originalSubscriptionType);
    }

    @NotNull
    public String toString() {
        return "ConduktorUser(email='" + this.email + "', originalSubscriptionType=" + this.originalSubscriptionType + ", subscriptionExpiry=" + this.subscriptionExpiry + ", tokenExpirationDate=" + this.tokenExpirationDate + ")";
    }

    public final boolean isAwesomeDev() {
        return StringsKt.endsWith$default((String)this.email, (String)"@conduktor.io", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String component1() {
        return this.email;
    }

    public final boolean component2() {
        return this.emailVerified;
    }

    @NotNull
    public final String component3() {
        return this.username;
    }

    @NotNull
    public final SubscriptionType component4() {
        return this.originalSubscriptionType;
    }

    @Nullable
    public final SubscriptionFallbackReason component5() {
        return this.fallback;
    }

    @NotNull
    public final LocalDate component6() {
        return this.subscriptionExpiry;
    }

    private final Date component7() {
        return this.tokenIssueAt;
    }

    @NotNull
    public final Date component8() {
        return this.tokenExpirationDate;
    }

    @NotNull
    public final IdentityOrigin component9() {
        return this.identityOrigin;
    }

    @NotNull
    public final ConduktorUser copy(@NotNull String email, boolean emailVerified, @NotNull String username, @NotNull SubscriptionType originalSubscriptionType, @Nullable SubscriptionFallbackReason fallback, @NotNull LocalDate subscriptionExpiry, @NotNull Date tokenIssueAt, @NotNull Date tokenExpirationDate, @NotNull IdentityOrigin identityOrigin) {
        return new ConduktorUser(email, emailVerified, username, originalSubscriptionType, fallback, subscriptionExpiry, tokenIssueAt, tokenExpirationDate, identityOrigin);
    }

    public static /* synthetic */ ConduktorUser copy$default(ConduktorUser conduktorUser, String string, boolean bl, String string2, SubscriptionType subscriptionType, SubscriptionFallbackReason subscriptionFallbackReason, LocalDate localDate, Date date, Date date2, IdentityOrigin identityOrigin, int n, Object object) {
        if ((n & 1) != 0) {
            string = conduktorUser.email;
        }
        if ((n & 2) != 0) {
            bl = conduktorUser.emailVerified;
        }
        if ((n & 4) != 0) {
            string2 = conduktorUser.username;
        }
        if ((n & 8) != 0) {
            subscriptionType = conduktorUser.originalSubscriptionType;
        }
        if ((n & 0x10) != 0) {
            subscriptionFallbackReason = conduktorUser.fallback;
        }
        if ((n & 0x20) != 0) {
            localDate = conduktorUser.subscriptionExpiry;
        }
        if ((n & 0x40) != 0) {
            date = conduktorUser.tokenIssueAt;
        }
        if ((n & 0x80) != 0) {
            date2 = conduktorUser.tokenExpirationDate;
        }
        if ((n & 0x100) != 0) {
            identityOrigin = conduktorUser.identityOrigin;
        }
        return conduktorUser.copy(string, bl, string2, subscriptionType, subscriptionFallbackReason, localDate, date, date2, identityOrigin);
    }

    public int hashCode() {
        int result = this.email.hashCode();
        int n = this.emailVerified ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.username.hashCode();
        result = result * 31 + this.originalSubscriptionType.hashCode();
        result = result * 31 + (this.fallback == null ? 0 : this.fallback.hashCode());
        result = result * 31 + this.subscriptionExpiry.hashCode();
        result = result * 31 + this.tokenIssueAt.hashCode();
        result = result * 31 + this.tokenExpirationDate.hashCode();
        result = result * 31 + this.identityOrigin.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConduktorUser)) {
            return false;
        }
        ConduktorUser conduktorUser = (ConduktorUser)other;
        if (!Intrinsics.areEqual((Object)this.email, (Object)conduktorUser.email)) {
            return false;
        }
        if (this.emailVerified != conduktorUser.emailVerified) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.username, (Object)conduktorUser.username)) {
            return false;
        }
        if (this.originalSubscriptionType != conduktorUser.originalSubscriptionType) {
            return false;
        }
        if (this.fallback != conduktorUser.fallback) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subscriptionExpiry, (Object)conduktorUser.subscriptionExpiry)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenIssueAt, (Object)conduktorUser.tokenIssueAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenExpirationDate, (Object)conduktorUser.tokenExpirationDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.identityOrigin, (Object)conduktorUser.identityOrigin);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/conduktor/auth/user/ConduktorUser$Companion;", "", "()V", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "ns", "", "fromClaims", "Lio/conduktor/auth/user/ConduktorUser;", "identityOrigin", "Lio/conduktor/auth/user/IdentityOrigin;", "claims", "Lio/jsonwebtoken/Jws;", "Lio/jsonwebtoken/Claims;", "auth"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ConduktorUser fromClaims(@NotNull IdentityOrigin identityOrigin, @NotNull Jws<Claims> claims) {
            Object object;
            SubscriptionFallbackReason subscriptionFallbackReason;
            Object object2;
            String string;
            boolean bl;
            Object object3;
            block10: {
                block9: {
                    void it;
                    String string2;
                    Object object4;
                    String it2;
                    Object object5;
                    boolean bl2;
                    String string3;
                    block8: {
                        block7: {
                            Object object6;
                            object3 = ((Claims)claims.getBody()).get((Object)"email");
                            if (object3 == null || (object3 = object3.toString()) == null) {
                                String string4 = io.conduktor.auth.user.ConduktorUser$Companion.fromClaims$ourClaim(claims, "subscription_email");
                                object3 = string4;
                                Intrinsics.checkNotNull((Object)string4);
                            }
                            bl = (object6 = ((Claims)claims.getBody()).get((Object)"email_verified")) != null && (object6 = object6.toString()) != null ? Boolean.parseBoolean((String)object6) : true;
                            string = String.valueOf(((Claims)claims.getBody()).get((Object)"name"));
                            object2 = io.conduktor.auth.user.ConduktorUser$Companion.fromClaims$ourClaim(claims, "subscription_type");
                            if (object2 == null) break block7;
                            String string5 = object2;
                            string3 = string;
                            bl2 = bl;
                            object5 = object3;
                            boolean bl3 = false;
                            object4 = SubscriptionType.Companion.fromUnsafe(it2);
                            object3 = object5;
                            bl = bl2;
                            string = string3;
                            SubscriptionType subscriptionType = object4;
                            object2 = subscriptionType;
                            if (subscriptionType != null) break block8;
                        }
                        object2 = SubscriptionType.FREE;
                    }
                    subscriptionFallbackReason = SubscriptionFallbackReason.Companion.fromUnsafe(io.conduktor.auth.user.ConduktorUser$Companion.fromClaims$ourClaim(claims, "subscription_fallback_reason"));
                    object = io.conduktor.auth.user.ConduktorUser$Companion.fromClaims$ourClaim(claims, "subscription_expiry");
                    if (object == null) break block9;
                    it2 = string2 = object;
                    SubscriptionFallbackReason subscriptionFallbackReason2 = subscriptionFallbackReason;
                    object4 = object2;
                    string3 = string;
                    bl2 = bl;
                    object5 = object3;
                    boolean $i$a$-takeIf-ConduktorUser$Companion$fromClaims$32 = false;
                    boolean bl4 = ((CharSequence)it2).length() > 0;
                    object3 = object5;
                    bl = bl2;
                    string = string3;
                    object2 = object4;
                    subscriptionFallbackReason = subscriptionFallbackReason2;
                    object = bl4 ? string2 : null;
                    if (object == null) break block9;
                    Object $i$a$-takeIf-ConduktorUser$Companion$fromClaims$32 = object;
                    subscriptionFallbackReason2 = subscriptionFallbackReason;
                    object4 = object2;
                    string3 = string;
                    bl2 = bl;
                    object5 = object3;
                    boolean bl5 = false;
                    LocalDate localDate = LocalDate.parse((CharSequence)it);
                    object3 = object5;
                    bl = bl2;
                    string = string3;
                    object2 = object4;
                    subscriptionFallbackReason = subscriptionFallbackReason2;
                    LocalDate localDate2 = localDate;
                    object = localDate2;
                    if (localDate2 != null) break block10;
                }
                object = LocalDate.MIN;
            }
            IdentityOrigin identityOrigin2 = identityOrigin;
            Date date = ((Claims)claims.getBody()).getExpiration();
            Date date2 = ((Claims)claims.getBody()).getIssuedAt();
            Object object7 = object;
            SubscriptionFallbackReason subscriptionFallbackReason3 = subscriptionFallbackReason;
            Object object8 = object2;
            String string6 = string;
            boolean bl6 = bl;
            Object object9 = object3;
            return new ConduktorUser((String)object9, bl6, string6, (SubscriptionType)((Object)object8), subscriptionFallbackReason3, (LocalDate)object7, date2, date, identityOrigin2);
        }

        private static final String fromClaims$ourClaim(Jws<Claims> $claims, String claim) {
            Object object = ((Claims)$claims.getBody()).get((Object)(ConduktorUser.ns + claim));
            return object != null ? object.toString() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

