/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.auth.offline;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import io.conduktor.auth.user.ConduktorUser;
import io.conduktor.auth.user.IdentityOrigin;
import io.conduktor.auth.user.Logging;
import io.conduktor.common.locale.Locales;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/conduktor/auth/offline/OfflineAuthClient;", "", "()V", "conduktorOfflineTokenPrivateKey", "", "keysInMemory", "", "getKeysInMemory$auth", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "portalTokenPublicKey", "decodeTokenToJws", "Larrow/core/Either;", "", "", "token", "email", "decodeTokenToUser", "Lio/conduktor/auth/user/ConduktorUser;", "encodeJwsToToken", "jws", "generateOfflineConduktorCode", "createdAt", "Ljava/time/LocalDateTime;", "jwsToUser", "ignoreSignature", "Companion", "auth"})
public final class OfflineAuthClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final byte[] conduktorOfflineTokenPrivateKey = TextStreamsKt.readBytes((URL)this.getClass().getResource("/jwt/conduktor_private_key.der"));
    @NotNull
    private final byte[] portalTokenPublicKey = TextStreamsKt.readBytes((URL)this.getClass().getResource("/jwt/portal_public_key.der"));
    private final boolean keysInMemory = !(this.conduktorOfflineTokenPrivateKey.length == 0) && !(this.portalTokenPublicKey.length == 0);

    public final boolean getKeysInMemory$auth() {
        return this.keysInMemory;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Either<Throwable, String> encodeJwsToToken(@NotNull String jws, @NotNull String email) {
        Either either;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            void $this$encodeJwsToToken_u24lambda_u2d1_u24lambda_u2d0;
            boolean bl = false;
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            String string = email.toLowerCase(Locales.INSTANCE.getForLegacyPersistedValues());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] emailHash = sha.digest(byArray);
            SecretKeySpec secretKey = new SecretKeySpec(emailHash, "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            Base64.Encoder encoder = Base64.getEncoder();
            boolean bl2 = false;
            $this$encodeJwsToToken_u24lambda_u2d1_u24lambda_u2d0.init(1, secretKey);
            byte[] byArray2 = jws.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = encoder.encode($this$encodeJwsToToken_u24lambda_u2d1_u24lambda_u2d0.doFinal(byArray2));
            either = EitherKt.right((Object)new String(byArray3, Charsets.UTF_8));
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        return either;
    }

    @NotNull
    public final Either<Throwable, String> generateOfflineConduktorCode(@NotNull String email, @NotNull LocalDateTime createdAt) {
        Either<Throwable, String> either;
        Either<Throwable, String> either2;
        String string = email.toLowerCase(Locales.INSTANCE.getForLegacyPersistedValues());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
        String emailLC = string;
        Either<Throwable, String> $this$flatMap$iv = OfflineAuthClient.Companion.privateKey(this.conduktorOfflineTokenPrivateKey);
        boolean $i$f$flatMap = false;
        Either<Throwable, String> either3 = $this$flatMap$iv;
        if (either3 instanceof Either.Right) {
            Either either4;
            PrivateKey key = (PrivateKey)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl2 = false;
                Date expiration = Date.from(createdAt.plusMonths(1L).atZone(ZoneId.of("UTC")).toInstant());
                Date dateCreatedAt = Date.from(createdAt.atZone(ZoneId.of("UTC")).toInstant());
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"version", (Object)1), TuplesKt.to((Object)"signature", (Object)Logging.INSTANCE.getSignature())};
                either4 = EitherKt.right((Object)Jwts.builder().setIssuer("conduktor-desktop").setAudience("conduktor-portal").setIssuedAt(dateCreatedAt).setExpiration(expiration).addClaims(MapsKt.mapOf((Pair[])pairArray)).signWith((Key)key).compact());
            }
            catch (Throwable t$iv) {
                either4 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            either2 = either4;
        } else if (either3 instanceof Either.Left) {
            either2 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = either2;
        $i$f$flatMap = false;
        either3 = $this$flatMap$iv;
        if (either3 instanceof Either.Right) {
            String it = (String)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            either = this.encodeJwsToToken(it, emailLC);
        } else if (either3 instanceof Either.Left) {
            either = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @NotNull
    public final Either<Throwable, ConduktorUser> decodeTokenToUser(@NotNull String token, @NotNull String email) {
        Either either;
        Either $this$flatMap$iv = this.decodeTokenToJws(token, email);
        boolean $i$f$flatMap = false;
        Either either2 = $this$flatMap$iv;
        if (either2 instanceof Either.Right) {
            String it = (String)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            either = OfflineAuthClient.jwsToUser$default(this, it, false, 2, null);
        } else if (either2 instanceof Either.Left) {
            either = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @NotNull
    public final Either<Throwable, String> decodeTokenToJws(@NotNull String token, @NotNull String email) {
        Either either;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            boolean bl = false;
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            String string = email.toLowerCase(Locales.INSTANCE.getForLegacyPersistedValues());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] hash = sha.digest(byArray);
            SecretKeySpec secret = new SecretKeySpec(hash, "Blowfish");
            Cipher $this$decodeTokenToJws_u24lambda_u2d7_u24lambda_u2d6 = Cipher.getInstance("Blowfish");
            boolean bl2 = false;
            $this$decodeTokenToJws_u24lambda_u2d7_u24lambda_u2d6.init(2, secret);
            byte[] byArray2 = $this$decodeTokenToJws_u24lambda_u2d7_u24lambda_u2d6.doFinal(Base64.getDecoder().decode(token));
            either = EitherKt.right((Object)new String(byArray2, Charsets.UTF_8));
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        return either;
    }

    @NotNull
    public final Either<Throwable, ConduktorUser> jwsToUser(@NotNull String jws, boolean ignoreSignature) {
        Either either;
        Either $this$flatMap$iv = OfflineAuthClient.Companion.publicKey(this.portalTokenPublicKey);
        boolean $i$f$flatMap = false;
        Either either2 = $this$flatMap$iv;
        if (either2 instanceof Either.Right) {
            Either either3;
            PublicKey key = (PublicKey)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl2 = false;
                Jws claims = Jwts.parserBuilder().requireIssuer("conduktor-portal").requireAudience("conduktor-desktop").setSigningKey((Key)key).build().parseClaimsJws(jws);
                if (!ignoreSignature && !Intrinsics.areEqual((Object)String.valueOf(((Claims)claims.getBody()).get((Object)"signature")), (Object)Logging.INSTANCE.getSignature())) {
                    this.logger.warn("A different machine signature was found in the offline token, ignoring...");
                    throw new Exception("An offline token can only be used on the machine that requested it.");
                }
                either3 = EitherKt.right((Object)ConduktorUser.Companion.fromClaims(new IdentityOrigin.OfflineIdentityOrigin(jws), (Jws<Claims>)claims));
            }
            catch (Throwable t$iv) {
                either3 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            either = either3;
        } else if (either2 instanceof Either.Left) {
            either = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    public static /* synthetic */ Either jwsToUser$default(OfflineAuthClient offlineAuthClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return offlineAuthClient.jwsToUser(string, bl);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lio/conduktor/auth/offline/OfflineAuthClient$Companion;", "", "()V", "privateKey", "Larrow/core/Either;", "", "Ljava/security/PrivateKey;", "pkey", "", "publicKey", "Ljava/security/PublicKey;", "auth"})
    public static final class Companion {
        private Companion() {
        }

        private final Either<Throwable, PrivateKey> privateKey(byte[] pkey) {
            Either either;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl = false;
                KeyFactory kf = KeyFactory.getInstance("RSA");
                either = EitherKt.right((Object)kf.generatePrivate(new PKCS8EncodedKeySpec(pkey)));
            }
            catch (Throwable t$iv) {
                either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either;
        }

        private final Either<Throwable, PublicKey> publicKey(byte[] pkey) {
            Either either;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl = false;
                KeyFactory kf = KeyFactory.getInstance("RSA");
                either = EitherKt.right((Object)kf.generatePublic(new X509EncodedKeySpec(pkey)));
            }
            catch (Throwable t$iv) {
                either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

