/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.auth.http;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import com.github.kittinunf.fuel.FuelKt;
import com.github.kittinunf.fuel.core.FuelError;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.Response;
import com.github.kittinunf.fuel.core.extensions.JsonBodyKt;
import com.github.kittinunf.fuel.json.FuelJson;
import com.github.kittinunf.fuel.json.FuelJsonKt;
import com.github.kittinunf.result.Result;
import com.sun.net.httpserver.HttpExchange;
import io.conduktor.auth.AuthConfiguration;
import io.conduktor.auth.AuthException;
import io.conduktor.auth.flow.AccessToken;
import io.conduktor.auth.flow.IdToken;
import io.conduktor.auth.flow.JwtHelper;
import io.conduktor.auth.flow.PKCE;
import io.conduktor.auth.flow.PKCEChallenge;
import io.conduktor.auth.flow.RefreshToken;
import io.conduktor.auth.flow.Tokens;
import io.conduktor.auth.http.AuthClient;
import io.conduktor.auth.http.HttpHelper;
import io.conduktor.auth.http.HttpHelperKt;
import io.conduktor.auth.http.LocalAuthHttpServer;
import io.conduktor.auth.user.ConduktorUser;
import io.conduktor.auth.user.IdentityOrigin;
import io.conduktor.auth.user.Logging;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 C2\u00020\u0001:\u0001CB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ*\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\tH\u0016J'\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0 2\u0006\u0010)\u001a\u00020*\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,J,\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$0 2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00100\u001a\u000201H\u0002J\u001a\u00105\u001a\u00020\u00032\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\t0\u0007J\u0006\u00108\u001a\u00020\u0003J,\u00109\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010:\u001a\u00020;2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\t0\u0007H\u0002J,\u0010<\u001a\u00020\t2\u0006\u0010:\u001a\u00020;2\u0006\u00100\u001a\u0002012\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\t0\u0007H\u0002J'\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$0 2\u0006\u0010)\u001a\u00020*\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b>\u0010,J(\u0010?\u001a\u00020\t2\u0006\u0010:\u001a\u00020;2\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006D"}, d2={"Lio/conduktor/auth/http/AuthClient;", "Ljava/lang/AutoCloseable;", "appVersion", "", "config", "Lio/conduktor/auth/AuthConfiguration;", "errorTracker", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;Lio/conduktor/auth/AuthConfiguration;Lkotlin/jvm/functions/Function1;)V", "getAppVersion", "()Ljava/lang/String;", "getConfig", "()Lio/conduktor/auth/AuthConfiguration;", "getErrorTracker", "()Lkotlin/jvm/functions/Function1;", "failedHtmlTemplate", "httpServer", "Lio/conduktor/auth/http/LocalAuthHttpServer;", "getHttpServer", "()Lio/conduktor/auth/http/LocalAuthHttpServer;", "httpServer$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pkceChallenges", "", "Lio/conduktor/auth/flow/PKCEChallenge;", "successHtmlTemplate", "claims", "Larrow/core/Either;", "Lio/jsonwebtoken/Jws;", "Lio/jsonwebtoken/Claims;", "tokens", "Lio/conduktor/auth/flow/Tokens;", "publicKey", "Ljava/security/PublicKey;", "close", "dropRefreshToken", "refreshToken", "Lio/conduktor/auth/flow/RefreshToken;", "dropRefreshToken-j0cGsus", "(Ljava/lang/String;)Larrow/core/Either;", "exchangeCodeForTokens", "verifier", "code", "port", "", "getAuthorizationUrl", "challenge", "state", "getLoginScreenUrl", "updateUser", "Lio/conduktor/auth/user/ConduktorUser;", "getLogoutUrl", "parseTokens", "http", "Lcom/sun/net/httpserver/HttpExchange;", "processHttpResponse", "refreshTokens", "refreshTokens-j0cGsus", "sendError", "logMessage", "httpCode", "ex", "Companion", "auth"})
public final class AuthClient
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String appVersion;
    @NotNull
    private final AuthConfiguration config;
    @NotNull
    private final Function1<Throwable, Unit> errorTracker;
    private final Logger logger;
    @NotNull
    private final Lazy httpServer$delegate;
    @NotNull
    private final String successHtmlTemplate;
    @NotNull
    private final String failedHtmlTemplate;
    @NotNull
    private final List<PKCEChallenge> pkceChallenges;

    public AuthClient(@NotNull String appVersion, @NotNull AuthConfiguration config, @NotNull Function1<? super Throwable, Unit> errorTracker) {
        this.appVersion = appVersion;
        this.config = config;
        this.errorTracker = errorTracker;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.httpServer$delegate = LazyKt.lazy((Function0)httpServer.2.INSTANCE);
        URL uRL = this.getClass().getResource("/successful_login.html");
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        this.successHtmlTemplate = StringsKt.replace$default((String)new String(byArray, charset), (String)"{success-url}", (String)this.config.getOnSuccessUrl(), (boolean)false, (int)4, null);
        uRL = this.getClass().getResource("/failed_login.html");
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL);
        this.failedHtmlTemplate = StringsKt.replace$default((String)new String(byArray, charset), (String)"{failure-url}", (String)this.config.getOnFailureUrl(), (boolean)false, (int)4, null);
        this.pkceChallenges = new ArrayList();
    }

    @NotNull
    public final String getAppVersion() {
        return this.appVersion;
    }

    @NotNull
    public final AuthConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final Function1<Throwable, Unit> getErrorTracker() {
        return this.errorTracker;
    }

    private final LocalAuthHttpServer getHttpServer() {
        Lazy lazy = this.httpServer$delegate;
        return (LocalAuthHttpServer)lazy.getValue();
    }

    @NotNull
    public final String getLoginScreenUrl(@NotNull Function1<? super ConduktorUser, Unit> updateUser) {
        int port2 = this.getHttpServer().startHttpServerIfNotUpYet((Function2<? super HttpExchange, ? super Integer, Unit>)((Function2)new Function2<HttpExchange, Integer, Unit>(this, updateUser){
            final /* synthetic */ AuthClient this$0;
            final /* synthetic */ Function1<ConduktorUser, Unit> $updateUser;
            {
                this.this$0 = $receiver;
                this.$updateUser = $updateUser;
                super(2);
            }

            public final void invoke(@NotNull HttpExchange http, int port2) {
                AuthClient.access$processHttpResponse(this.this$0, http, port2, this.$updateUser);
            }
        }));
        PKCEChallenge pkce = PKCE.INSTANCE.random();
        this.logger.debug("New PKCE: " + pkce);
        this.pkceChallenges.add(pkce);
        String authUrl = this.getAuthorizationUrl(pkce.getChallenge(), pkce.getState(), port2);
        this.logger.debug("Authorization Url: " + authUrl);
        return authUrl;
    }

    private final void processHttpResponse(HttpExchange http, int port2, Function1<? super ConduktorUser, Unit> updateUser) {
        Object v2;
        String state;
        String code;
        block9: {
            Map<String, String> qs = HttpHelper.INSTANCE.parseQueryString(http.getRequestURI().getQuery());
            this.logger.trace("Got " + qs);
            String error = qs.get("error");
            if (error != null) {
                String errorDescription = qs.get("error_description");
                this.logger.warn("Error during authentication callback: " + error + ": " + errorDescription);
                String string = errorDescription;
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Too many logins", (boolean)false, (int)2, null) : false;
                if (bl) {
                    HttpHelperKt.sendResponse(http, 500, StringsKt.replace$default((String)this.failedHtmlTemplate, (String)"{error}", (String)"too_many_logins", (boolean)false, (int)4, null));
                } else {
                    HttpHelperKt.sendResponse(http, 500, StringsKt.replace$default((String)this.failedHtmlTemplate, (String)"{error}", (String)error, (boolean)false, (int)4, null));
                }
                return;
            }
            code = qs.get("code");
            if (code == null) {
                this.logger.warn("No code found. Got: " + http.getRequestURI().getQuery());
                HttpHelperKt.sendResponse(http, 500, StringsKt.replace$default((String)this.failedHtmlTemplate, (String)"{error}", (String)"no_code_found", (boolean)false, (int)4, null));
                this.errorTracker.invoke((Object)new AuthException("Auth: No code found. Got: " + http.getRequestURI().getQuery()));
                return;
            }
            this.logger.trace("Got code: " + code);
            state = qs.get("state");
            Iterable iterable = this.pkceChallenges;
            for (Object t : iterable) {
                PKCEChallenge it = (PKCEChallenge)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getState(), (Object)state)) continue;
                v2 = t;
                break block9;
            }
            v2 = null;
        }
        PKCEChallenge pkce = v2;
        if (pkce == null) {
            this.logger.warn("Could not find corresponding challenge from the state: " + state);
            HttpHelperKt.sendResponse(http, 500, StringsKt.replace$default((String)this.failedHtmlTemplate, (String)"{error}", (String)"unknown_state", (boolean)false, (int)4, null));
            this.errorTracker.invoke((Object)new AuthException("Auth: no corresponding challenge found (looking for " + state + " in " + CollectionsKt.joinToString$default((Iterable)this.pkceChallenges, null, null, null, (int)0, null, (Function1)processHttpResponse.1.INSTANCE, (int)31, null) + ")"));
            return;
        }
        this.logger.trace("Found related PKCE, exchanging code ... (" + pkce + ")");
        Either<Throwable, Tokens> tokens = this.exchangeCodeForTokens(pkce.getVerifier(), code, port2);
        if (tokens instanceof Either.Left) {
            this.sendError(http, "Error while exchanging code for tokens", "token-error", (Throwable)((Either.Left)tokens).getValue());
        } else if (tokens instanceof Either.Right) {
            this.logger.trace("After exchange, tokens: " + ((Either.Right)tokens).getValue());
            this.parseTokens((Tokens)((Either.Right)tokens).getValue(), http, updateUser);
        }
        this.logger.debug("Closing HTTP exchange...");
        http.close();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AuthClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AuthClient.access$getLogger$p(this.this$0).debug("Closing HTTP server...");
                        AuthClient.access$getHttpServer(this.this$0).close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseTokens(Tokens tokens, HttpExchange http, Function1<? super ConduktorUser, Unit> updateUser) {
        Either<Throwable, String> kid = JwtHelper.INSTANCE.readKid-LCiztaE(tokens.getIdToken-mXC59TU());
        if (kid instanceof Either.Left) {
            this.sendError(http, "Error looking for the kid", "kid-error", (Throwable)((Either.Left)kid).getValue());
            return;
        } else {
            Either either;
            Either either2;
            Object it$iv;
            void this_$iv;
            Pair pair;
            Pair $this$flatMap$iv$iv;
            void $this$flatMap$iv;
            if (!(kid instanceof Either.Right)) return;
            Either<Throwable, PublicKey> either3 = JwtHelper.INSTANCE.jwkPublicKey(this.config.getDomain(), (String)((Either.Right)kid).getValue());
            boolean $i$f$flatMap = false;
            void var7_7 = $this$flatMap$iv;
            if (var7_7 instanceof Either.Right) {
                PublicKey pk = (PublicKey)((Either.Right)$this$flatMap$iv).getValue();
                boolean bl = false;
                Pair this_$iv2 = this.claims(tokens, pk);
                boolean $i$f$map = false;
                $this$flatMap$iv$iv = this_$iv2;
                boolean $i$f$flatMap2 = false;
                Pair pair2 = $this$flatMap$iv$iv;
                if (pair2 instanceof Either.Right) {
                    Object it$iv2 = ((Either.Right)$this$flatMap$iv$iv).getValue();
                    boolean bl2 = false;
                    Jws it = (Jws)it$iv2;
                    boolean bl3 = false;
                    Pair pair3 = TuplesKt.to((Object)new IdentityOrigin.OnlineIdentityOrigin(tokens, pk), (Object)it);
                    pair = (Either)new Either.Right((Object)pair3);
                } else {
                    if (!(pair2 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                    pair = $this$flatMap$iv$iv;
                }
            } else {
                if (!(var7_7 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                pair = $this$flatMap$iv;
            }
            $this$flatMap$iv = pair;
            boolean $i$f$map = false;
            void $this$flatMap$iv$iv2 = this_$iv;
            boolean $i$f$flatMap3 = false;
            void var9_11 = $this$flatMap$iv$iv2;
            if (var9_11 instanceof Either.Right) {
                it$iv = ((Either.Right)$this$flatMap$iv$iv2).getValue();
                boolean bl = false;
                $this$flatMap$iv$iv = (Pair)it$iv;
                boolean bl4 = false;
                IdentityOrigin.OnlineIdentityOrigin origin = (IdentityOrigin.OnlineIdentityOrigin)$this$flatMap$iv$iv.component1();
                Jws claims = (Jws)$this$flatMap$iv$iv.component2();
                ConduktorUser user = ConduktorUser.Companion.fromClaims(origin, (Jws<Claims>)claims);
                this.logger.debug("Token identified as: " + user);
                updateUser.invoke((Object)user);
                HttpHelperKt.sendResponse(http, 200, this.successHtmlTemplate);
                Unit unit = Unit.INSTANCE;
                either2 = (Either)new Either.Right((Object)unit);
            } else {
                if (!(var9_11 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                either2 = $this$flatMap$iv$iv2;
            }
            this_$iv = either2;
            boolean $i$f$mapLeft = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$fold = false;
            var9_11 = this_$iv$iv;
            if (var9_11 instanceof Either.Right) {
                it$iv = ((Either.Right)this_$iv$iv).getValue();
                boolean bl = false;
                either = (Either)new Either.Right(it$iv);
                return;
            } else {
                if (!(var9_11 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                it$iv = ((Either.Left)this_$iv$iv).getValue();
                boolean bl = false;
                Throwable ex = (Throwable)it$iv;
                boolean bl5 = false;
                this.sendError(http, "Error with the claims", "claims-error", ex);
                Unit unit = Unit.INSTANCE;
                either = (Either)new Either.Left((Object)unit);
            }
        }
    }

    private final void sendError(HttpExchange http, String logMessage, String httpCode, Throwable ex) {
        this.logger.warn(logMessage, ex);
        HttpHelperKt.sendResponse(http, 500, StringsKt.replace$default((String)this.failedHtmlTemplate, (String)"{error}", (String)(httpCode + "-" + ex.getMessage()), (boolean)false, (int)4, null));
        this.errorTracker.invoke((Object)new AuthException(ex));
    }

    private final Either<Throwable, Jws<Claims>> claims(Tokens tokens, PublicKey publicKey) {
        return Companion.verifyJwts-TenCrxo(this.config, tokens.getIdToken-mXC59TU(), publicKey);
    }

    private final String getAuthorizationUrl(String challenge, String state, int port2) {
        return StringsKt.replace$default((String)StringsKt.trimMargin$default((String)("https://" + this.config.getDomain() + "/authorize\n|?scope=openid+email+profile+offline_access\n|&response_type=code\n|&client_id=" + this.config.getClientId() + "\n|&code_challenge=" + challenge + "\n|&code_challenge_method=S256\n|&redirect_uri=" + StringsKt.replace$default((String)this.config.getRedirectUrl(), (String)"{PORT}", (String)String.valueOf(port2), (boolean)false, (int)4, null) + "\n|&state=" + state + "\n|&cdkfg=" + Logging.INSTANCE.getSignature() + "\n|&cdkv=" + this.appVersion + "\n    "), null, (int)1, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getLogoutUrl() {
        return "https://" + this.config.getDomain() + "/v2/logout?client_id=" + this.config.getClientId();
    }

    private final Either<Throwable, Tokens> exchangeCodeForTokens(String verifier, String code, int port2) {
        Either either;
        Logger logger;
        String string;
        FuelError it;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"client_id", (Object)this.config.getClientId()), TuplesKt.to((Object)"code_verifier", (Object)verifier), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"redirect_uri", (Object)StringsKt.replace$default((String)this.config.getRedirectUrl(), (String)"{PORT}", (String)String.valueOf(port2), (boolean)false, (int)4, null))};
        Request request = FuelKt.httpPost((String)("https://" + this.config.getDomain() + "/oauth/token"), (List)CollectionsKt.listOf((Object[])objectArray)).header("content-type", (Object)"application/x-www-form-urlencoded");
        this.logger.trace(AuthClient.Companion.queryString(request));
        Result response = (Result)FuelJsonKt.responseJson((Request)request).component3();
        Logger logger2 = this.logger;
        Result this_$iv = response;
        boolean $i$f$fold = false;
        Result result = this_$iv;
        if (result instanceof Result.Success) {
            FuelJson fuelJson = (FuelJson)((Result.Success)this_$iv).getValue();
            Logger logger3 = logger2;
            boolean bl = false;
            string = it.obj().toString(2);
            logger = logger3;
        } else if (result instanceof Result.Failure) {
            it = (FuelError)((Result.Failure)this_$iv).getError();
            Logger logger4 = logger2;
            boolean bl = false;
            string = it.getException().getMessage();
            logger = logger4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        logger.trace("Authorization from the Authorization Server: " + string);
        this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            boolean bl = false;
            JSONObject json = ((FuelJson)response.get()).obj();
            String idToken = json.getString("id_token");
            String accessToken = json.getString("access_token");
            String refreshToken = json.getString("refresh_token");
            either = EitherKt.right((Object)new Tokens(AccessToken.constructor-impl(accessToken), RefreshToken.constructor-impl(refreshToken), IdToken.constructor-impl(idToken), null));
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        return either;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Either<Throwable, Tokens> refreshTokens-j0cGsus(@NotNull String refreshToken) {
        Either either;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            Logger logger;
            String string;
            boolean bl = false;
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"refresh_token"), TuplesKt.to((Object)"client_id", (Object)this.config.getClientId()), TuplesKt.to((Object)"refresh_token", (Object)refreshToken), TuplesKt.to((Object)"cdkv", (Object)this.appVersion)};
            Request request = FuelKt.httpPost((String)("https://" + this.config.getDomain() + "/oauth/token"), (List)CollectionsKt.listOf((Object[])objectArray)).header("content-type", (Object)"application/x-www-form-urlencoded");
            this.logger.trace(AuthClient.Companion.queryString(request));
            Result response = (Result)FuelJsonKt.responseJson((Request)request).component3();
            Logger logger2 = this.logger;
            Result this_$iv2 = response;
            boolean $i$f$fold = false;
            Result result = this_$iv2;
            if (result instanceof Result.Success) {
                void it;
                FuelJson fuelJson = (FuelJson)((Result.Success)this_$iv2).getValue();
                Logger logger3 = logger2;
                boolean bl2 = false;
                string = it.obj().toString(2);
                logger = logger3;
            } else if (result instanceof Result.Failure) {
                FuelError it = (FuelError)((Result.Failure)this_$iv2).getError();
                Logger logger4 = logger2;
                boolean bl3 = false;
                string = it.getException().getMessage();
                logger = logger4;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            logger.trace("Refresh response from the Authorization Server: " + string);
            JSONObject json = ((FuelJson)response.get()).obj();
            String idToken = json.getString("id_token");
            String accessToken = json.getString("access_token");
            either = EitherKt.right((Object)new Tokens(AccessToken.constructor-impl(accessToken), refreshToken, IdToken.constructor-impl(idToken), null));
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        return either;
    }

    @NotNull
    public final Either<Throwable, Unit> dropRefreshToken-j0cGsus(@NotNull String refreshToken) {
        Either either;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            boolean bl = false;
            Request request = JsonBodyKt.jsonBody$default((Request)FuelKt.httpPost$default((String)("https://" + this.config.getDomain() + "/oauth/revoke"), null, (int)1, null), (String)("{ \"client_id\": \"" + this.config.getClientId() + "\", \"token\": \"" + refreshToken + "\"}"), null, (int)2, null);
            Response response = (Response)FuelJsonKt.responseJson((Request)request).component2();
            this.logger.debug("Revoke response from the Authorization Server: HTTP " + response.getStatusCode());
            either = EitherKt.right((Object)Unit.INSTANCE);
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        return either;
    }

    @Override
    public void close() {
        this.getHttpServer().close();
    }

    public static final /* synthetic */ void access$processHttpResponse(AuthClient $this, HttpExchange http, int port2, Function1 updateUser) {
        $this.processHttpResponse(http, port2, (Function1<? super ConduktorUser, Unit>)updateUser);
    }

    public static final /* synthetic */ Logger access$getLogger$p(AuthClient $this) {
        return $this.logger;
    }

    public static final /* synthetic */ LocalAuthHttpServer access$getHttpServer(AuthClient $this) {
        return $this.getHttpServer();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J=\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0016"}, d2={"Lio/conduktor/auth/http/AuthClient$Companion;", "", "()V", "publicKeyFromBase64", "Larrow/core/Either;", "", "Ljava/security/PublicKey;", "pkey", "", "queryString", "request", "Lcom/github/kittinunf/fuel/core/Request;", "verifyJwts", "Lio/jsonwebtoken/Jws;", "Lio/jsonwebtoken/Claims;", "authConfig", "Lio/conduktor/auth/AuthConfiguration;", "idToken", "Lio/conduktor/auth/flow/IdToken;", "key", "verifyJwts-TenCrxo", "(Lio/conduktor/auth/AuthConfiguration;Ljava/lang/String;Ljava/security/PublicKey;)Larrow/core/Either;", "auth"})
    public static final class Companion {
        private Companion() {
        }

        private final String queryString(Request request) {
            return CollectionsKt.joinToString$default((Iterable)request.getParameters(), (CharSequence)"&", null, null, (int)0, null, (Function1)queryString.1.INSTANCE, (int)30, null);
        }

        @NotNull
        public final Either<Throwable, Jws<Claims>> verifyJwts-TenCrxo(@NotNull AuthConfiguration authConfig, @NotNull String idToken, @NotNull PublicKey key) {
            Either either;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl = false;
                either = EitherKt.right((Object)Jwts.parserBuilder().requireIssuer("https://" + authConfig.getDomain() + "/").setSigningKey((Key)key).build().parseClaimsJws(idToken));
            }
            catch (Throwable t$iv) {
                either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either;
        }

        @NotNull
        public final Either<Throwable, PublicKey> publicKeyFromBase64(@NotNull String pkey) {
            Either either;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl = false;
                KeyFactory kf = KeyFactory.getInstance("RSA");
                byte[] pkeyAsBytes = Base64.getDecoder().decode(pkey);
                either = EitherKt.right((Object)kf.generatePublic(new X509EncodedKeySpec(pkeyAsBytes)));
            }
            catch (Throwable t$iv) {
                either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

