/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.auth.flow;

import io.conduktor.auth.flow.PKCEChallenge;
import java.security.MessageDigest;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/conduktor/auth/flow/PKCE;", "", "()V", "generateCodeChallenge", "", "verifier", "generateCodeVerifier", "random", "Lio/conduktor/auth/flow/PKCEChallenge;", "auth"})
public final class PKCE {
    @NotNull
    public static final PKCE INSTANCE = new PKCE();

    private PKCE() {
    }

    @NotNull
    public final PKCEChallenge random() {
        String verifier = this.generateCodeVerifier();
        String challenge = this.generateCodeChallenge(verifier);
        String state = this.generateCodeVerifier();
        return new PKCEChallenge(verifier, challenge, state);
    }

    private final String generateCodeVerifier() {
        SecureRandom sr = new SecureRandom();
        byte[] code = new byte[32];
        sr.nextBytes(code);
        return java.util.Base64.getUrlEncoder().withoutPadding().encodeToString(code);
    }

    private final String generateCodeChallenge(String verifier) {
        byte[] byArray = verifier.getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(bytes, 0, bytes.length);
        byte[] digest = md.digest();
        return Base64.encodeBase64URLSafeString((byte[])digest);
    }
}

