/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart.helper;

import io.conduktor.jumpstart.helper.CompressionUtils;
import io.conduktor.jumpstart.helper.CompressionUtils$PosixPermissions$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Has;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged$;
import zio.blocking.package;
import zio.nio.channels.AsynchronousFileChannel;
import zio.nio.channels.AsynchronousFileChannel$;
import zio.nio.file.Files$;
import zio.nio.file.Path;
import zio.package$;
import zio.stream.ZSink;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;
import zio.stream.ZTransducer$;
import zio.stream.compression.CompressionException$;

public final class CompressionUtils$ {
    public static final CompressionUtils$ MODULE$ = new CompressionUtils$();

    public ZIO<Has<package.Blocking.Service>, Exception, BoxedUnit> extractTarGZ(ZStream<Object, IOException, Object> in, Path target) {
        return in.$greater$greater$greater(ZTransducer$.MODULE$.gunzip(ZTransducer$.MODULE$.gunzip$default$1())).via(this.untar()).$greater$greater$greater(this.extract(target));
    }

    public ZIO<Has<package.Blocking.Service>, Exception, BoxedUnit> extractTarGZ(Path in, Path target) {
        return AsynchronousFileChannel$.MODULE$.open(in, (Seq)Nil$.MODULE$).use((Function1 & Serializable)channel -> MODULE$.extractTarGZ((ZStream<Object, IOException, Object>)channel.stream(0L, channel.stream$default$2()), target));
    }

    private Function1<ZStream<Object, Exception, Object>, ZStream<Has<package.Blocking.Service>, Exception, CompressionUtils.ArchiveEvent>> untar() {
        return (Function1 & Serializable)in -> ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.unwrapManaged(in.toInputStream((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)is -> ZManaged$.MODULE$.makeEffect((Function0 & Serializable)() -> new TarArchiveInputStream(is), (Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)tarIn -> {
            ZIO readNextTarEntry = zio.blocking.package$.MODULE$.effectBlockingIO((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)((TarArchiveEntry)tarIn.getNextEntry()))).some((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return ZStream$.MODULE$.repeatEffectOption(readNextTarEntry).flatMap((Function1 & Serializable)x0$1 -> {
                TarArchiveEntry tarArchiveEntry = x0$1;
                ZStream zStream = tarArchiveEntry.isDirectory() ? ZStream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompressionUtils.ArchiveEvent.DirEntry[]{new CompressionUtils.ArchiveEvent.DirEntry(tarArchiveEntry.getName(), CompressionUtils$PosixPermissions$.MODULE$.octalModeToPermissions(tarArchiveEntry.getMode()), FileTime.from(tarArchiveEntry.getLastModifiedDate().toInstant()))})) : ZStream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompressionUtils.ArchiveEvent.FileEntry[]{new CompressionUtils.ArchiveEvent.FileEntry(tarArchiveEntry.getName(), CompressionUtils$PosixPermissions$.MODULE$.octalModeToPermissions(tarArchiveEntry.getMode()), FileTime.from(tarArchiveEntry.getLastModifiedDate().toInstant()))})).$plus$plus((Function0 & Serializable)() -> ZStream$.MODULE$.fromInputStream((Function0 & Serializable)() -> tarIn, ZStream$.MODULE$.fromInputStream$default$2()).mapChunks((Function1 & Serializable)bytes -> Chunk$.MODULE$.single((Object)new CompressionUtils.ArchiveEvent.DataEntry((Chunk<Object>)bytes)))).$plus$plus((Function0 & Serializable)() -> ZStream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompressionUtils.ArchiveEvent.FileEnd[]{new CompressionUtils.ArchiveEvent.FileEnd(tarArchiveEntry.getName(), CompressionUtils$PosixPermissions$.MODULE$.octalModeToPermissions(tarArchiveEntry.getMode()), FileTime.from(tarArchiveEntry.getLastModifiedDate().toInstant()))})));
                return zStream;
            });
        })))), ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail());
    }

    private ZSink<Has<package.Blocking.Service>, Exception, CompressionUtils.ArchiveEvent, CompressionUtils.ArchiveEvent, BoxedUnit> extract(Path target) {
        return ZSink$.MODULE$.managed(package$.MODULE$.Managed().switchable(), (Function1 & Serializable)switchFile -> zio.stream.package$.MODULE$.Sink().foldLeftM((Object)new Tuple2((Object)None$.MODULE$, (Object)ZIO$.MODULE$.unit()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                CompressionUtils.ArchiveEvent de = (CompressionUtils.ArchiveEvent)tuple2._2();
                if (tuple22 != null) {
                    Option currentFile = (Option)tuple22._1();
                    ZIO delayedOps = (ZIO)tuple22._2();
                    if (de instanceof CompressionUtils.ArchiveEvent.DirEntry) {
                        CompressionUtils.ArchiveEvent.DirEntry dirEntry = (CompressionUtils.ArchiveEvent.DirEntry)de;
                        return ZIO$.MODULE$.fail((Function0 & Serializable)() -> CompressionException$.MODULE$.apply("missing file end", CompressionException$.MODULE$.apply$default$2())).unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> currentFile.isEmpty()).flatMap((Function1 & Serializable)x$5 -> {
                            BoxedUnit boxedUnit = x$5;
                            ZIO zIO = Files$.MODULE$.createDirectories(target.$div(dirEntry.name()), (Seq)Nil$.MODULE$).map((Function1 & Serializable)x$3 -> {
                                ZIO newDelayedOps = MODULE$.setAttributes(target.$div(dirEntry.name()), dirEntry.posixPermissions(), dirEntry.lastModified()).$times$greater((Function0 & Serializable)() -> delayedOps);
                                return new Tuple2((Object)None$.MODULE$, (Object)newDelayedOps);
                            });
                            return zIO;
                        });
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple23 = (Tuple2)tuple2._1();
                CompressionUtils.ArchiveEvent fe = (CompressionUtils.ArchiveEvent)tuple2._2();
                if (tuple23 != null) {
                    Option currentFile = (Option)tuple23._1();
                    ZIO delayedOps = (ZIO)tuple23._2();
                    if (fe instanceof CompressionUtils.ArchiveEvent.FileEntry) {
                        CompressionUtils.ArchiveEvent.FileEntry fileEntry = (CompressionUtils.ArchiveEvent.FileEntry)fe;
                        return ZIO$.MODULE$.fail((Function0 & Serializable)() -> CompressionException$.MODULE$.apply("missing file end", CompressionException$.MODULE$.apply$default$2())).unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> currentFile.isEmpty()).flatMap((Function1 & Serializable)x$6 -> {
                            BoxedUnit boxedUnit = x$6;
                            ZIO zIO = ((ZIO)switchFile.apply((Object)AsynchronousFileChannel$.MODULE$.open(target.$div(fileEntry.name()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE})))).map((Function1 & Serializable)newFile -> new Tuple2((Object)new Some((Object)new Tuple2(newFile, (Object)BoxesRunTime.boxToLong((long)0L))), (Object)delayedOps));
                            return zIO;
                        });
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple24 = (Tuple2)tuple2._1();
                CompressionUtils.ArchiveEvent archiveEvent = (CompressionUtils.ArchiveEvent)tuple2._2();
                if (tuple24 != null) {
                    Option currentFile = (Option)tuple24._1();
                    ZIO delayedOps = (ZIO)tuple24._2();
                    if (archiveEvent instanceof CompressionUtils.ArchiveEvent.DataEntry) {
                        CompressionUtils.ArchiveEvent.DataEntry dataEntry = (CompressionUtils.ArchiveEvent.DataEntry)archiveEvent;
                        Chunk<Object> chunk = dataEntry.chunk();
                        return ZIO$.MODULE$.getOrFailWith((Function0 & Serializable)() -> CompressionException$.MODULE$.apply("missing file entry", CompressionException$.MODULE$.apply$default$2()), (Function0 & Serializable)() -> currentFile).flatMap((Function1 & Serializable)x$8 -> {
                            Tuple2 tuple2 = x$8;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            AsynchronousFileChannel channel = (AsynchronousFileChannel)tuple2._1();
                            long offset = tuple2._2$mcJ$sp();
                            ZIO zIO = channel.writeChunk(chunk, offset).map((Function1 & Serializable)x$7 -> {
                                BoxedUnit boxedUnit = x$7;
                                Tuple2 tuple2 = new Tuple2((Object)new Some((Object)new Tuple2((Object)channel, (Object)BoxesRunTime.boxToLong((long)(offset + (long)chunk.size())))), (Object)delayedOps);
                                return tuple2;
                            });
                            return zIO;
                        });
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple25 = (Tuple2)tuple2._1();
            CompressionUtils.ArchiveEvent fileEnd = (CompressionUtils.ArchiveEvent)tuple2._2();
            if (tuple25 == null) throw new MatchError((Object)tuple2);
            Option currentFile = (Option)tuple25._1();
            ZIO delayedOps = (ZIO)tuple25._2();
            if (!(fileEnd instanceof CompressionUtils.ArchiveEvent.FileEnd)) throw new MatchError((Object)tuple2);
            CompressionUtils.ArchiveEvent.FileEnd fileEnd2 = (CompressionUtils.ArchiveEvent.FileEnd)fileEnd;
            return ZIO$.MODULE$.getOrFailWith((Function0 & Serializable)() -> CompressionException$.MODULE$.apply("missing file entry", CompressionException$.MODULE$.apply$default$2()), (Function0 & Serializable)() -> currentFile).flatMap((Function1 & Serializable)x$11 -> {
                Tuple2 tuple2 = x$11;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AsynchronousFileChannel channel = (AsynchronousFileChannel)tuple2._1();
                ZIO zIO = channel.close().flatMap((Function1 & Serializable)x$10 -> {
                    BoxedUnit boxedUnit = x$10;
                    ZIO zIO = MODULE$.setAttributes(target.$div(fileEnd2.name()), fileEnd2.posixPermissions(), fileEnd2.lastModified()).map((Function1 & Serializable)x$9 -> {
                        BoxedUnit boxedUnit = x$9;
                        Tuple2 tuple2 = new Tuple2((Object)None$.MODULE$, (Object)delayedOps);
                        return tuple2;
                    });
                    return zIO;
                });
                return zIO;
            });
        })).mapM((Function1 & Serializable)x0$2 -> {
            ZIO delayedOps;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ZIO zIO = delayedOps = (ZIO)tuple2._2();
            return zIO;
        });
    }

    private ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setAttributes(Path path, Set<PosixFilePermission> permissions, FileTime lastModified) {
        return Files$.MODULE$.setLastModifiedTime(path, lastModified).$times$greater((Function0 & Serializable)() -> path.filesystem().supportedFileAttributeViews().contains((Object)"posix") ? Files$.MODULE$.setPosixFilePermissions(path, permissions) : zio.blocking.package$.MODULE$.effectBlockingIO((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            File file = path.toFile();
            file.setReadable(permissions.contains((Object)PosixFilePermission.OWNER_READ));
            file.setWritable(permissions.contains((Object)PosixFilePermission.OWNER_WRITE));
            return file.setExecutable(permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        }).unit());
    }

    private CompressionUtils$() {
    }
}

