/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart;

import io.conduktor.jumpstart.ArchiveRepository;
import io.conduktor.jumpstart.JumpStartService;
import io.conduktor.jumpstart.JumpStartService$ConfluentPlatformConfig$;
import io.conduktor.jumpstart.JumpStartServiceLive$;
import io.conduktor.jumpstart.Jumpstart$;
import io.conduktor.jumpstart.KafkaProcess;
import io.conduktor.jumpstart.KafkaProcess$;
import io.conduktor.jumpstart.SchemaRegistryProcess;
import io.conduktor.jumpstart.SchemaRegistryProcess$;
import io.conduktor.jumpstart.WorkingDirectory;
import io.conduktor.jumpstart.ZookeeperProcess;
import io.conduktor.jumpstart.ZookeeperProcess$;
import io.conduktor.jumpstart.domain.BinDir;
import io.conduktor.jumpstart.domain.ConfluentPlatformVersion;
import io.conduktor.jumpstart.domain.DownloadError;
import io.conduktor.jumpstart.domain.DownloadEvent;
import io.conduktor.jumpstart.domain.JumpStartError;
import io.conduktor.jumpstart.domain.JumpStartError$ConfluentBinDirNotConfigured$;
import io.conduktor.jumpstart.domain.JumpStartError$InstallError$;
import io.conduktor.jumpstart.domain.KafkaVersion;
import io.conduktor.jumpstart.domain.OS;
import io.conduktor.jumpstart.domain.OS$;
import io.conduktor.jumpstart.domain.ProcessEvent;
import io.conduktor.jumpstart.domain.RegistryBinDir;
import io.conduktor.jumpstart.domain.RegistryBinDir$;
import io.conduktor.jumpstart.domain.ScriptConfig;
import io.conduktor.jumpstart.domain.ShutdownSignal;
import io.conduktor.jumpstart.helper.CompressionUtils$;
import io.conduktor.jumpstart.helper.SafeFileOps$;
import io.conduktor.jumpstart.helper.SupervisedProcess;
import io.conduktor.jumpstart.helper.SupervisedProcess$SupervisorConfig$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.CanFail$;
import zio.Has;
import zio.Has$;
import zio.NeedsEnv$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.ZLayer$;
import zio.blocking.package;
import zio.clock.package;
import zio.logging.Logger;
import zio.nio.file.Files$;
import zio.nio.file.Path;
import zio.random.package;
import zio.stream.ZStream;
import zio.system.package;

@ScalaSignature(bytes="\u0006\u0005\t=d\u0001\u0002\r\u001a\u0001\u0001B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0005\f\u0005\to\u0001\u0011\t\u0011)A\u0005[!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011)\u0004!\u0011!Q\u0001\n-D\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!!\u0016\u0001\t\u0003\n9\u0006C\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0001\u0005B\u00055\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\n\u0003o\u0004\u0011\u0013!C\u0001\u0003sD\u0011Ba\u0004\u0001#\u0003%\tA!\u0005\t\u0013\tU\u0001!%A\u0005\u0002\t]qa\u0002B\u000e3!\u0005!Q\u0004\u0004\u00071eA\tAa\b\t\u000f\u00055A\u0003\"\u0001\u0003\"\u00151!1\u0005\u000b\u0001\u0005KAqAa\u0017\u0015\t\u0003\u0011iF\u0001\u000bKk6\u00048\u000b^1siN+'O^5dK2Kg/\u001a\u0006\u00035m\t\u0011B[;naN$\u0018M\u001d;\u000b\u0005qi\u0012!C2p]\u0012,8\u000e^8s\u0015\u0005q\u0012AA5p\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&K\u0007\u00023%\u0011!&\u0007\u0002\u0011\u0015Vl\u0007o\u0015;beR\u001cVM\u001d<jG\u0016\fQBY1tK\u0012K'/Z2u_JLX#A\u0017\u0011\u00059*T\"A\u0018\u000b\u0005A\n\u0014\u0001\u00024jY\u0016T!AM\u001a\u0002\u00079LwNC\u00015\u0003\rQ\u0018n\\\u0005\u0003m=\u0012A\u0001U1uQ\u0006q!-Y:f\t&\u0014Xm\u0019;pef\u0004\u0013A\u0003:fa>\u001c\u0018\u000e^8ssB\u0011\u0001FO\u0005\u0003we\u0011\u0011#\u0011:dQ&4XMU3q_NLGo\u001c:z\u0003!\u0011Gn\\2lS:<\u0007C\u0001 N\u001d\ty$J\u0004\u0002A\u000f:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t~\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005q\u001a\u0014B\u0001%J\u0003\u001d\u0001\u0018mY6bO\u0016T!\u0001P\u001a\n\u0005-c\u0015\u0001\u0003\"m_\u000e\\\u0017N\\4\u000b\u0005!K\u0015B\u0001(P\u0005\u001d\u0019VM\u001d<jG\u0016T!a\u0013'\u0002\u000b\rdwnY6\u0011\u0005I[fBA*Y\u001d\t!fK\u0004\u0002B+&\u0011\u0001kM\u0005\u0003\u0011^S!\u0001U\u001a\n\u0005eS\u0016!B\"m_\u000e\\'B\u0001%X\u0013\tqEL\u0003\u0002Z5\u00061!/\u00198e_6\u0004\"a\u00185\u000f\u0005\u0001,gBA1d\u001d\t\t%-\u0003\u0002^g%\u0011\u0001\n\u001a\u0006\u0003;NJ!AZ4\u0002\rI\u000bg\u000eZ8n\u0015\tAE-\u0003\u0002OS*\u0011amZ\u0001\u0007gf\u001cH/Z7\u0011\u00051,hBA7s\u001d\tq\u0007O\u0004\u0002B_&\u0011!nM\u0005\u0003\u0011FT!A[\u001a\n\u0005M$\u0018AB*zgR,WN\u0003\u0002Ic&\u0011aJ\u001e\u0006\u0003gR\fa\u0001\\8hO\u0016\u0014\bcA=}}6\t!P\u0003\u0002|g\u00059An\\4hS:<\u0017BA?{\u0005\u0019aunZ4feB\u0019q0a\u0002\u000f\t\u0005\u0005\u00111\u0001\t\u0003\u0005\u000eJ1!!\u0002$\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011QA\u0012\u0002\rqJg.\u001b;?)A\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\u0002\u0005\u0002)\u0001!)1&\u0003a\u0001[!)\u0001(\u0003a\u0001s!)A(\u0003a\u0001{!)\u0001+\u0003a\u0001#\")Q,\u0003a\u0001=\")!.\u0003a\u0001W\")q/\u0003a\u0001q\u0006aAm\\<oY>\fG\rU1uQR!\u0011QEA\u001c!\u0019\t9#a\u000b\u000229\u0019\u0011)!\u000b\n\u0005!\u001b\u0014\u0002BA\u0017\u0003_\u00111!V%P\u0015\tA5\u0007\u0005\u0003#\u0003gi\u0013bAA\u001bG\t1q\n\u001d;j_:Dq!!\u000f\u000b\u0001\u0004\tY$A\u0006d_6\u0004xN\\3oi&#\u0007\u0003BA\u001f\u0003\u001frA!a\u0010\u0002L9!\u0011\u0011IA%\u001d\u0011\t\u0019%a\u0012\u000f\u0007\t\u000b)%C\u0001\u001f\u0013\taR$\u0003\u0002\u001b7%\u0019\u0011QJ\r\u0002#\u0005\u00138\r[5wKJ+\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0002R\u0005M#aC\"p[B|g.\u001a8u\u0013\u0012T1!!\u0014\u001a\u0003!!wn\u001e8m_\u0006$G\u0003BA-\u0003{\u0002\"\"a\u0017\u0002b\u0005\u0015\u00141NA<\u001b\t\tiFC\u0002\u0002`M\naa\u001d;sK\u0006l\u0017\u0002BA2\u0003;\u0012qAW*ue\u0016\fW\u000eE\u0002#\u0003OJ1!!\u001b$\u0005\r\te.\u001f\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O\r\u0002\r\u0011|W.Y5o\u0013\u0011\t)(a\u001c\u0003\u001b\u0011{wO\u001c7pC\u0012,%O]8s!\u0011\ti'!\u001f\n\t\u0005m\u0014q\u000e\u0002\u000e\t><h\u000e\\8bI\u00163XM\u001c;\t\u000f\u0005e2\u00021\u0001\u0002<\u0005Y\u0011N\\:uC2d\u0007+\u0019;i)\u0011\t)#a!\t\u000f\u0005eB\u00021\u0001\u0002<\u0005!b/\u001a:tS>tGk\\%ogR\fG\u000e\u001c)bi\"$2!LAE\u0011\u001d\tI$\u0004a\u0001\u0003w\tq!\u001b8ti\u0006dG\u000e\u0006\u0003\u0002\u0010\u0006m\u0005cBA\u0014\u0003#\u000b)*L\u0005\u0005\u0003'\u000byC\u0001\u0002J\u001fB!\u0011QNAL\u0013\u0011\tI*a\u001c\u0003\u001d)+X\u000e]*uCJ$XI\u001d:pe\"9\u0011\u0011\b\bA\u0002\u0005m\u0012A\u00027bk:\u001c\u0007\u000e\u0006\b\u0002\"\u0006%\u00161WA_\u0003\u000f\fY-!:\u0011\u0015\u0005m\u0013\u0011MA3\u0003+\u000b\u0019\u000b\u0005\u0003\u0002n\u0005\u0015\u0016\u0002BAT\u0003_\u0012A\u0002\u0015:pG\u0016\u001c8/\u0012<f]RDq!a+\u0010\u0001\u0004\ti+\u0001\u0007lC\u001a\\\u0017MV3sg&|g\u000e\u0005\u0003\u0002n\u0005=\u0016\u0002BAY\u0003_\u0012AbS1gW\u00064VM]:j_:Dq!!.\u0010\u0001\u0004\t9,\u0001\tx_J\\\u0017N\\4ESJ,7\r^8ssB\u0019\u0001&!/\n\u0007\u0005m\u0016D\u0001\tX_J\\\u0017N\\4ESJ,7\r^8ss\"9\u0011qX\bA\u0002\u0005\u0005\u0017AD:ikR$wn\u001e8TS\u001et\u0017\r\u001c\t\u0005\u0003[\n\u0019-\u0003\u0003\u0002F\u0006=$AD*ikR$wn\u001e8TS\u001et\u0017\r\u001c\u0005\n\u0003\u0013|\u0001\u0013!a\u0001\u0003c\t\u0001B[1wC\"{W.\u001a\u0005\n\u0003\u001b|\u0001\u0013!a\u0001\u0003\u001f\f\u0001c];qKJ4\u0018n]8s\u0007>tg-[4\u0011\t\u0005E\u0017q\u001c\b\u0005\u0003'\fIN\u0004\u0003\u0002@\u0005U\u0017bAAl3\u00051\u0001.\u001a7qKJLA!a7\u0002^\u0006\t2+\u001e9feZL7/\u001a3Qe>\u001cWm]:\u000b\u0007\u0005]\u0017$\u0003\u0003\u0002b\u0006\r(\u0001E*va\u0016\u0014h/[:pe\u000e{gNZ5h\u0015\u0011\tY.!8\t\u0013\u0005\u001dx\u0002%AA\u0002\u0005%\u0018A\u00049mCR4wN]7D_:4\u0017n\u001a\t\u0005\u0003W\f\tP\u0004\u0003\u0002@\u00055\u0018bAAx3\u0005\u0001\"*^7q'R\f'\u000f^*feZL7-Z\u0005\u0005\u0003g\f)PA\fD_:4G.^3oiBc\u0017\r\u001e4pe6\u001cuN\u001c4jO*\u0019\u0011q^\r\u0002!1\fWO\\2iI\u0011,g-Y;mi\u0012\"TCAA~U\u0011\t\t$!@,\u0005\u0005}\b\u0003\u0002B\u0001\u0005\u0017i!Aa\u0001\u000b\t\t\u0015!qA\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0003$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001b\u0011\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0003\\1v]\u000eDG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tM!\u0006BAh\u0003{\f\u0001\u0003\\1v]\u000eDG\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\te!\u0006BAu\u0003{\fACS;naN#\u0018M\u001d;TKJ4\u0018nY3MSZ,\u0007C\u0001\u0015\u0015'\t!\u0012\u0005\u0006\u0002\u0003\u001e\t\u0019QI\u001c<\u0013\u001d\t\u001d\"1\u0006B\u001e\u0005\u0007\u0012IEa\u0014\u0003V\u00191!\u0011\u0006\u000b\u0001\u0005K\u0011A\u0002\u0010:fM&tW-\\3oiz\u0002BA!\f\u000369!!q\u0006B\u001a\u001d\r\t%\u0011G\u0005\u0003wNJ!\u0001\u0013>\n\t\t]\"\u0011\b\u0002\b\u0019><w-\u001b8h\u0015\tA%\u0010E\u0003\u0003>\t}\u0012(D\u00014\u0013\r\u0011\te\r\u0002\u0004\u0011\u0006\u001c\bcA \u0003F%\u0019!q\t'\u0003\u0011\tcwnY6j]\u001e\u00042a\u0015B&\u0013\r\u0011iE\u0017\u0002\u0006\u00072|7m\u001b\t\u0004A\nE\u0013b\u0001B*O\n1!+\u00198e_6\u00042!\u001cB,\u0013\r\u0011I\u0006\u001e\u0002\u0007'f\u001cH/Z7\u0002\u000b1\f\u00170\u001a:\u0015\t\t}#1\u000e\t\t\u0003O\u0011\tG!\u001a\u0003j%!!1MA\u0018\u0005\u001d)&\u000bT1zKJ\u00042Aa\u001a\u0017\u001b\u0005!\u0002#\u0002B\u001f\u0005\u007f9\u0003B\u0002B7/\u0001\u0007Q&\u0001\u0003qCRD\u0007")
public class JumpStartServiceLive
implements JumpStartService {
    private final Path baseDirectory;
    private final ArchiveRepository repository;
    private final package.Blocking.Service blocking;
    private final package.Clock.Service clock;
    private final package.Random.Service random;
    private final package.System.Service system;
    private final Logger<String> logger;

    public static ZLayer<Has<Logger<String>>, Nothing$, Has<JumpStartService>> layer(Path path) {
        return JumpStartServiceLive$.MODULE$.layer(path);
    }

    @Override
    public Path baseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public ZIO<Object, Nothing$, Option<Path>> downloadPath(ArchiveRepository.ComponentId componentId) {
        return this.repository.locate(componentId);
    }

    @Override
    public ZStream<Object, DownloadError, DownloadEvent> download(ArchiveRepository.ComponentId componentId) {
        return this.repository.download(componentId);
    }

    @Override
    public ZIO<Object, Nothing$, Option<Path>> installPath(ArchiveRepository.ComponentId componentId) {
        Path path = this.versionToInstallPath(componentId);
        return ZIO.IfM$.MODULE$.apply$extension(ZIO$.MODULE$.ifM(Files$.MODULE$.exists(path, (Seq)Nil$.MODULE$)), (Function0 & Serializable)() -> ZIO$.MODULE$.some((Function0 & Serializable)() -> path), (Function0 & Serializable)() -> ZIO$.MODULE$.none()).provide((Object)Has$.MODULE$.apply((Object)this.blocking, Tag$.MODULE$.apply(package.Blocking.Service.class, LightTypeTag$.MODULE$.parse(-582195017, "\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21))), NeedsEnv$.MODULE$.needsEnv());
    }

    private Path versionToInstallPath(ArchiveRepository.ComponentId componentId) {
        Path path;
        ArchiveRepository.ComponentId componentId2 = componentId;
        if (componentId2 instanceof ArchiveRepository.Kafka) {
            ArchiveRepository.Kafka kafka = (ArchiveRepository.Kafka)componentId2;
            KafkaVersion version = kafka.version();
            path = this.baseDirectory().$div(new StringBuilder(11).append("kafka_2.13-").append(version.entryName()).toString());
        } else if (componentId2 instanceof ArchiveRepository.ConfluentPlatform) {
            ArchiveRepository.ConfluentPlatform confluentPlatform = (ArchiveRepository.ConfluentPlatform)componentId2;
            ConfluentPlatformVersion version = confluentPlatform.version();
            path = this.baseDirectory().$div(new StringBuilder(10).append("confluent-").append(version.entryName()).toString());
        } else {
            throw new MatchError((Object)componentId2);
        }
        return path;
    }

    @Override
    public ZIO<Object, JumpStartError, Path> install(ArchiveRepository.ComponentId componentId) {
        return this.downloadPath(componentId).someOrFail((Function0 & Serializable)() -> new JumpStartError.MustDownload(componentId), (.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)archivePath -> {
            Path targetDir = this.versionToInstallPath(componentId);
            return SafeFileOps$.MODULE$.deleteRecursively(targetDir).whenM(Files$.MODULE$.exists(targetDir, (Seq)Nil$.MODULE$)).mapError((Function1)JumpStartError$InstallError$.MODULE$, CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit = x$3;
                ZIO zIO = SafeFileOps$.MODULE$.createDirectories(this.baseDirectory()).mapError((Function1)JumpStartError$InstallError$.MODULE$, CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)x$2 -> {
                    BoxedUnit boxedUnit = x$2;
                    ZIO zIO = CompressionUtils$.MODULE$.extractTarGZ((Path)archivePath, this.baseDirectory()).mapError((Function1)JumpStartError$InstallError$.MODULE$, CanFail$.MODULE$.canFail()).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        Path path = targetDir;
                        return path;
                    });
                    return zIO;
                });
                return zIO;
            });
        }).provide((Object)Has$.MODULE$.apply((Object)this.blocking, Tag$.MODULE$.apply(package.Blocking.Service.class, LightTypeTag$.MODULE$.parse(-582195017, "\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21))), NeedsEnv$.MODULE$.needsEnv());
    }

    @Override
    public ZStream<Object, JumpStartError, ProcessEvent> launch(KafkaVersion kafkaVersion, WorkingDirectory workingDirectory, ShutdownSignal shutdownSignal, Option<Path> javaHome, SupervisedProcess.SupervisorConfig supervisorConfig, JumpStartService.ConfluentPlatformConfig platformConfig) {
        ZIO scriptConfig = OS$.MODULE$.resolve().flatMap((Function1 & Serializable)os -> this.installPath(new ArchiveRepository.Kafka(kafkaVersion)).someOrFail((Function0 & Serializable)() -> new JumpStartError.MustInstall(new ArchiveRepository.Kafka(kafkaVersion)), (.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)binPath -> (platformConfig.atLeastOneComponentSelected() ? this.installPath(new ArchiveRepository.ConfluentPlatform(platformConfig.platformVersion())).someOrFail((Function0 & Serializable)() -> new JumpStartError.MustInstall(new ArchiveRepository.ConfluentPlatform(platformConfig.platformVersion())), (.less.colon.less)$less$colon$less$.MODULE$.refl()).asSome() : ZIO$.MODULE$.none()).map((Function1 & Serializable)confluentBinPath -> {
            OS x$1 = os;
            WorkingDirectory x$2 = workingDirectory;
            BinDir x$3 = new BinDir((Path)binPath);
            Option x$4 = javaHome;
            Option x$52 = confluentBinPath.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)platformConfig.registryEnabled())).map((Function1)RegistryBinDir$.MODULE$);
            return new ScriptConfig(x$1, x$2, x$3, (Option<RegistryBinDir>)x$52, (Option<Path>)x$4);
        })));
        ZLayer layer$macro$1 = ZLayer$.MODULE$.succeed((Object)supervisorConfig, Tag$.MODULE$.apply(SupervisedProcess.SupervisorConfig.class, LightTypeTag$.MODULE$.parse(1682539433, "\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21)));
        ZLayer layer$macro$2 = ZLayer$.MODULE$.succeed(this.logger, Tag$.MODULE$.apply(Logger.class, LightTypeTag$.MODULE$.parse(723429507, "\u0001\u0000\u0012zio.logging.Logger\u0001\u0000\u0004\u0000\u0001\u0010java.lang.String\u0001\u0001\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u0010java.lang.String\u0001\u0001\u0005\u0001\u0000\u0014java.lang.Comparable\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0004\u0000\u0001\u0016java.lang.CharSequence\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjava.lang.constant.Constable\u0001\u0001\u0004\u0000\u0001\u001fjava.lang.constant.ConstantDesc\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0005\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21)));
        ZLayer layer$macro$3 = ZLayer$.MODULE$.succeed((Object)this.blocking, Tag$.MODULE$.apply(package.Blocking.Service.class, LightTypeTag$.MODULE$.parse(-582195017, "\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21)));
        ZLayer layer$macro$4 = ZLayer$.MODULE$.succeed((Object)this.clock, Tag$.MODULE$.apply(package.Clock.Service.class, LightTypeTag$.MODULE$.parse(-1230456148, "\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21)));
        ZLayer layer$macro$5 = ZLayer$.MODULE$.succeed((Object)this.random, Tag$.MODULE$.apply(package.Random.Service.class, LightTypeTag$.MODULE$.parse(1036505201, "\u0004\u0000\u0001\u0019zio.random.Random.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.random.Random\u0001\u0002\u0003\u0000\u0000\u0012zio.random.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u0019zio.random.Random.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.random.Random\u0001\u0002\u0003\u0000\u0000\u0012zio.random.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21)));
        ZLayer layer$macro$6 = ZLayer$.MODULE$.succeed((Object)this.system, Tag$.MODULE$.apply(package.System.Service.class, LightTypeTag$.MODULE$.parse(-1959302361, "\u0004\u0000\u0001\u0019zio.system.System.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.system.System\u0001\u0002\u0003\u0000\u0000\u0012zio.system.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u0019zio.system.System.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.system.System\u0001\u0002\u0003\u0000\u0000\u0012zio.system.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21)));
        ZLayer layer$macro$7 = scriptConfig.toLayer(Tag$.MODULE$.apply(ScriptConfig.class, LightTypeTag$.MODULE$.parse(-1595098146, "\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21)));
        ZLayer<Has<Logger<String>>, Nothing$, Has<KafkaProcess>> layer$macro$8 = KafkaProcess$.MODULE$.live();
        ZLayer<Has<Logger<String>>, Nothing$, Has<ZookeeperProcess>> layer$macro$9 = ZookeeperProcess$.MODULE$.live();
        ZLayer<Has<Logger<String>>, JumpStartError$ConfluentBinDirNotConfigured$, Has<SchemaRegistryProcess>> layer$macro$10 = SchemaRegistryProcess$.MODULE$.live();
        ZLayer jumpstartLayer = layer$macro$2.$plus$plus(layer$macro$3, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))).$plus$plus(layer$macro$4, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$5, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(422951646, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0019zio.random.Random.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.random.Random\u0001\u0002\u0003\u0000\u0000\u0012zio.random.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0019zio.random.Random.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.random.Random\u0001\u0002\u0003\u0000\u0000\u0012zio.random.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(422951646, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0019zio.random.Random.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.random.Random\u0001\u0002\u0003\u0000\u0000\u0012zio.random.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0019zio.random.Random.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.random.Random\u0001\u0002\u0003\u0000\u0000\u0012zio.random.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$2.$plus$plus(layer$macro$3, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))).$plus$plus(layer$macro$4, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$6.$greater$greater$greater(layer$macro$7), Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21))).$plus$plus(layer$macro$1, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$greater$greater$greater(layer$macro$9), Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(153487640, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001'io.conduktor.jumpstart.ZookeeperProcess\u0001\u0001\u0000\u0001", "\u0000\u0002\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001'io.conduktor.jumpstart.ZookeeperProcess\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(153487640, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001'io.conduktor.jumpstart.ZookeeperProcess\u0001\u0001\u0000\u0001", "\u0000\u0002\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001'io.conduktor.jumpstart.ZookeeperProcess\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$2.$plus$plus(layer$macro$3, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))).$plus$plus(layer$macro$4, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$6, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(556533625, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0019zio.system.System.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.system.System\u0001\u0002\u0003\u0000\u0000\u0012zio.system.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001\u0019zio.system.System.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.system.System\u0001\u0002\u0003\u0000\u0000\u0012zio.system.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(556533625, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0019zio.system.System.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.system.System\u0001\u0002\u0003\u0000\u0000\u0012zio.system.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001\u0019zio.system.System.Service\u0001\u0002\u0003\u0000\u0000\u0011zio.system.System\u0001\u0002\u0003\u0000\u0000\u0012zio.system.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21))).$plus$plus(layer$macro$6.$greater$greater$greater(layer$macro$7), Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21))).$plus$plus(layer$macro$1, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$greater$greater$greater(layer$macro$8), Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1547956070, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001#io.conduktor.jumpstart.KafkaProcess\u0001\u0001\u0000\u0001", "\u0000\u0002\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001#io.conduktor.jumpstart.KafkaProcess\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1547956070, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001#io.conduktor.jumpstart.KafkaProcess\u0001\u0001\u0000\u0001", "\u0000\u0002\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001#io.conduktor.jumpstart.KafkaProcess\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$2.$plus$plus(layer$macro$3, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))).$plus$plus(layer$macro$4, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(2018716709, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$6.$greater$greater$greater(layer$macro$7), Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21))).$plus$plus(layer$macro$1, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$greater$greater$greater(layer$macro$10), Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-486423718, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001,io.conduktor.jumpstart.SchemaRegistryProcess\u0001\u0001\u0000\u0001", "\u0000\u0002\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001,io.conduktor.jumpstart.SchemaRegistryProcess\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-486423718, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001,io.conduktor.jumpstart.SchemaRegistryProcess\u0001\u0001\u0000\u0001", "\u0000\u0002\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001,io.conduktor.jumpstart.SchemaRegistryProcess\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$1, Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1544061720, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0000\u0001", "\u0000\u0003\u0004\u0000\u0001@io.conduktor.jumpstart.helper.SupervisedProcess.SupervisorConfig\u0001\u0002\u0003\u0000\u0000/io.conduktor.jumpstart.helper.SupervisedProcess\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0007\u0001\u0000\u0004\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21))).$plus$plus(layer$macro$6.$greater$greater$greater(layer$macro$7), Has.Union$.MODULE$.HasHasUnion(Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21))), Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(1152448654, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 21)));
        return Jumpstart$.MODULE$.launch(shutdownSignal).provideLayer(jumpstartLayer, (.less.colon.less)$less$colon$less$.MODULE$.refl(), NeedsEnv$.MODULE$.needsEnv());
    }

    @Override
    public Option<Path> launch$default$4() {
        return None$.MODULE$;
    }

    @Override
    public SupervisedProcess.SupervisorConfig launch$default$5() {
        return SupervisedProcess$SupervisorConfig$.MODULE$.default();
    }

    @Override
    public JumpStartService.ConfluentPlatformConfig launch$default$6() {
        return JumpStartService$ConfluentPlatformConfig$.MODULE$.noComponent();
    }

    public JumpStartServiceLive(Path baseDirectory, ArchiveRepository repository, package.Blocking.Service blocking, package.Clock.Service clock, package.Random.Service random, package.System.Service system, Logger<String> logger) {
        this.baseDirectory = baseDirectory;
        this.repository = repository;
        this.blocking = blocking;
        this.clock = clock;
        this.random = random;
        this.system = system;
        this.logger = logger;
    }
}

