/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart;

import io.conduktor.jumpstart.ArchiveRepository;
import io.conduktor.jumpstart.ArchiveRepository$Offset$;
import io.conduktor.jumpstart.ArchiveRepositoryLive$;
import io.conduktor.jumpstart.Catalog;
import io.conduktor.jumpstart.Downloader;
import io.conduktor.jumpstart.domain.ConfluentPlatformVersion;
import io.conduktor.jumpstart.domain.DownloadError;
import io.conduktor.jumpstart.domain.DownloadEvent;
import io.conduktor.jumpstart.domain.JumpStartError;
import io.conduktor.jumpstart.domain.JumpStartError$IOError$;
import io.conduktor.jumpstart.domain.KafkaVersion;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Has;
import zio.Has$;
import zio.IO$;
import zio.NeedsEnv$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.ZManaged;
import zio.ZManaged$;
import zio.blocking.package;
import zio.clock.package;
import zio.nio.channels.AsynchronousFileChannel;
import zio.nio.channels.AsynchronousFileChannel$;
import zio.nio.file.Files$;
import zio.nio.file.Path;
import zio.prelude.package$;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u000b\u0016\u0001qA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!Y\u0005A!A!\u0002\u0013a\u0005\"\u0002+\u0001\t\u0003)\u0006\"\u0002/\u0001\t\u0013i\u0006bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"9\u0011Q\u0019\u0001\u0005B\u0005\u001dwaBAe+!\u0005\u00111\u001a\u0004\u0007)UA\t!!4\t\rQ\u0003B\u0011AAh\u0011\u001d\t\t\u000e\u0005C\u0001\u0003'Dq!!;\u0011\t\u0003\tYOA\u000bBe\u000eD\u0017N^3SKB|7/\u001b;pefd\u0015N^3\u000b\u0005Y9\u0012!\u00036v[B\u001cH/\u0019:u\u0015\tA\u0012$A\u0005d_:$Wo\u001b;pe*\t!$\u0001\u0002j_\u000e\u00011c\u0001\u0001\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0013\u000e\u0003UI!AJ\u000b\u0003#\u0005\u00138\r[5wKJ+\u0007o\\:ji>\u0014\u00180A\u0003dY>\u001c7\u000e\u0005\u0002*m9\u0011!f\r\b\u0003WEr!\u0001L\u0018\u000e\u00035R!AL\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014a\u0001>j_&\u0011qE\r\u0006\u0002a%\u0011A'N\u0001\ba\u0006\u001c7.Y4f\u0015\t9#'\u0003\u00028q\t)1\t\\8dW*\u0011A'N\u0001\tE2|7m[5oOB\u00111\b\u0011\b\u0003yyr!aK\u001f\n\u0005e\u0012\u0014B\u0001\u001b@\u0015\tI$'\u0003\u0002B\u0005\nA!\t\\8dW&twM\u0003\u00025\u007f\u0005QAm\\<oY>\fG-\u001a:\u0011\u0005\u0011*\u0015B\u0001$\u0016\u0005)!un\u001e8m_\u0006$WM]\u0001\bG\u0006$\u0018\r\\8h!\t!\u0013*\u0003\u0002K+\t91)\u0019;bY><\u0017!\u00033je\u0016\u001cGo\u001c:z!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003gS2,'BA)3\u0003\rq\u0017n\\\u0005\u0003':\u0013A\u0001U1uQ\u00061A(\u001b8jiz\"bAV,Y3j[\u0006C\u0001\u0013\u0001\u0011\u00159c\u00011\u0001)\u0011\u0015Id\u00011\u0001;\u0011\u0015\u0019e\u00011\u0001E\u0011\u00159e\u00011\u0001I\u0011\u0015Ye\u00011\u0001M\u0003-9(/\u001b;f)>4\u0015\u000e\\3\u0015\u0005ys\b\u0003\u0002\u0010`CNL!\u0001Y\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#\u00022fO*\u0004X\"A2\u000b\u0005\u0011\u0014\u0014AB:ue\u0016\fW.\u0003\u0002gG\n9!l\u0015;sK\u0006l\u0007C\u0001\u0010i\u0013\tIwDA\u0002B]f\u0004\"a\u001b8\u000e\u00031T!!\\\u000b\u0002\r\u0011|W.Y5o\u0013\tyGNA\u0007E_^tGn\\1e\u000bJ\u0014xN\u001d\t\u0003=EL!A]\u0010\u0003\t\tKH/\u001a\t\u0006E\u0016D#\u000e\u001e\t\u0005=U<80\u0003\u0002w?\t1A+\u001e9mKJ\u00022\u0001_=q\u001b\u0005\u0011\u0014B\u0001>3\u0005\u0015\u0019\u0005.\u001e8l!\tYG0\u0003\u0002~Y\niAi\\<oY>\fG-\u0012<f]RDQaT\u0004A\u0002}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0001\u0016\u0001C2iC:tW\r\\:\n\t\u0005%\u00111\u0001\u0002\u0018\u0003NLhn\u00195s_:|Wo\u001d$jY\u0016\u001c\u0005.\u00198oK2\fa\u0001Z5hKN$X\u0003BA\b\u00033!B!!\u0005\u0002&A1adXA\n\u0003'\u0001bAY3\u0002\u0016)$\b\u0003BA\f\u00033a\u0001\u0001B\u0004\u0002\u001c!\u0011\r!!\b\u0003\u0003I\u000b2!a\bh!\rq\u0012\u0011E\u0005\u0004\u0003Gy\"a\u0002(pi\"Lgn\u001a\u0005\b\u0003OA\u0001\u0019AA\u0015\u00039)\u0007\u0010]3di\u0016$G)[4fgR\u0004B!a\u000b\u0002>9!\u0011QFA\u001d\u001d\u0011\ty#a\u000e\u000f\t\u0005E\u0012Q\u0007\b\u0004Y\u0005M\u0012\"\u0001\u000e\n\u0005aI\u0012B\u0001\f\u0018\u0013\r\tY$F\u0001\u0012\u0003J\u001c\u0007.\u001b<f%\u0016\u0004xn]5u_JL\u0018\u0002BA \u0003\u0003\u0012aa\u0015%BkE\u0012$bAA\u001e+\u00051An\\2bi\u0016$B!a\u0012\u0002ZA1\u0011\u0011JA'\u0003'r1aKA&\u0013\t!$'\u0003\u0003\u0002P\u0005E#aA+J\u001f*\u0011AG\r\t\u0005=\u0005UC*C\u0002\u0002X}\u0011aa\u00149uS>t\u0007bBA.\u0013\u0001\u0007\u0011QL\u0001\fG>l\u0007o\u001c8f]RLE\r\u0005\u0003\u0002,\u0005}\u0013\u0002BA1\u0003\u0003\u00121bQ8na>tWM\u001c;JI\u0006!b/\u001a:tS>tGk\\!sG\"Lg/\u001a)bi\"$2\u0001TA4\u0011\u001d\tYF\u0003a\u0001\u0003;\n\u0001\u0002Z8x]2|\u0017\r\u001a\u000b\u0005\u0003[\ny\u0007E\u0003cK\u001eT7\u0010C\u0004\u0002\\-\u0001\r!!\u0018\u00023\u0015t7/\u001e:f)\u0006\u0014x-\u001a;GS2,wK]5uK\u0006\u0014G.\u001a\u000b\u0005\u0003k\n9\u000bE\u0005y\u0003o\nY(a$\u0002\"&\u0019\u0011\u0011\u0010\u001a\u0003\u0011ik\u0015M\\1hK\u0012\u0004R\u0001_A?\u0003\u0003K1!a 3\u0005\rA\u0015m\u001d\t\u0005\u0003\u0007\u000bIID\u0002<\u0003\u000bK1!a\"C\u0003!\u0011En\\2lS:<\u0017\u0002BAF\u0003\u001b\u0013qaU3sm&\u001cWMC\u0002\u0002\b\n\u0003B!!%\u0002\u001c:!\u00111SAL\u001d\u0011\ti#!&\n\u00055,\u0012bAAMY\u0006q!*^7q'R\f'\u000f^#se>\u0014\u0018\u0002BAO\u0003?\u0013q!S(FeJ|'OC\u0002\u0002\u001a2\u00042AHAR\u0013\r\t)k\b\u0002\u0005+:LG\u000f\u0003\u0004\u0002*2\u0001\r\u0001T\u0001\u0007i\u0006\u0014x-\u001a;\u0002)5|g/\u001a+na\u001aKG.\u001a+p\u0003J\u001c\u0007.\u001b<f)\u0019\ty+a0\u0002BB9!-\u001a\u001e\u0002\u0010\u0006E\u0006\u0003BAZ\u0003ss1a[A[\u0013\r\t9\f\\\u0001\u000e\t><h\u000e\\8bI\u00163XM\u001c;\n\t\u0005m\u0016Q\u0018\u0002\t\r&t\u0017n\u001d5fI*\u0019\u0011q\u00177\t\r\u0005%V\u00021\u0001M\u0011\u0019\t\u0019-\u0004a\u0001\u0019\u00069\u0011M]2iSZ,\u0017!\u00042bg\u0016$\u0015N]3di>\u0014\u00180F\u0001M\u0003U\t%o\u00195jm\u0016\u0014V\r]8tSR|'/\u001f'jm\u0016\u0004\"\u0001\n\t\u0014\u0005AiBCAAf\u0003\u0011i\u0017m[3\u0015\t\u0005U\u0017q\u001d\t\t\u0003\u0013\n9.a7\u0002f&!\u0011\u0011\\A)\u0005\u001d)&\u000bT1zKJ\u0014\u0002\"!8;Q\u0005\u0005\u00181\u001d\u0004\u0007\u0003?\u0004\u0002!a7\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\ta\fi\b\u0012\t\u0005q\u0006u\u0004\n\u0005\u0003y\u0003{\u001a\u0003\"B&\u0013\u0001\u0004a\u0015aD7bW\u0016<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;\u0015\t\u00055(Q\u0004\t\t\u0003\u0013\n9.a<\u0002fJ1\u0011\u0011\u001f\u001e)\u0003g4a!a8\u0011\u0001\u0005=\b\u0003BA{\u0005/qA!a>\u0003\u00149!\u0011\u0011 B\b\u001d\u0011\tYP!\u0003\u000f\t\u0005u(1\u0001\b\u0004Y\u0005}\u0018B\u0001B\u0001\u0003\u0011\u0019H\u000f\u001e9\n\t\t\u0015!qA\u0001\bG2LWM\u001c;4\u0015\t\u0011\t!\u0003\u0003\u0003\f\t5\u0011aD1ts:\u001c\u0007\u000e\u001e;qG2LWM\u001c;\u000b\t\t\u0015!qA\u0005\u0004a\tE!\u0002\u0002B\u0006\u0005\u001bI1\u0001\u000eB\u000b\u0015\r\u0001$\u0011C\u0005\u0005\u00053\u0011YB\u0001\u0006TiR\u00048\t\\5f]RT1\u0001\u000eB\u000b\u0011\u0015Y5\u00031\u0001M\u0001")
public class ArchiveRepositoryLive
implements ArchiveRepository {
    private final Has<package.Clock.Service> clock;
    private final Has<package.Blocking.Service> blocking;
    private final Downloader downloader;
    private final Catalog catalog;
    private final Path directory;

    public static ZLayer<Has<package.Blocking.Service>, Nothing$, Has<ArchiveRepository>> makeWithDefault(Path directory) {
        return ArchiveRepositoryLive$.MODULE$.makeWithDefault(directory);
    }

    public static ZLayer<Has<package.Blocking.Service>, Nothing$, Has<ArchiveRepository>> make(Path directory) {
        return ArchiveRepositoryLive$.MODULE$.make(directory);
    }

    private Function1<ZStream<Object, DownloadError, Object>, ZStream<Has<package.Clock.Service>, DownloadError, Tuple2<Chunk<Object>, DownloadEvent>>> writeToFile(AsynchronousFileChannel file) {
        return (Function1 & Serializable)x$1 -> x$1.groupedWithin(4096, zio.duration.package$.MODULE$.durationInt(100).millis()).mapAccum((Object)new ArchiveRepository.Offset(0L), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArchiveRepository.Offset offset = (ArchiveRepository.Offset)tuple2._1();
            Chunk bytes = (Chunk)tuple2._2();
            ArchiveRepository.Offset nextOffset = (ArchiveRepository.Offset)package$.MODULE$.AssociativeOps((Object)offset).combine((Function0 & Serializable)() -> new ArchiveRepository.Offset(bytes.size()), ArchiveRepository$Offset$.MODULE$.sizeAssociative());
            Tuple2 tuple22 = new Tuple2((Object)nextOffset, (Object)new Tuple3((Object)bytes, (Object)offset, (Object)nextOffset));
            return tuple22;
        }).tap((Function1 & Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Chunk bytes = (Chunk)tuple3._1();
            ArchiveRepository.Offset offset = (ArchiveRepository.Offset)tuple3._2();
            ZIO zIO = file.writeChunk(bytes, offset.value()).mapError((Function1)JumpStartError$IOError$.MODULE$, CanFail$.MODULE$.canFail());
            return zIO;
        }).map((Function1 & Serializable)x0$3 -> {
            Tuple3 tuple3 = x0$3;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Chunk bytes = (Chunk)tuple3._1();
            ArchiveRepository.Offset nextOffset = (ArchiveRepository.Offset)tuple3._3();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bytes), (Object)new DownloadEvent.Progress(nextOffset));
            return tuple2;
        });
    }

    private <R> Function1<ZStream<R, DownloadError, Tuple2<Chunk<Object>, DownloadEvent>>, ZStream<R, DownloadError, Tuple2<Chunk<Object>, DownloadEvent>>> digest(ArchiveRepository.SHA512 expectedDigest) {
        return (Function1 & Serializable)x$3 -> x$3.mapAccum((Object)MessageDigest.getInstance("SHA-512"), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            MessageDigest digest;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    digest = (MessageDigest)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Chunk chunk = (Chunk)tuple2._1();
            DownloadEvent event = (DownloadEvent)tuple2._2();
            digest.update((byte[])chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
            Tuple2 tuple23 = new Tuple2((Object)digest, (Object)new Tuple3((Object)digest, (Object)chunk, (Object)event));
            return tuple23;
        }).zipWithNext().tap((Function1 & Serializable)x0$2 -> {
            Option next;
            Tuple3 tuple3;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    tuple3 = (Tuple3)tuple2._1();
                    next = (Option)tuple2._2();
                    if (tuple3 != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            MessageDigest digest = (MessageDigest)tuple3._1();
            ZIO zIO = ArchiveRepositoryLive.checkDigest$1(digest, expectedDigest).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> next.isEmpty());
            return zIO;
        }).map((Function1 & Serializable)x0$3 -> {
            Tuple3 tuple3;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null || (tuple3 = (Tuple3)tuple2._1()) == null) {
                throw new MatchError((Object)tuple2);
            }
            Chunk bytes = (Chunk)tuple3._2();
            DownloadEvent event = (DownloadEvent)tuple3._3();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bytes), (Object)event);
            return tuple22;
        });
    }

    @Override
    public ZIO<Object, Nothing$, Option<Path>> locate(ArchiveRepository.ComponentId componentId) {
        Path path = this.versionToArchivePath(componentId);
        return ZIO.IfM$.MODULE$.apply$extension(ZIO$.MODULE$.ifM(Files$.MODULE$.exists(path, (Seq)Nil$.MODULE$)), (Function0 & Serializable)() -> ZIO$.MODULE$.some((Function0 & Serializable)() -> path), (Function0 & Serializable)() -> ZIO$.MODULE$.none()).provide(this.blocking, NeedsEnv$.MODULE$.needsEnv());
    }

    private Path versionToArchivePath(ArchiveRepository.ComponentId componentId) {
        Path path;
        ArchiveRepository.ComponentId componentId2 = componentId;
        if (componentId2 instanceof ArchiveRepository.Kafka) {
            ArchiveRepository.Kafka kafka = (ArchiveRepository.Kafka)componentId2;
            KafkaVersion version = kafka.version();
            path = this.baseDirectory().$div(new StringBuilder(14).append("kafka-").append(version.entryName()).append(".archive").toString());
        } else if (componentId2 instanceof ArchiveRepository.ConfluentPlatform) {
            ArchiveRepository.ConfluentPlatform confluentPlatform = (ArchiveRepository.ConfluentPlatform)componentId2;
            ConfluentPlatformVersion version = confluentPlatform.version();
            path = this.baseDirectory().$div(new StringBuilder(18).append("confluent-").append(version.entryName()).append(".archive").toString());
        } else {
            throw new MatchError((Object)componentId2);
        }
        return path;
    }

    @Override
    public ZStream<Object, DownloadError, DownloadEvent> download(ArchiveRepository.ComponentId componentId) {
        ArchiveRepository.RemoteArchive remoteArchive = this.catalog.remoteArchive(componentId);
        return ZStream$.MODULE$.unwrapManaged(this.downloader.download(remoteArchive.uri()).peel(ZSink$.MODULE$.head()).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option maybeBytes = (Option)tuple2._1();
            ZStream leftOver = (ZStream)tuple2._2();
            ZManaged zManaged = ZManaged$.MODULE$.fromOption((Function0 & Serializable)() -> maybeBytes).orElseFail((Function0 & Serializable)() -> new JumpStartError.IOError(new IOException("No content")), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)bytes -> ArchiveRepositoryLive.$anonfun$download$4(this, componentId, remoteArchive, leftOver, BoxesRunTime.unboxToByte((Object)bytes)));
            return zManaged;
        })).provide((Object)Has.HasSyntax$.MODULE$.$plus$plus$extension(Has$.MODULE$.HasSyntax(this.clock), this.blocking, Tag$.MODULE$.apply(Has.class, LightTypeTag$.MODULE$.parse(-1080269438, "\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0000\u0007zio.Has\u0001\u0000\u0004\u0000\u0001\u001dzio.blocking.Blocking.Service\u0001\u0002\u0003\u0000\u0000\u0015zio.blocking.Blocking\u0001\u0002\u0003\u0000\u0000\u0014zio.blocking.package\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0000\u00010\u0001\u0000\u0090\u0002\u0001\u0000\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))), NeedsEnv$.MODULE$.needsEnv());
    }

    private ZManaged<Has<package.Blocking.Service>, JumpStartError.IOError, BoxedUnit> ensureTargetFileWriteable(Path target) {
        return Files$.MODULE$.createDirectories(target, (Seq)Nil$.MODULE$).mapError((Function1)JumpStartError$IOError$.MODULE$, CanFail$.MODULE$.canFail()).toManaged_();
    }

    private ZStream<Has<package.Blocking.Service>, JumpStartError.IOError, DownloadEvent.Finished> moveTmpFileToArchive(Path target, Path archive) {
        return ZStream$.MODULE$.fromEffect(Files$.MODULE$.move(target, archive, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CopyOption[]{StandardCopyOption.ATOMIC_MOVE})).mapError((Function1)JumpStartError$IOError$.MODULE$, CanFail$.MODULE$.canFail()).as((Function0 & Serializable)() -> new DownloadEvent.Finished(archive)));
    }

    @Override
    public Path baseDirectory() {
        return this.directory;
    }

    private static final ZIO checkDigest$1(MessageDigest digest, ArchiveRepository.SHA512 expectedDigest$1) {
        return IO$.MODULE$.effect((Function0 & Serializable)() -> new ArchiveRepository.SHA512((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)digest.digest()))).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)computedDigest -> IO$.MODULE$.fail((Function0 & Serializable)() -> new JumpStartError.DigestFailed(expectedDigest$1, (ArchiveRepository.SHA512)computedDigest)).unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            ArchiveRepository.SHA512 sHA512 = computedDigest;
            ArchiveRepository.SHA512 sHA5122 = expectedDigest$1;
            return !(sHA512 != null ? !((Object)sHA512).equals(sHA5122) : sHA5122 != null);
        }));
    }

    public static final /* synthetic */ ZManaged $anonfun$download$4(ArchiveRepositoryLive $this, ArchiveRepository.ComponentId componentId$1, ArchiveRepository.RemoteArchive remoteArchive$1, ZStream leftOver$1, byte bytes) {
        return $this.ensureTargetFileWriteable($this.baseDirectory()).flatMap((Function1 & Serializable)x$5 -> {
            BoxedUnit boxedUnit = x$5;
            ZManaged zManaged = Files$.MODULE$.createTempFileInManaged($this.baseDirectory(), Files$.MODULE$.createTempFileInManaged$default$2(), Files$.MODULE$.createTempFileInManaged$default$3(), Files$.MODULE$.createTempFileInManaged$default$4()).mapError((Function1)JumpStartError$IOError$.MODULE$, CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)target -> AsynchronousFileChannel$.MODULE$.open(target, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE})).mapError((Function1)JumpStartError$IOError$.MODULE$, CanFail$.MODULE$.canFail()).map((Function1 & Serializable)file -> {
                Path archive = $this.versionToArchivePath(componentId$1);
                ZStream events = ZStream$.MODULE$.succeed((Function0 & Serializable)() -> new DownloadEvent.Started(remoteArchive$1.size())).$plus$plus((Function0 & Serializable)() -> ZStream$.MODULE$.succeed((Function0)(JFunction0.mcB.sp & Serializable)() -> bytes).$plus$plus((Function0 & Serializable)() -> leftOver$1).via($this.writeToFile((AsynchronousFileChannel)file)).via($this.digest(remoteArchive$1.SHA512())).map((Function1 & Serializable)x0$1 -> {
                    DownloadEvent event;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    DownloadEvent downloadEvent = event = (DownloadEvent)tuple2._2();
                    return downloadEvent;
                }).concat((Function0 & Serializable)() -> $this.moveTmpFileToArchive((Path)target, archive)));
                return events;
            }));
            return zManaged;
        });
    }

    public ArchiveRepositoryLive(Has<package.Clock.Service> clock, Has<package.Blocking.Service> blocking, Downloader downloader, Catalog catalog, Path directory) {
        this.clock = clock;
        this.blocking = blocking;
        this.downloader = downloader;
        this.catalog = catalog;
        this.directory = directory;
    }
}

