/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.slf4j.Logger;

public class StandardAuthorizerData {
    public static final String WILDCARD = "*";
    public static final String WILDCARD_PRINCIPAL = "User:*";
    final Logger log;
    final AclMutator aclMutator;
    private final Set<String> superUsers;
    private final AuthorizationResult defaultResult;
    private final ConcurrentSkipListSet<StandardAcl> aclsByResource;
    private final ConcurrentHashMap<Uuid, StandardAcl> aclsById;
    private static final Set<AclOperation> IMPLIES_DESCRIBE = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE, AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER));
    private static final Set<AclOperation> IMPLIES_DESCRIBE_CONFIGS = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS));

    private static Logger createLogger(int nodeId) {
        return new LogContext("[StandardAuthorizer " + nodeId + "] ").logger(StandardAuthorizerData.class);
    }

    static StandardAuthorizerData createEmpty() {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(-1), null, Collections.emptySet(), AuthorizationResult.DENIED, new ConcurrentSkipListSet<StandardAcl>(), new ConcurrentHashMap<Uuid, StandardAcl>());
    }

    private StandardAuthorizerData(Logger log, AclMutator aclMutator, Set<String> superUsers, AuthorizationResult defaultResult, ConcurrentSkipListSet<StandardAcl> aclsByResource, ConcurrentHashMap<Uuid, StandardAcl> aclsById) {
        this.log = log;
        this.aclMutator = aclMutator;
        this.superUsers = superUsers;
        this.defaultResult = defaultResult;
        this.aclsByResource = aclsByResource;
        this.aclsById = aclsById;
    }

    StandardAuthorizerData copyWithNewAclMutator(AclMutator newAclMutator) {
        return new StandardAuthorizerData(this.log, newAclMutator, this.superUsers, this.defaultResult, this.aclsByResource, this.aclsById);
    }

    StandardAuthorizerData copyWithNewConfig(int nodeId, Set<String> newSuperUsers, AuthorizationResult newDefaultResult) {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(nodeId), this.aclMutator, newSuperUsers, newDefaultResult, this.aclsByResource, this.aclsById);
    }

    StandardAuthorizerData copyWithNewAcls(Collection<Map.Entry<Uuid, StandardAcl>> aclEntries) {
        StandardAuthorizerData newData = new StandardAuthorizerData(this.log, this.aclMutator, this.superUsers, this.defaultResult, new ConcurrentSkipListSet<StandardAcl>(), new ConcurrentHashMap<Uuid, StandardAcl>());
        for (Map.Entry<Uuid, StandardAcl> entry : aclEntries) {
            newData.addAcl(entry.getKey(), entry.getValue());
        }
        this.log.info("Applied " + aclEntries.size() + "acl(s) from image.");
        return newData;
    }

    void addAcl(Uuid id, StandardAcl acl) {
        try {
            StandardAcl prevAcl = this.aclsById.putIfAbsent(id, acl);
            if (prevAcl != null) {
                throw new RuntimeException("An ACL with ID " + id + " already exists.");
            }
            if (!this.aclsByResource.add(acl)) {
                this.aclsById.remove(id);
                throw new RuntimeException("Unable to add the ACL with ID " + id + " to aclsByResource");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Added ACL " + id + ": " + acl);
            }
        }
        catch (Throwable e) {
            this.log.error("addAcl error", e);
            throw e;
        }
    }

    void removeAcl(Uuid id) {
        try {
            StandardAcl acl = this.aclsById.remove(id);
            if (acl == null) {
                throw new RuntimeException("ID " + id + " not found in aclsById.");
            }
            if (!this.aclsByResource.remove(acl)) {
                throw new RuntimeException("Unable to remove the ACL with ID " + id + " from aclsByResource");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Removed ACL " + id + ": " + acl);
            }
        }
        catch (Throwable e) {
            this.log.error("removeAcl error", e);
            throw e;
        }
    }

    Set<String> superUsers() {
        return this.superUsers;
    }

    AuthorizationResult defaultResult() {
        return this.defaultResult;
    }

    int aclCount() {
        return this.aclsById.size();
    }

    AuthorizationResult authorize(AuthorizableRequestContext requestContext, Action action) {
        if (this.superUsers.contains(requestContext.principal().toString())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("authorize(requestContext=" + requestContext + ", action=" + action + "): ALLOWED because " + requestContext.principal().toString() + " is a superuser");
            }
            return AuthorizationResult.ALLOWED;
        }
        AuthorizationResultBuilder builder = new AuthorizationResultBuilder();
        StandardAcl exemplar = new StandardAcl(action.resourcePattern().resourceType(), action.resourcePattern().name(), PatternType.UNKNOWN, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        this.checkSection(action, exemplar, requestContext, builder);
        if (builder.foundDeny) {
            return AuthorizationResult.DENIED;
        }
        exemplar = new StandardAcl(action.resourcePattern().resourceType(), WILDCARD, PatternType.LITERAL, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        this.checkSection(action, exemplar, requestContext, builder);
        if (builder.foundDeny) {
            return AuthorizationResult.DENIED;
        }
        if (builder.foundAllow) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("authorize(requestContext=" + requestContext + ", action=" + action + "): ALLOWED");
            }
            return AuthorizationResult.ALLOWED;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("authorize(requestContext=" + requestContext + ", action=" + action + "): returning default result " + this.defaultResult);
        }
        return this.defaultResult;
    }

    void checkSection(Action action, StandardAcl exemplar, AuthorizableRequestContext requestContext, AuthorizationResultBuilder builder) {
        NavigableSet<StandardAcl> tailSet = this.aclsByResource.tailSet(exemplar, true);
        String resourceName = action.resourcePattern().name();
        for (StandardAcl acl : tailSet) {
            AuthorizationResult result;
            if (!acl.resourceType().equals((Object)action.resourcePattern().resourceType())) break;
            if (resourceName.startsWith(acl.resourceName())) {
                if (acl.patternType() == PatternType.LITERAL && !resourceName.equals(acl.resourceName())) {
                    continue;
                }
            } else if (!acl.resourceName().equals(WILDCARD) || acl.patternType() != PatternType.LITERAL) break;
            if (AuthorizationResult.ALLOWED == (result = StandardAuthorizerData.findResult(action, requestContext, acl))) {
                builder.foundAllow = true;
                continue;
            }
            if (AuthorizationResult.DENIED != result) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("authorize(requestContext=" + requestContext + ", action=" + action + "): DENIED because of " + acl);
            }
            builder.foundDeny = true;
            return;
        }
    }

    static AuthorizationResult findResult(Action action, AuthorizableRequestContext requestContext, StandardAcl acl) {
        block11: {
            block12: {
                if (!acl.principal().equals(WILDCARD_PRINCIPAL) && !acl.principal().equals(requestContext.principal().toString())) {
                    return null;
                }
                if (!acl.host().equals(WILDCARD)) {
                    String host = requestContext.clientAddress().getHostAddress();
                    if (!acl.host().equals(host)) {
                        return null;
                    }
                }
                if (acl.operation() == AclOperation.ALL) break block11;
                if (!acl.permissionType().equals((Object)AclPermissionType.ALLOW)) break block12;
                switch (action.operation()) {
                    case DESCRIBE: {
                        if (!IMPLIES_DESCRIBE.contains(acl.operation())) {
                            return null;
                        }
                        break block11;
                    }
                    case DESCRIBE_CONFIGS: {
                        if (!IMPLIES_DESCRIBE_CONFIGS.contains(acl.operation())) {
                            return null;
                        }
                        break block11;
                    }
                    default: {
                        if (action.operation() != acl.operation()) {
                            return null;
                        }
                        break block11;
                    }
                }
            }
            if (action.operation() != acl.operation()) {
                return null;
            }
        }
        return acl.permissionType().equals((Object)AclPermissionType.ALLOW) ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
    }

    Iterable<AclBinding> acls(AclBindingFilter filter) {
        return new AclIterable(filter);
    }

    class AclIterator
    implements Iterator<AclBinding> {
        private final AclBindingFilter filter;
        private final Iterator<StandardAcl> iterator;
        private AclBinding next;

        AclIterator(AclBindingFilter filter) {
            this.filter = filter;
            this.iterator = StandardAuthorizerData.this.aclsByResource.iterator();
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                AclBinding binding = this.iterator.next().toBinding();
                if (!this.filter.matches(binding)) continue;
                this.next = binding;
            }
            return true;
        }

        @Override
        public AclBinding next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AclBinding result = this.next;
            this.next = null;
            return result;
        }
    }

    class AclIterable
    implements Iterable<AclBinding> {
        private final AclBindingFilter filter;

        AclIterable(AclBindingFilter filter) {
            this.filter = filter;
        }

        @Override
        public Iterator<AclBinding> iterator() {
            return new AclIterator(this.filter);
        }
    }

    static class AuthorizationResultBuilder {
        boolean foundDeny = false;
        boolean foundAllow = false;

        AuthorizationResultBuilder() {
        }
    }
}

