/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird.javaapi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class MethodRegistry {
    private final Map<Class<?>, Method> classToMethod = new HashMap();
    private final Object provider;
    private final Class<?> provided;

    MethodRegistry(Object object, Class<?> clazz) {
        this.provider = object;
        this.provided = clazz;
        Object[] objectArray = clazz.getTypeParameters();
        if (objectArray == null || objectArray.length != 1) {
            throw new IllegalArgumentException("provided must have exactly one type parameter. Found: " + Arrays.toString(objectArray));
        }
        Class<?> clazz2 = object.getClass();
        HashSet<Class> hashSet = new HashSet<Class>();
        for (Method method : clazz2.getMethods()) {
            Type type;
            Class clazz3;
            Type type2;
            if (method.getParameterTypes().length != 0 || !method.getReturnType().isAssignableFrom(clazz) || !((type2 = method.getGenericReturnType()) instanceof ParameterizedType) || (clazz3 = (type = ((ParameterizedType)type2).getActualTypeArguments()[0]) instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type) == Object.class || hashSet.contains(clazz3) || this.classToMethod.put(clazz3, method) == null) continue;
            this.classToMethod.remove(clazz3);
            hashSet.add(clazz3);
        }
    }

    private Method getMethod(Class<?> clazz) {
        Method method = this.classToMethod.get(clazz);
        if (method == null && clazz.getSuperclass() != null) {
            return this.getMethod(clazz.getSuperclass());
        }
        return method;
    }

    private String typeName(Class<?> clazz) {
        return this.provided.getSimpleName() + "<" + clazz + ">";
    }

    Object resolveAndInvoke(Class<?> clazz) {
        Method method = this.getMethod(clazz);
        if (method != null) {
            try {
                return method.invoke(this.provider, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException("Could not resolve " + this.typeName(clazz) + " because " + method.getName() + "() threw an exception", invocationTargetException.getTargetException());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Should not happen. Could not resolve " + this.typeName(clazz) + " because " + method.getName() + "() is not accessible", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Should not happen. Could not call " + method.getName() + " on provider object", illegalArgumentException);
            }
        }
        throw new IllegalArgumentException(this.typeName(clazz) + " not found");
    }
}

