/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.AdaptiveVector;
import com.twitter.algebird.DenseVector;
import com.twitter.algebird.Group;
import com.twitter.algebird.Monoid;
import com.twitter.algebird.Semigroup;
import com.twitter.algebird.SparseVector;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Equiv;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AdaptiveVector$ {
    public static final AdaptiveVector$ MODULE$ = new AdaptiveVector$();
    private static final double THRESHOLD = 0.25;

    public double THRESHOLD() {
        return THRESHOLD;
    }

    public <V> AdaptiveVector<V> fill(int size, V sparse) {
        return new SparseVector<V>(Predef$.MODULE$.Map().empty(), sparse, size);
    }

    public <V> AdaptiveVector<V> fromVector(Vector<V> v, V sparseVal) {
        int sz;
        if (v.size() == 0) {
            return this.fill(0, sparseVal);
        }
        int denseCount = v.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdaptiveVector$.$anonfun$fromVector$1(sparseVal, x$1)));
        if ((double)denseCount < (double)(sz = v.size()) * this.THRESHOLD()) {
            return new SparseVector<V>(this.toMap((IndexedSeq<V>)v, sparseVal), sparseVal, sz);
        }
        return new DenseVector<V>(v, sparseVal, denseCount);
    }

    public <V> AdaptiveVector<V> fromMap(Map<Object, V> m, V sparseVal, int sizeOfDense) {
        if (m.size() == 0) {
            return this.fill(sizeOfDense, sparseVal);
        }
        int maxIdx = BoxesRunTime.unboxToInt((Object)m.keys().max((Ordering)Ordering.Int$.MODULE$));
        Predef$.MODULE$.require(maxIdx < sizeOfDense, (Function0 & Serializable)() -> new StringBuilder(36).append("Max key (").append(maxIdx).append(") exceeds valid for size (").append(sizeOfDense).append(")").toString());
        int denseCount = m.count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdaptiveVector$.$anonfun$fromMap$2(sparseVal, x$2)));
        if ((double)denseCount < (double)sizeOfDense * this.THRESHOLD()) {
            return new SparseVector<V>(m, sparseVal, sizeOfDense);
        }
        return new DenseVector<V>(this.toVector(m, sparseVal, sizeOfDense), sparseVal, denseCount);
    }

    public <V> Map<Object, V> toMap(AdaptiveVector<V> v) {
        Map map;
        if (v instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)v;
            Vector is = denseVector.iseq();
            Object sv = denseVector.sparseValue();
            map = this.toMap((IndexedSeq<V>)is, sv);
        } else if (v instanceof SparseVector) {
            map = ((SparseVector)v).map();
        } else {
            throw new MatchError(v);
        }
        return map;
    }

    public <V> Map<Object, V> toMap(IndexedSeq<V> iseq, V sparse) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)iseq.view().zipWithIndex()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdaptiveVector$.$anonfun$toMap$1(sparse, x$3)))).map((Function1 & Serializable)x$4 -> x$4.swap())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <V> Vector<V> toVector(Map<Object, V> m, V sparse, int size) {
        Buffer buf = (Buffer)Buffer$.MODULE$.fill(size, (Function0 & Serializable)() -> sparse);
        m.foreach((Function1 & Serializable)x0$1 -> {
            AdaptiveVector$.$anonfun$toVector$2(buf, x0$1);
            return BoxedUnit.UNIT;
        });
        return package$.MODULE$.Vector().from((IterableOnce)buf);
    }

    public <V> Vector<V> toVector(AdaptiveVector<V> v) {
        Vector vector;
        if (v instanceof DenseVector) {
            vector = ((DenseVector)v).iseq();
        } else if (v instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)v;
            Map m = sparseVector.map();
            Object v2 = sparseVector.sparseValue();
            int sz = sparseVector.length();
            vector = this.toVector(m, v2, sz);
        } else {
            throw new MatchError(v);
        }
        return vector;
    }

    public <V> AdaptiveVector<V> com$twitter$algebird$AdaptiveVector$$withSparse(AdaptiveVector<V> v, V sv) {
        if (BoxesRunTime.equals(v.sparseValue(), sv)) {
            return v;
        }
        return this.fromVector(this.toVector(v), sv);
    }

    public <V> Semigroup<AdaptiveVector<V>> semigroup(Semigroup<V> evidence$4) {
        return new AdaptiveVector.AVSemigroup<V>(evidence$4);
    }

    public <V> Monoid<AdaptiveVector<V>> monoid(Monoid<V> evidence$5) {
        return new AdaptiveVector.AVMonoid<V>(evidence$5);
    }

    public <V> Group<AdaptiveVector<V>> group(Group<V> evidence$6) {
        return new AdaptiveVector.AVGroup<V>(evidence$6);
    }

    public <V> Equiv<AdaptiveVector<V>> denseEquiv(Equiv<V> evidence$7) {
        return package$.MODULE$.Equiv().fromFunction((Function2 & Serializable)(l, r) -> BoxesRunTime.boxToBoolean((boolean)AdaptiveVector$.$anonfun$denseEquiv$1(this, evidence$7, l, r)));
    }

    public <V> Equiv<AdaptiveVector<V>> equiv(Equiv<V> evidence$8) {
        return package$.MODULE$.Equiv().fromFunction((Function2 & Serializable)(l, r) -> BoxesRunTime.boxToBoolean((boolean)AdaptiveVector$.$anonfun$equiv$1(evidence$8, l, r)));
    }

    public static final /* synthetic */ boolean $anonfun$fromVector$1(Object sparseVal$1, Object x$1) {
        return !BoxesRunTime.equals((Object)x$1, (Object)sparseVal$1);
    }

    public static final /* synthetic */ boolean $anonfun$fromMap$2(Object sparseVal$2, Tuple2 x$2) {
        return !BoxesRunTime.equals((Object)x$2._2(), (Object)sparseVal$2);
    }

    public static final /* synthetic */ boolean $anonfun$toMap$1(Object sparse$1, Tuple2 x$3) {
        return !BoxesRunTime.equals((Object)x$3._1(), (Object)sparse$1);
    }

    public static final /* synthetic */ void $anonfun$toVector$2(Buffer buf$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int idx = x0$1._1$mcI$sp();
            Object v = x0$1._2();
            buf$1.update(idx, v);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean iteq$1(Iterator lit$1, Iterator rit$1, Equiv evidence$7$1) {
        boolean bl;
        block2: {
            boolean bl2;
            boolean bl3;
            block1: {
                void var6_5;
                void var5_4;
                do {
                    bl3 = rit$1.hasNext();
                    bl2 = lit$1.hasNext();
                    if (!bl2 || !bl3) break block1;
                    Object object = rit$1.next();
                    Tuple2 lnext = (Tuple2)lit$1.next();
                    Tuple2 rnext = (Tuple2)object;
                } while (var5_4._1$mcI$sp() == var6_5._1$mcI$sp() && package$.MODULE$.Equiv().apply(evidence$7$1).equiv(var5_4._2(), var6_5._2()));
                bl = false;
                break block2;
            }
            bl = false == bl2 && false == bl3;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$denseEquiv$1(AdaptiveVector$ $this, Equiv evidence$7$1, AdaptiveVector l, AdaptiveVector r) {
        void var4_5;
        Iterator iterator2 = r.denseIterator();
        Iterator lit = l.denseIterator();
        return package$.MODULE$.Equiv().apply(evidence$7$1).equiv(l.sparseValue(), r.sparseValue()) && $this.iteq$1((Iterator)var4_5, iterator2, evidence$7$1);
    }

    public static final /* synthetic */ boolean $anonfun$equiv$2(Equiv evidence$8$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Object lv = x0$1._1();
        Object rv = x0$1._2();
        boolean bl = package$.MODULE$.Equiv().apply(evidence$8$1).equiv(lv, rv);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$equiv$1(Equiv evidence$8$1, AdaptiveVector l, AdaptiveVector r) {
        return l.size() == r.size() && (MODULE$.denseEquiv(evidence$8$1).equiv((Object)l, (Object)r) || ((IterableOnceOps)MODULE$.toVector(l).view().zip(MODULE$.toVector(r))).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdaptiveVector$.$anonfun$equiv$2(evidence$8$1, x0$1))));
    }

    private AdaptiveVector$() {
    }
}

