/*
 * Decompiled with CFR 0.152.
 */
package sttp.model.headers;

import java.io.Serializable;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import sttp.model.headers.Range;
import sttp.model.internal.ParseUtils$;
import sttp.model.internal.Validate$;

public final class Range$
implements Serializable {
    public static final Range$ MODULE$ = new Range$();

    public Either<String, List<Range>> parse(String str) {
        Left left;
        Object object;
        String[] stringArray = str.split("=");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
            String unit = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String s = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            List<Range> ranges = this.processString(s, unit, (List<Range>)package$.MODULE$.List().empty());
            left = ranges.forall((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)Range$.MODULE$.validateRange(range))) && ranges.nonEmpty() ? package$.MODULE$.Right().apply((Object)ranges.reverse()) : package$.MODULE$.Left().apply((Object)"Invalid Range");
        } else {
            left = package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected range in the format: \"unit=start/end\", but got: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str})));
        }
        return left;
    }

    private List<Range> processString(String s, String unit, List<Range> acc) {
        List list;
        while ((list = Predef$.MODULE$.wrapRefArray((Object[])s.split(",")).toList()) instanceof .colon.colon) {
            Range range;
            .colon.colon colon2 = (.colon.colon)list;
            String x = (String)colon2.head();
            List tail = colon2.next$access$1();
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x))) break;
            Range range2 = range = this.parsSingleRange(x, unit);
            acc = acc.$colon$colon((Object)range2);
            s = tail.mkString(",");
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        List list3 = !(nil$ != null ? !nil$.equals(list2) : list2 != null) ? (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range[]{this.parsSingleRange(s, unit)})) : acc;
        return list3;
    }

    private Range parsSingleRange(String rangeString, String unit) {
        Object object;
        Range range;
        Object object2;
        String[] stringArray = rangeString.trim().split("-");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
            String start = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
            String end = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
            range = new Range(ParseUtils$.MODULE$.toLongOption(start), ParseUtils$.MODULE$.toLongOption(end), unit);
        } else if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
            String start = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            range = new Range(ParseUtils$.MODULE$.toLongOption(start), (Option<Object>)None$.MODULE$, unit);
        } else {
            range = new Range((Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, unit);
        }
        return range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateRange(Range range) {
        Tuple2 tuple2 = new Tuple2(range.start(), range.end());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                long start = BoxesRunTime.unboxToLong((Object)some.value());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    long end = BoxesRunTime.unboxToLong((Object)some2.value());
                    if (start >= end) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some && None$.MODULE$.equals(option3)) {
                return true;
            }
        }
        if (tuple2 == null) return false;
        Option option = (Option)tuple2._1();
        Option option4 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) return false;
        if (!(option4 instanceof Some)) return false;
        return true;
    }

    public List<Range> unsafeParse(String s) {
        return Validate$.MODULE$.RichEither(this.parse(s)).getOrThrow();
    }

    public List<Range> unsafeApply(Option<Object> start, Option<Object> end, String unit) {
        return Validate$.MODULE$.RichEither(this.safeApply(start, end, unit)).getOrThrow();
    }

    public Either<String, List<Range>> safeApply(Option<Object> start, Option<Object> end, String unit) {
        Range range = new Range(start, end, unit);
        return this.validateRange(range) ? package$.MODULE$.Right().apply(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range[]{range}))) : package$.MODULE$.Left().apply((Object)"Invalid Range");
    }

    public Range apply(Option<Object> start, Option<Object> end, String unit) {
        return new Range(start, end, unit);
    }

    public Option<Tuple3<Option<Object>, Option<Object>, String>> unapply(Range x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3(x$0.start(), x$0.end(), (Object)x$0.unit()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Range$.class);
    }

    private Range$() {
    }
}

