/*
 * Decompiled with CFR 0.152.
 */
package sttp.model.headers;

import java.io.Serializable;
import scala.Array;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import sttp.model.headers.ContentRange;
import sttp.model.internal.ParseUtils$;
import sttp.model.internal.Validate$;

public final class ContentRange$
implements Serializable {
    public static final ContentRange$ MODULE$ = new ContentRange$();

    public Either<String, ContentRange> parse(String str) {
        Left left;
        Object object;
        String[] stringArray = str.trim().split(" ");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
            Either<String, ContentRange> either;
            Object object2;
            String unit = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String s = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            String[] stringArray2 = s.split("/");
            if (stringArray2 != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray2)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
                String possibleRange = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                String possibleSize = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                either = this.processString(unit, possibleRange, possibleSize);
            } else {
                either = package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected string in the format: \"range/size\", but got: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s})));
            }
            left = either;
        } else {
            left = package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected content-range in the format: \"unit range/size\", but got: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str})));
        }
        return left;
    }

    private Either<String, ContentRange> processString(String unit, String possibleRange, String possibleSize) {
        Object object;
        None$ none$;
        String string;
        Object object2;
        String[] stringArray = possibleRange.split("-");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1) == 0 && "*".equals(string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0))) {
            none$ = None$.MODULE$;
        } else if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
            String start = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String end = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            none$ = Option$.MODULE$.option2Iterable(ParseUtils$.MODULE$.toLongOption(start).zip(ParseUtils$.MODULE$.toLongOption(end))).headOption();
        } else {
            none$ = None$.MODULE$;
        }
        None$ range = none$;
        Option<Object> size = possibleSize.equals("*") ? None$.MODULE$ : ParseUtils$.MODULE$.toLongOption(possibleSize);
        ContentRange contentRange = new ContentRange(unit, (Option<Tuple2<Object, Object>>)range, size);
        return this.isValid(contentRange) ? package$.MODULE$.Right().apply((Object)contentRange) : package$.MODULE$.Left().apply((Object)"Invalid Content-Range");
    }

    private boolean isValid(ContentRange contentRange) {
        boolean bl;
        boolean isSyntaxInvalid = contentRange.range().isEmpty() && contentRange.size().isEmpty();
        Option<Tuple2<Object, Object>> option = contentRange.range();
        if (option instanceof Some) {
            boolean bl2;
            Some some = (Some)option;
            Tuple2 range = (Tuple2)some.value();
            boolean isRangeValid = range._1$mcJ$sp() < range._2$mcJ$sp();
            Option<Object> option2 = contentRange.size();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                long size = BoxesRunTime.unboxToLong((Object)some2.value());
                boolean isRangeAndSizeValid = range._1$mcJ$sp() < size & range._2$mcJ$sp() <= size;
                bl2 = isRangeValid && !isSyntaxInvalid && isRangeAndSizeValid;
            } else if (None$.MODULE$.equals(option2)) {
                bl2 = isRangeValid && !isSyntaxInvalid;
            } else {
                throw new MatchError(option2);
            }
            bl = bl2;
        } else if (None$.MODULE$.equals(option)) {
            bl = !isSyntaxInvalid;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public ContentRange unsafeParse(String s) {
        return Validate$.MODULE$.RichEither(this.parse(s)).getOrThrow();
    }

    public ContentRange unsafeApply(String unit, Option<Tuple2<Object, Object>> range, Option<Object> size) {
        return Validate$.MODULE$.RichEither(this.safeApply(unit, range, size)).getOrThrow();
    }

    public Either<String, ContentRange> safeApply(String unit, Option<Tuple2<Object, Object>> range, Option<Object> size) {
        ContentRange contentRange = new ContentRange(unit, range, size);
        return this.isValid(contentRange) ? package$.MODULE$.Right().apply((Object)contentRange) : package$.MODULE$.Left().apply((Object)"Invalid Content Range");
    }

    public ContentRange apply(String unit, Option<Tuple2<Object, Object>> range, Option<Object> size) {
        return new ContentRange(unit, range, size);
    }

    public Option<Tuple3<String, Option<Tuple2<Object, Object>>, Option<Object>>> unapply(ContentRange x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.unit(), x$0.range(), x$0.size()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ContentRange$.class);
    }

    private ContentRange$() {
    }
}

