/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import sttp.model.Uri;
import sttp.model.Uri$EmptyPath$;
import sttp.model.UriInterpolator;
import sttp.model.UriInterpolator$AuthorityEnd$;
import sttp.model.UriInterpolator$FragmentStart$;
import sttp.model.UriInterpolator$PathStart$;
import sttp.model.UriInterpolator$QueryStart$;
import sttp.model.UriInterpolator$SchemeEnd$;
import sttp.model.UriInterpolator$SlashInPath$;
import sttp.model.UriInterpolator$Tokenizer$Scheme$;
import sttp.model.UriInterpolator$UriBuilder$Fragment$;
import sttp.model.UriInterpolator$UriBuilder$HostPort$;
import sttp.model.UriInterpolator$UriBuilder$Path$;
import sttp.model.UriInterpolator$UriBuilder$Query$;
import sttp.model.UriInterpolator$UriBuilder$Scheme$;
import sttp.model.UriInterpolator$UriBuilder$UserInfo$;
import sttp.model.internal.ArrayView;

public final class UriInterpolator$ {
    public static final UriInterpolator$ MODULE$ = new UriInterpolator$();
    private static final Uri startingUri = new Uri((Option<String>)None$.MODULE$, (Option<Uri.Authority>)None$.MODULE$, Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Nil(), (Option<Uri.Segment>)None$.MODULE$);
    private static final List<Product> builders;
    private static final UriInterpolator.StringToken sttp$model$UriInterpolator$$emptyStringToken;
    private static volatile int bitmap$init$0;

    static {
        bitmap$init$0 |= 1;
        builders = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{UriInterpolator$UriBuilder$Scheme$.MODULE$, UriInterpolator$UriBuilder$UserInfo$.MODULE$, UriInterpolator$UriBuilder$HostPort$.MODULE$, UriInterpolator$UriBuilder$Path$.MODULE$, UriInterpolator$UriBuilder$Query$.MODULE$, UriInterpolator$UriBuilder$Fragment$.MODULE$}));
        bitmap$init$0 |= 2;
        sttp$model$UriInterpolator$$emptyStringToken = new UriInterpolator.StringToken("");
        bitmap$init$0 |= 4;
    }

    private Uri startingUri() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/sttp-model/sttp-model/core/src/main/scala/sttp/model/UriInterpolator.scala: 44");
        }
        return startingUri;
    }

    private List<Product> builders() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/sttp-model/sttp-model/core/src/main/scala/sttp/model/UriInterpolator.scala: 46");
        }
        return builders;
    }

    public UriInterpolator.StringToken sttp$model$UriInterpolator$$emptyStringToken() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/sttp-model/sttp-model/core/src/main/scala/sttp/model/UriInterpolator.scala: 55");
        }
        return sttp$model$UriInterpolator$$emptyStringToken;
    }

    public Uri interpolate(StringContext sc, Seq<Object> args) {
        boolean isScEmptyString = ((IterableOnceOps)sc.parts().map((Function1 & Serializable)x$1 -> x$1.trim())).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals("")));
        boolean areArgsEmptyString = args.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equals("")));
        if (isScEmptyString && areArgsEmptyString) {
            throw new IllegalArgumentException("empty string is not valid uri");
        }
        ArrayBuffer<UriInterpolator.Token> tokens = this.tokenize(sc, args);
        Tuple2 tuple2 = (Tuple2)this.builders().foldLeft((Object)new Tuple2((Object)this.startingUri(), this.filterNulls(tokens)), (Function2 & Serializable)(x0$1, x1$1) -> {
            Product builder;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    builder = (Product)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Uri u = (Uri)tuple2._1();
            ArrayView t = (ArrayView)tuple2._2();
            Tuple2<Uri, ArrayView<UriInterpolator.Token>> tuple23 = ((UriInterpolator.UriBuilder)builder).fromTokens(u, t);
            return tuple23;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Uri uri = (Uri)tuple2._1();
        ArrayView leftTokens = (ArrayView)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)uri, (Object)leftTokens);
        Tuple2 tuple23 = tuple22;
        Uri uri2 = (Uri)tuple23._1();
        ArrayView leftTokens2 = (ArrayView)tuple23._2();
        if (leftTokens2.nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(59).append("Tokens left after building the whole uri: ").append(leftTokens2).append(", result so far: ").append(uri2).toString());
        }
        return uri2;
    }

    private ArrayBuffer<UriInterpolator.Token> tokenize(StringContext sc, Seq<Object> args) {
        Iterator strings = sc.parts().iterator();
        Iterator expressions = args.iterator();
        ArrayBuffer tokens = new ArrayBuffer(32);
        ObjectRef tokenizer = ObjectRef.create((Object)UriInterpolator$Tokenizer$Scheme$.MODULE$.tokenize((ArrayBuffer<UriInterpolator.Token>)tokens, (String)strings.next()));
        while (strings.hasNext()) {
            Object nextExpression = expressions.next();
            String nextExpressionStr = nextExpression.toString();
            String nextStr = (String)strings.next();
            if (tokens.size() == 1 && tokens.startsWith((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UriInterpolator.StringToken[]{this.sttp$model$UriInterpolator$$emptyStringToken()})), tokens.startsWith$default$2()) && (nextExpressionStr.contains("://") || !nextStr.contains("://"))) {
                UriInterpolator$.tokenizeExpressionAsString$1(tokenizer, tokens, nextExpression);
                this.tokenizeStringRemoveEmptyPrefix$1(tokens, tokenizer, nextStr);
                continue;
            }
            tokens.$plus$eq((Object)new UriInterpolator.ExpressionToken(nextExpression));
            tokenizer.elem = ((UriInterpolator.Tokenizer)tokenizer.elem).tokenize((ArrayBuffer<UriInterpolator.Token>)tokens, nextStr);
        }
        ((UriInterpolator.Tokenizer)tokenizer.elem).endToken().foreach((Function1 & Serializable)x$10 -> (ArrayBuffer)tokens.$plus$eq(x$10));
        this.removeEmptyTokensAroundExp((ArrayBuffer<UriInterpolator.Token>)tokens);
        this.addPathStartAfterAuthorityOrSchemeEnd((ArrayBuffer<UriInterpolator.Token>)tokens);
        return tokens;
    }

    private void removeEmptyTokensAroundExp(ArrayBuffer<UriInterpolator.Token> tokens) {
        BooleanRef prevWasEmptyString = BooleanRef.create((boolean)false);
        BooleanRef prevWasExpression = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), tokens.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            UriInterpolator.Token token = (UriInterpolator.Token)tokens.apply(idx);
            UriInterpolator.StringToken stringToken = MODULE$.sttp$model$UriInterpolator$$emptyStringToken();
            UriInterpolator.Token token2 = token;
            if (!(stringToken != null ? !((Object)stringToken).equals(token2) : token2 != null)) {
                BoxedUnit boxedUnit;
                if (prevWasExpression$1.elem) {
                    tokens.update(idx, null);
                    prevWasExpression$1.elem = false;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    prevWasEmptyString$1.elem = true;
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (token instanceof UriInterpolator.ExpressionToken) {
                if (prevWasEmptyString$1.elem) {
                    tokens.update(idx - 1, null);
                    prevWasEmptyString$1.elem = false;
                }
                prevWasExpression$1.elem = true;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (token == null) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                prevWasExpression$1.elem = false;
                prevWasEmptyString$1.elem = false;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    private void addPathStartAfterAuthorityOrSchemeEnd(ArrayBuffer<UriInterpolator.Token> tokens) {
        int n;
        int n2 = tokens.indexOf((Object)UriInterpolator$AuthorityEnd$.MODULE$);
        switch (n2) {
            case -1: {
                n = tokens.indexOf((Object)UriInterpolator$SchemeEnd$.MODULE$);
                break;
            }
            default: {
                n = n2;
                break;
            }
        }
        int endIndex = n;
        this.nextNonNull(tokens, endIndex + 1).foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            UriInterpolator.Token afterEndIndex;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            UriInterpolator.Token token = afterEndIndex = (UriInterpolator.Token)tuple2._2();
            UriInterpolator$PathStart$ uriInterpolator$PathStart$ = UriInterpolator$PathStart$.MODULE$;
            if (token == null ? uriInterpolator$PathStart$ != null : !token.equals(uriInterpolator$PathStart$)) {
                UriInterpolator.Token token2 = afterEndIndex;
                UriInterpolator$QueryStart$ uriInterpolator$QueryStart$ = UriInterpolator$QueryStart$.MODULE$;
                if (token2 == null ? uriInterpolator$QueryStart$ != null : !token2.equals(uriInterpolator$QueryStart$)) {
                    UriInterpolator.Token token3 = afterEndIndex;
                    UriInterpolator$FragmentStart$ uriInterpolator$FragmentStart$ = UriInterpolator$FragmentStart$.MODULE$;
                    if (token3 == null ? uriInterpolator$FragmentStart$ != null : !token3.equals(uriInterpolator$FragmentStart$)) {
                        if (endIndex == -1) {
                            boxedUnit = tokens.prepend((Object)UriInterpolator$PathStart$.MODULE$);
                            return boxedUnit;
                        } else {
                            tokens.insert(endIndex + 1, (Object)UriInterpolator$PathStart$.MODULE$);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        });
    }

    private ArrayView<UriInterpolator.Token> filterNulls(ArrayBuffer<UriInterpolator.Token> tokens) {
        UriInterpolator.Token[] array = new UriInterpolator.Token[tokens.size()];
        IntRef i = IntRef.create((int)0);
        tokens.foreach((Function1 & Serializable)token -> {
            UriInterpolator$.$anonfun$filterNulls$1(array, i, token);
            return BoxedUnit.UNIT;
        });
        return new ArrayView<UriInterpolator.Token>(array, 0, i.elem);
    }

    private <T> Option<Tuple2<Object, T>> lastNonNull(ArrayBuffer<T> tokens, int from) {
        int idx = tokens.lastIndexWhere((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)UriInterpolator$.$anonfun$lastNonNull$1(x$26)), from);
        return idx == -1 ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)idx), tokens.apply(idx)));
    }

    private <T> Option<Tuple2<Object, T>> nextNonNull(ArrayBuffer<T> tokens, int from) {
        int idx = tokens.indexWhere((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)UriInterpolator$.$anonfun$nextNonNull$1(x$27)), from);
        return idx == -1 ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)idx), tokens.apply(idx)));
    }

    private static final void tokenizeExpressionAsString$1(ObjectRef tokenizer$1, ArrayBuffer tokens$1, Object nextExpression$1) {
        tokenizer$1.elem = ((UriInterpolator.Tokenizer)tokenizer$1.elem).tokenize((ArrayBuffer<UriInterpolator.Token>)tokens$1, nextExpression$1.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSlash$1(UriInterpolator.Token t) {
        UriInterpolator.Token token = t;
        UriInterpolator$SlashInPath$ uriInterpolator$SlashInPath$ = UriInterpolator$SlashInPath$.MODULE$;
        if (token == null) {
            if (uriInterpolator$SlashInPath$ == null) return true;
        } else if (token.equals(uriInterpolator$SlashInPath$)) return true;
        UriInterpolator.Token token2 = t;
        UriInterpolator$PathStart$ uriInterpolator$PathStart$ = UriInterpolator$PathStart$.MODULE$;
        if (token2 != null) {
            if (!token2.equals(uriInterpolator$PathStart$)) return false;
            return true;
        }
        if (uriInterpolator$PathStart$ == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$tokenize$1(Tuple2 x$5) {
        Object object = x$5._2();
        UriInterpolator$SlashInPath$ uriInterpolator$SlashInPath$ = UriInterpolator$SlashInPath$.MODULE$;
        return !(object != null ? !object.equals(uriInterpolator$SlashInPath$) : uriInterpolator$SlashInPath$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$tokenize$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$tokenize$4(Tuple2 x$6) {
        Object object = x$6._2();
        UriInterpolator.StringToken stringToken = MODULE$.sttp$model$UriInterpolator$$emptyStringToken();
        return !(object != null ? !object.equals(stringToken) : stringToken != null);
    }

    public static final /* synthetic */ boolean $anonfun$tokenize$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$tokenize$8(ArrayBuffer tokens$1, int slashInPathIdx$1, int emptyStringTokenIdx$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        tokens$1.update(slashInPathIdx$1, null);
        tokens$1.update(emptyStringTokenIdx$1, null);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$tokenize$6(ArrayBuffer tokens$1, int slashInPathIdx$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int emptyStringTokenIdx = tuple2._1$mcI$sp();
        MODULE$.lastNonNull(tokens$1, emptyStringTokenIdx - 1).filter((Function1 & Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)UriInterpolator$.isSlash$1((UriInterpolator.Token)tuple._2()))).foreach((Function1 & Serializable)x$7 -> {
            UriInterpolator$.$anonfun$tokenize$8(tokens$1, slashInPathIdx$1, emptyStringTokenIdx, x$7);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$tokenize$3(ArrayBuffer tokens$1, int initLength$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int slashInPathIdx = tuple2._1$mcI$sp();
        MODULE$.lastNonNull(tokens$1, initLength$1 - 1).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UriInterpolator$.$anonfun$tokenize$4(x$6))).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)UriInterpolator$.$anonfun$tokenize$5(check$ifrefutable$2))).foreach((Function1 & Serializable)x$8 -> {
            UriInterpolator$.$anonfun$tokenize$6(tokens$1, slashInPathIdx, x$8);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void tokenizeStringRemoveEmptyPrefix$1(ArrayBuffer tokens$1, ObjectRef tokenizer$1, String nextStr$1) {
        int initLength = tokens$1.size();
        tokenizer$1.elem = ((UriInterpolator.Tokenizer)tokenizer$1.elem).tokenize((ArrayBuffer<UriInterpolator.Token>)tokens$1, nextStr$1);
        if (initLength < tokens$1.size()) {
            Object object = tokens$1.apply(initLength);
            UriInterpolator.StringToken stringToken = this.sttp$model$UriInterpolator$$emptyStringToken();
            if (!(object != null ? !object.equals(stringToken) : stringToken != null)) {
                tokens$1.update(initLength, null);
            }
        }
        this.nextNonNull(tokens$1, initLength).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UriInterpolator$.$anonfun$tokenize$1(x$5))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)UriInterpolator$.$anonfun$tokenize$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
            UriInterpolator$.$anonfun$tokenize$3(tokens$1, initLength, x$9);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$filterNulls$1(UriInterpolator.Token[] array$1, IntRef i$1, UriInterpolator.Token token) {
        block0: {
            if (token == null) break block0;
            array$1[i$1.elem] = token;
            ++i$1.elem;
        }
    }

    public static final /* synthetic */ boolean $anonfun$lastNonNull$1(Object x$26) {
        return x$26 != null;
    }

    public static final /* synthetic */ boolean $anonfun$nextNonNull$1(Object x$27) {
        return x$27 != null;
    }

    private UriInterpolator$() {
    }
}

