/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.Uri;
import sttp.model.headers.AcceptEncoding;
import sttp.model.headers.CacheDirective;
import sttp.model.headers.ContentRange;
import sttp.model.headers.Cookie;
import sttp.model.headers.CookieWithMeta;
import sttp.model.headers.ETag;
import sttp.model.headers.ETag$;
import sttp.model.headers.Origin;
import sttp.model.headers.Range;
import sttp.model.headers.WWWAuthenticateChallenge;
import sttp.model.internal.Rfc2616$;
import sttp.model.internal.Validate$;

public final class Header$ {
    public static final Header$ MODULE$ = new Header$();
    private static ZoneId GMT;
    private static String Rfc850DatetimePattern;
    private static DateTimeFormatter Rfc850DatetimeFormat;
    private static final Set<String> Rfc850WeekDays;
    private static volatile byte bitmap$0;
    private static volatile boolean bitmap$init$0;

    static {
        Rfc850WeekDays = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"}));
        bitmap$init$0 = true;
    }

    public Option<Tuple2<String, String>> unapply(Header h) {
        return new Some((Object)new Tuple2((Object)h.name(), (Object)h.value()));
    }

    public Header unsafeApply(String name, String value) {
        return Validate$.MODULE$.RichEither(this.safeApply(name, value)).getOrThrow();
    }

    public Either<String, Header> safeApply(String name, String value) {
        return Validate$.MODULE$.all((Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Rfc2616$.MODULE$.validateToken("Header name", name)}), (Function0 & Serializable)() -> MODULE$.apply(name, value));
    }

    public Header apply(String name, String value) {
        return new Header(name, value);
    }

    public Header accept(MediaType mediaType, Seq<MediaType> additionalMediaTypes) {
        MediaType mediaType2 = mediaType;
        return this.accept(String.valueOf(additionalMediaTypes.toList().$colon$colon((Object)mediaType2).map((Function1 & Serializable)x$1 -> x$1.noCharset()).mkString(", ")));
    }

    public Header accept(String mediaRanges) {
        return this.apply(HeaderNames$.MODULE$.Accept(), mediaRanges);
    }

    public Header acceptCharset(String charsetRanges) {
        return this.apply(HeaderNames$.MODULE$.AcceptCharset(), charsetRanges);
    }

    public Header acceptEncoding(String encodingRanges) {
        return this.apply(HeaderNames$.MODULE$.AcceptEncoding(), encodingRanges);
    }

    public Header accessControlAllowCredentials(boolean allow) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowCredentials(), Boolean.toString(allow));
    }

    public Header accessControlAllowHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlAllowMethods(Seq<Method> methods) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowMethods(), ((IterableOnceOps)methods.map((Function1 & Serializable)x$2 -> ((Method)x$2).method())).mkString(", "));
    }

    public Header accessControlAllowOrigin(String originRange) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowOrigin(), originRange);
    }

    public Header accessControlExposeHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlExposeHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlMaxAge(long deltaSeconds) {
        return this.apply(HeaderNames$.MODULE$.AccessControlMaxAge(), Long.toString(deltaSeconds));
    }

    public Header accessControlRequestHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlRequestHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlRequestMethod(String method) {
        return this.apply(HeaderNames$.MODULE$.AccessControlRequestMethod(), Method$.MODULE$.toString$extension(method));
    }

    public Header authorization(String authType, String credentials) {
        return this.apply(HeaderNames$.MODULE$.Authorization(), new StringBuilder(1).append(authType).append(" ").append(credentials).toString());
    }

    public Header acceptEncoding(AcceptEncoding acceptEncoding) {
        return this.apply(HeaderNames$.MODULE$.AcceptEncoding(), acceptEncoding.toString());
    }

    public Header cacheControl(CacheDirective first, Seq<CacheDirective> other) {
        CacheDirective cacheDirective = first;
        return this.cacheControl((Iterable<CacheDirective>)((Iterable)other.$plus$colon((Object)cacheDirective)));
    }

    public Header cacheControl(Iterable<CacheDirective> directives) {
        return this.apply(HeaderNames$.MODULE$.CacheControl(), ((IterableOnceOps)directives.map((Function1 & Serializable)x$3 -> x$3.toString())).mkString(", "));
    }

    public Header contentLength(long length) {
        return this.apply(HeaderNames$.MODULE$.ContentLength(), Long.toString(length));
    }

    public Header contentEncoding(String encoding) {
        return this.apply(HeaderNames$.MODULE$.ContentEncoding(), encoding);
    }

    public Header contentType(MediaType mediaType) {
        return this.apply(HeaderNames$.MODULE$.ContentType(), mediaType.toString());
    }

    public Header contentRange(ContentRange contentRange) {
        return this.apply(HeaderNames$.MODULE$.ContentRange(), contentRange.toString());
    }

    public Header cookie(Cookie firstCookie, Seq<Cookie> otherCookies) {
        Cookie cookie = firstCookie;
        return this.apply(HeaderNames$.MODULE$.Cookie(), ((IterableOnceOps)((IterableOps)otherCookies.$plus$colon((Object)cookie)).map((Function1 & Serializable)x$4 -> x$4.toString())).mkString("; "));
    }

    public Header etag(String tag) {
        return this.etag(new ETag(tag, ETag$.MODULE$.apply$default$2()));
    }

    public Header etag(ETag tag) {
        return this.apply(HeaderNames$.MODULE$.Etag(), tag.toString());
    }

    public Header expires(Instant i) {
        return this.apply(HeaderNames$.MODULE$.Expires(), this.toHttpDateString(i));
    }

    public Header ifNoneMatch(List<ETag> tags) {
        return this.apply(HeaderNames$.MODULE$.IfNoneMatch(), ETag$.MODULE$.toString(tags));
    }

    public Header ifModifiedSince(Instant i) {
        return this.apply(HeaderNames$.MODULE$.IfModifiedSince(), this.toHttpDateString(i));
    }

    public Header ifUnmodifiedSince(Instant i) {
        return this.apply(HeaderNames$.MODULE$.IfUnmodifiedSince(), this.toHttpDateString(i));
    }

    public Header lastModified(Instant i) {
        return this.apply(HeaderNames$.MODULE$.LastModified(), this.toHttpDateString(i));
    }

    public Header location(String uri) {
        return this.apply(HeaderNames$.MODULE$.Location(), uri);
    }

    public Header location(Uri uri) {
        return this.apply(HeaderNames$.MODULE$.Location(), uri.toString());
    }

    public Header origin(Origin origin) {
        return this.apply(HeaderNames$.MODULE$.Origin(), origin.toString());
    }

    public Header proxyAuthorization(String authType, String credentials) {
        return this.apply(HeaderNames$.MODULE$.ProxyAuthorization(), new StringBuilder(1).append(authType).append(" ").append(credentials).toString());
    }

    public Header range(Range range) {
        return this.apply(HeaderNames$.MODULE$.Range(), range.toString());
    }

    public Header setCookie(CookieWithMeta cookie) {
        return this.apply(HeaderNames$.MODULE$.SetCookie(), cookie.toString());
    }

    public Header userAgent(String userAgent) {
        return this.apply(HeaderNames$.MODULE$.UserAgent(), userAgent);
    }

    public Header wwwAuthenticate(WWWAuthenticateChallenge challenge) {
        return this.apply(HeaderNames$.MODULE$.WwwAuthenticate(), challenge.toString());
    }

    public List<Header> wwwAuthenticate(WWWAuthenticateChallenge firstChallenge, Seq<WWWAuthenticateChallenge> otherChallenges) {
        WWWAuthenticateChallenge wWWAuthenticateChallenge = firstChallenge;
        return otherChallenges.toList().$colon$colon((Object)wWWAuthenticateChallenge).map((Function1 & Serializable)c -> MODULE$.apply(HeaderNames$.MODULE$.WwwAuthenticate(), c.toString()));
    }

    public Header vary(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.Vary(), headerNames.mkString(", "));
    }

    public Header xForwardedFor(String firstAddress, Seq<String> otherAddresses) {
        String string = firstAddress;
        return this.apply(HeaderNames$.MODULE$.XForwardedFor(), ((IterableOnceOps)otherAddresses.$plus$colon((Object)string)).mkString(", "));
    }

    private ZoneId GMT$lzycompute() {
        Header$ header$ = this;
        synchronized (header$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                GMT = ZoneId.of("GMT");
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return GMT;
    }

    private ZoneId GMT() {
        return (byte)(bitmap$0 & 1) == 0 ? this.GMT$lzycompute() : GMT;
    }

    private String Rfc850DatetimePattern$lzycompute() {
        Header$ header$ = this;
        synchronized (header$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                Rfc850DatetimePattern = "dd-MMM-yyyy HH:mm:ss zzz";
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return Rfc850DatetimePattern;
    }

    private String Rfc850DatetimePattern() {
        return (byte)(bitmap$0 & 2) == 0 ? this.Rfc850DatetimePattern$lzycompute() : Rfc850DatetimePattern;
    }

    private DateTimeFormatter Rfc850DatetimeFormat$lzycompute() {
        Header$ header$ = this;
        synchronized (header$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                Rfc850DatetimeFormat = DateTimeFormatter.ofPattern(this.Rfc850DatetimePattern(), Locale.US);
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return Rfc850DatetimeFormat;
    }

    private DateTimeFormatter Rfc850DatetimeFormat() {
        return (byte)(bitmap$0 & 4) == 0 ? this.Rfc850DatetimeFormat$lzycompute() : Rfc850DatetimeFormat;
    }

    public Set<String> Rfc850WeekDays() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/sttp-model/sttp-model/core/src/main/scala/sttp/model/Header.scala: 146");
        }
        return Rfc850WeekDays;
    }

    private Instant parseRfc850DateTime(String v) {
        String[] expiresParts = v.split(", ");
        if (expiresParts.length != 2) {
            throw new Exception("There must be exactly one \", \"");
        }
        if (!this.Rfc850WeekDays().contains((Object)expiresParts[0].trim().toLowerCase(Locale.ENGLISH))) {
            throw new Exception("String must start with weekday name");
        }
        return Instant.from(this.Rfc850DatetimeFormat().parse(expiresParts[1]));
    }

    public Either<String, Instant> parseHttpDate(String v) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(v)));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Instant r = (Instant)success.value();
            right = package$.MODULE$.Right().apply((Object)r);
        } else if (try_ instanceof Failure) {
            Right right2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.parseRfc850DateTime(v));
            if (try_2 instanceof Success) {
                Success success = (Success)try_2;
                Instant r = (Instant)success.value();
                right2 = package$.MODULE$.Right().apply((Object)r);
            } else if (try_2 instanceof Failure) {
                right2 = package$.MODULE$.Left().apply((Object)new StringBuilder(22).append("Invalid http date: ").append(v).append(" (").append(e.getMessage()).append(")").toString());
            } else {
                throw new MatchError((Object)try_2);
            }
            right = right2;
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public Instant unsafeParseHttpDate(String s) {
        return Validate$.MODULE$.RichEither(this.parseHttpDate(s)).getOrThrow();
    }

    public String toHttpDateString(Instant i) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(i.atZone(this.GMT()));
    }

    private Header$() {
    }
}

