/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.kafka;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.conduktor.kafka.models.KafkaNodeVersion;
import io.conduktor.kafka.models.NodeVersion;
import io.conduktor.kafka.models.RedpandaNodeVersion;
import io.conduktor.kafka.models.UnknownNodeVersion;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.Charsets;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001c\u001a\u00020\fH\u0002J \u0010\u001d\u001a\u0004\u0018\u00010\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010!\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%J&\u0010&\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\fH\u0002J&\u0010)\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\fH\u0002R;\u0010\u0003\u001a/\u0012+\u0012)\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u0004\u0012\u00020\f0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/conduktor/kafka/ApiVersionFinder;", "", "()V", "jsons", "", "Lkotlin/Pair;", "Lkotlin/reflect/KFunction1;", "", "Lkotlin/ParameterName;", "name", "version", "Lio/conduktor/kafka/models/NodeVersion;", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "kafkaApiVersions", "kafkaJson", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "redpandaApiVersions", "redpandaJson", "areAllApisEqual", "", "apis", "metadata", "", "Lorg/apache/kafka/common/message/ApiVersionsResponseData$ApiVersion;", "areAllApisEqualOrGreater", "findAllApisEqual", "json", "findAllApisEqualOrGreater", "findVersion", "response", "Lorg/apache/kafka/common/requests/ApiVersionsResponse;", "hasApis", "", "Lio/conduktor/kafka/ApiVersionFinder$HasApiRequest;", "apiKeys", "Lorg/apache/kafka/common/message/ApiVersionsResponseData$ApiVersionCollection;", "isEqualApi", "key", "minMax", "isEqualOrGreaterApi", "HasApiRequest", "kafka"})
public final class ApiVersionFinder {
    @NotNull
    public static final ApiVersionFinder INSTANCE = new ApiVersionFinder();
    private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
    @NotNull
    private static final String kafkaApiVersions;
    @NotNull
    private static final ObjectNode kafkaJson;
    @NotNull
    private static final String redpandaApiVersions;
    @NotNull
    private static final ObjectNode redpandaJson;
    @NotNull
    private static final List<Pair<KFunction<NodeVersion>, ObjectNode>> jsons;

    private ApiVersionFinder() {
    }

    public final boolean hasApis(@NotNull Set<HasApiRequest> apis, @NotNull ApiVersionsResponseData.ApiVersionCollection apiKeys) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = apis;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    HasApiRequest it = (HasApiRequest)element$iv;
                    boolean bl2 = false;
                    ApiVersionsResponseData.ApiVersion found = apiKeys.find(it.getApiKey().id);
                    if (found != null && found.minVersion() >= it.getMinGreaterOrEqualThan() && found.maxVersion() >= it.getMaxGreaterOrEqualThan()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NodeVersion findVersion(@NotNull ApiVersionsResponse response) {
        void $this$mapNotNullTo$iv$iv;
        ApiKeys[] $this$mapNotNull$iv = ApiKeys.values();
        boolean $i$f$mapNotNull = false;
        ApiKeys[] apiKeysArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            ApiVersionsResponseData.ApiVersion it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (response.apiVersion(it.id) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List metadata = (List)destination$iv$iv;
        Iterable $this$forEach$iv = jsons;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            KFunction builder = (KFunction)pair.component1();
            ObjectNode json = (ObjectNode)pair.component2();
            String version = INSTANCE.findAllApisEqual(metadata, json);
            if (version == null) {
                version = INSTANCE.findAllApisEqualOrGreater(metadata, json);
            }
            if (version == null) continue;
            return (NodeVersion)((Function1)builder).invoke((Object)version);
        }
        return UnknownNodeVersion.INSTANCE;
    }

    private final String findAllApisEqualOrGreater(List<? extends ApiVersionsResponseData.ApiVersion> metadata, ObjectNode json) {
        String version = null;
        Iterator iterator = json.fields();
        while (iterator.hasNext()) {
            JsonNode apis;
            Map.Entry entry = (Map.Entry)iterator.next();
            String v = (String)entry.getKey();
            JsonNode jsonNode = apis = (JsonNode)entry.getValue();
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            if (!this.areAllApisEqualOrGreater((ObjectNode)jsonNode, (Collection<? extends ApiVersionsResponseData.ApiVersion>)metadata)) continue;
            version = "+" + v;
        }
        return version;
    }

    private final boolean areAllApisEqualOrGreater(ObjectNode apis, Collection<? extends ApiVersionsResponseData.ApiVersion> metadata) {
        Iterator iterator = apis.fields();
        while (iterator.hasNext()) {
            JsonNode minMax;
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            JsonNode jsonNode = minMax = (JsonNode)entry.getValue();
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            if (this.isEqualOrGreaterApi(metadata, key, (ObjectNode)jsonNode)) continue;
            return false;
        }
        return true;
    }

    private final String findAllApisEqual(List<? extends ApiVersionsResponseData.ApiVersion> metadata, ObjectNode json) {
        String version = null;
        Iterator iterator = json.fields();
        while (iterator.hasNext()) {
            JsonNode apis;
            Map.Entry entry = (Map.Entry)iterator.next();
            String v = (String)entry.getKey();
            JsonNode jsonNode = apis = (JsonNode)entry.getValue();
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            if (!this.areAllApisEqual((ObjectNode)jsonNode, (Collection<? extends ApiVersionsResponseData.ApiVersion>)metadata)) continue;
            version = v;
        }
        return version;
    }

    private final boolean areAllApisEqual(ObjectNode apis, Collection<? extends ApiVersionsResponseData.ApiVersion> metadata) {
        Iterator iterator = apis.fields();
        while (iterator.hasNext()) {
            JsonNode minMax;
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            JsonNode jsonNode = minMax = (JsonNode)entry.getValue();
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            if (this.isEqualApi(metadata, key, (ObjectNode)jsonNode)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEqualApi(Collection<? extends ApiVersionsResponseData.ApiVersion> metadata, String key, ObjectNode minMax) {
        Object object;
        void $this$getOrHandle$iv;
        Either either;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            boolean bl;
            block9: {
                boolean bl2 = false;
                Iterable $this$any$iv = metadata;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ApiVersionsResponseData.ApiVersion it = (ApiVersionsResponseData.ApiVersion)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = it.apiKey() == ApiKeys.valueOf((String)key).id && it.maxVersion() == minMax.get("max").shortValue() && it.minVersion() == minMax.get("min").shortValue();
                        if (!bl4) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            either = EitherKt.right((Object)bl);
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        this_$iv = either;
        boolean $i$f$getOrHandle = false;
        void this_$iv$iv = $this$getOrHandle$iv;
        boolean $i$f$fold = false;
        void var8_11 = this_$iv$iv;
        if (var8_11 instanceof Either.Right) {
            Object p1$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            boolean $i$f$identity = false;
            object = p1$iv;
        } else if (var8_11 instanceof Either.Left) {
            Object it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            Throwable it = (Throwable)it$iv;
            boolean bl5 = false;
            logger.warn("Error looking for Api: " + it.getMessage());
            object = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEqualOrGreaterApi(Collection<? extends ApiVersionsResponseData.ApiVersion> metadata, String key, ObjectNode minMax) {
        Object object;
        void $this$getOrHandle$iv;
        Either either;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            boolean bl;
            block9: {
                boolean bl2 = false;
                Iterable $this$any$iv = metadata;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ApiVersionsResponseData.ApiVersion it = (ApiVersionsResponseData.ApiVersion)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = it.apiKey() == ApiKeys.valueOf((String)key).id && it.maxVersion() >= minMax.get("max").shortValue() && it.minVersion() >= minMax.get("min").shortValue();
                        if (!bl4) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            either = EitherKt.right((Object)bl);
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        this_$iv = either;
        boolean $i$f$getOrHandle = false;
        void this_$iv$iv = $this$getOrHandle$iv;
        boolean $i$f$fold = false;
        void var8_11 = this_$iv$iv;
        if (var8_11 instanceof Either.Right) {
            Object p1$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            boolean $i$f$identity = false;
            object = p1$iv;
        } else if (var8_11 instanceof Either.Left) {
            Object it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            Throwable it = (Throwable)it$iv;
            boolean bl5 = false;
            logger.warn("Error looking for Api: " + it.getMessage());
            object = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (Boolean)object;
    }

    static {
        Object[] objectArray = ApiVersionFinder.class.getResource("/api_versions.json");
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] objectArray2 = objectArray;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)objectArray2);
        kafkaApiVersions = new String(byArray, charset);
        JsonNode jsonNode = new ObjectMapper().readTree(kafkaApiVersions);
        if (jsonNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        kafkaJson = (ObjectNode)jsonNode;
        URL uRL = ApiVersionFinder.class.getResource("/redpanda_api_versions.json");
        Intrinsics.checkNotNull((Object)uRL);
        objectArray2 = uRL;
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)objectArray2);
        redpandaApiVersions = new String(byArray, charset);
        JsonNode jsonNode2 = new ObjectMapper().readTree(redpandaApiVersions);
        if (jsonNode2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        redpandaJson = (ObjectNode)jsonNode2;
        objectArray2 = new Pair[]{TuplesKt.to((Object)new Function1<String, NodeVersion>((Object)KafkaNodeVersion.Companion){

            @NotNull
            public final NodeVersion invoke(@NotNull String p0) {
                return ((KafkaNodeVersion.Companion)this.receiver).of(p0);
            }
        }, (Object)kafkaJson), TuplesKt.to((Object)new Function1<String, NodeVersion>((Object)RedpandaNodeVersion.Companion){

            @NotNull
            public final NodeVersion invoke(@NotNull String p0) {
                return ((RedpandaNodeVersion.Companion)this.receiver).of(p0);
            }
        }, (Object)redpandaJson)};
        jsons = CollectionsKt.listOf((Object[])objectArray2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/conduktor/kafka/ApiVersionFinder$HasApiRequest;", "", "apiKey", "Lorg/apache/kafka/common/protocol/ApiKeys;", "minGreaterOrEqualThan", "", "maxGreaterOrEqualThan", "(Lorg/apache/kafka/common/protocol/ApiKeys;SS)V", "getApiKey", "()Lorg/apache/kafka/common/protocol/ApiKeys;", "getMaxGreaterOrEqualThan", "()S", "getMinGreaterOrEqualThan", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kafka"})
    public static final class HasApiRequest {
        @NotNull
        private final ApiKeys apiKey;
        private final short minGreaterOrEqualThan;
        private final short maxGreaterOrEqualThan;

        public HasApiRequest(@NotNull ApiKeys apiKey, short minGreaterOrEqualThan, short maxGreaterOrEqualThan) {
            this.apiKey = apiKey;
            this.minGreaterOrEqualThan = minGreaterOrEqualThan;
            this.maxGreaterOrEqualThan = maxGreaterOrEqualThan;
        }

        public /* synthetic */ HasApiRequest(ApiKeys apiKeys, short s, short s2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                s = 0;
            }
            if ((n & 4) != 0) {
                s2 = 0;
            }
            this(apiKeys, s, s2);
        }

        @NotNull
        public final ApiKeys getApiKey() {
            return this.apiKey;
        }

        public final short getMinGreaterOrEqualThan() {
            return this.minGreaterOrEqualThan;
        }

        public final short getMaxGreaterOrEqualThan() {
            return this.maxGreaterOrEqualThan;
        }

        @NotNull
        public final ApiKeys component1() {
            return this.apiKey;
        }

        public final short component2() {
            return this.minGreaterOrEqualThan;
        }

        public final short component3() {
            return this.maxGreaterOrEqualThan;
        }

        @NotNull
        public final HasApiRequest copy(@NotNull ApiKeys apiKey, short minGreaterOrEqualThan, short maxGreaterOrEqualThan) {
            return new HasApiRequest(apiKey, minGreaterOrEqualThan, maxGreaterOrEqualThan);
        }

        public static /* synthetic */ HasApiRequest copy$default(HasApiRequest hasApiRequest, ApiKeys apiKeys, short s, short s2, int n, Object object) {
            if ((n & 1) != 0) {
                apiKeys = hasApiRequest.apiKey;
            }
            if ((n & 2) != 0) {
                s = hasApiRequest.minGreaterOrEqualThan;
            }
            if ((n & 4) != 0) {
                s2 = hasApiRequest.maxGreaterOrEqualThan;
            }
            return hasApiRequest.copy(apiKeys, s, s2);
        }

        @NotNull
        public String toString() {
            return "HasApiRequest(apiKey=" + this.apiKey + ", minGreaterOrEqualThan=" + this.minGreaterOrEqualThan + ", maxGreaterOrEqualThan=" + this.maxGreaterOrEqualThan + ")";
        }

        public int hashCode() {
            int result = this.apiKey.hashCode();
            result = result * 31 + Short.hashCode(this.minGreaterOrEqualThan);
            result = result * 31 + Short.hashCode(this.maxGreaterOrEqualThan);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HasApiRequest)) {
                return false;
            }
            HasApiRequest hasApiRequest = (HasApiRequest)other;
            if (this.apiKey != hasApiRequest.apiKey) {
                return false;
            }
            if (this.minGreaterOrEqualThan != hasApiRequest.minGreaterOrEqualThan) {
                return false;
            }
            return this.maxGreaterOrEqualThan == hasApiRequest.maxGreaterOrEqualThan;
        }
    }
}

