/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.avro;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.conduktor.avro.AvroConversionException;
import io.conduktor.avro.JsonRecordAvroConverter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J<\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000e0\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0014J>\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000e0\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002J#\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0018J&\u0010\u0019\u001a\u00020\b\"\u0004\b\u0000\u0010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/conduktor/avro/JsonToAvroSchemaConverter;", "", "()V", "jsonConverter", "Lio/conduktor/avro/JsonRecordAvroConverter;", "om", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "b64ToBytes", "", "json", "", "schemaId", "", "convert", "Larrow/core/Either;", "", "Lorg/apache/avro/generic/GenericRecord;", "jsonData", "schema", "Lorg/apache/avro/Schema;", "Lkotlin/Lazy;", "convertRecord", "genericJsonToAvro", "A", "(Ljava/lang/String;Lorg/apache/avro/Schema;)Ljava/lang/Object;", "genericJsonToBytes", "kafka"})
public final class JsonToAvroSchemaConverter {
    @NotNull
    public static final JsonToAvroSchemaConverter INSTANCE = new JsonToAvroSchemaConverter();
    @NotNull
    private static final ObjectMapper om = new ObjectMapper();
    @NotNull
    private static final JsonRecordAvroConverter jsonConverter = new JsonRecordAvroConverter();

    private JsonToAvroSchemaConverter() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Either<Throwable, Either<byte[], GenericRecord>> convertRecord(String jsonData, Schema schema, Lazy<Integer> schemaId) {
        Either either;
        void $this$flatMap$iv;
        Either either2;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            boolean bl = false;
            either2 = EitherKt.right((Object)om.readTree(jsonData));
        }
        catch (Throwable t$iv) {
            either2 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        this_$iv = either2;
        boolean $i$f$flatMap = false;
        void var6_8 = $this$flatMap$iv;
        if (var6_8 instanceof Either.Right) {
            Either.Right right;
            JsonNode it = (JsonNode)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            if (schema.isUnion()) {
                right = new Either.Right((Object)new Either.Left((Object)INSTANCE.genericJsonToBytes(jsonData, schema, ((Number)schemaId.getValue()).intValue())));
            } else {
                Either either3;
                Either.Companion this_$iv2 = Either.Companion;
                boolean $i$f$tryCatch2 = false;
                try {
                    boolean bl2 = false;
                    byte[] byArray = jsonData.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    either3 = EitherKt.right((Object)jsonConverter.convertToGenericDataRecord(byArray, schema));
                }
                catch (Throwable t$iv) {
                    either3 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
                }
                Either result = either3;
                if (result instanceof Either.Left) {
                    Either.Companion this_$iv3 = Either.Companion;
                    boolean $i$f$tryCatch3 = false;
                    try {
                        boolean bl3 = false;
                        either3 = EitherKt.right((Object)((GenericRecord)INSTANCE.genericJsonToAvro(jsonData, schema)));
                    }
                    catch (Throwable t$iv) {
                        either3 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
                    }
                    Either genericResult = either3;
                    if (genericResult instanceof Either.Left) {
                        throw (Throwable)((Either.Left)result).getValue();
                    }
                    if (!(genericResult instanceof Either.Right)) throw new NoWhenBranchMatchedException();
                    right = new Either.Right((Object)new Either.Right(((Either.Right)genericResult).getValue()));
                } else {
                    if (!(result instanceof Either.Right)) throw new NoWhenBranchMatchedException();
                    right = new Either.Right((Object)result);
                }
            }
            either = (Either)right;
            return either;
        }
        if (!(var6_8 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
        either = $this$flatMap$iv;
        return either;
    }

    @NotNull
    public final Either<Throwable, Either<byte[], GenericRecord>> convert(@NotNull String jsonData, @NotNull Schema schema, @NotNull Lazy<Integer> schemaId) {
        Either either;
        Schema.Type type = schema.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                either = this.convertRecord(jsonData, schema, schemaId);
                break;
            }
            case 3: {
                either = (Either)new Either.Right((Object)new Either.Left((Object)this.b64ToBytes(jsonData, ((Number)schemaId.getValue()).intValue())));
                break;
            }
            case 4: {
                either = (Either)new Either.Left((Object)new AvroConversionException("JSON arrays at root are not supported"));
                break;
            }
            default: {
                either = (Either)new Either.Right((Object)new Either.Left((Object)this.genericJsonToBytes(jsonData, schema, ((Number)schemaId.getValue()).intValue())));
            }
        }
        return either;
    }

    private final <A> A genericJsonToAvro(String json, Schema schema) {
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, json);
        DatumReader reader = (DatumReader)new GenericDatumReader(schema);
        return (A)reader.read(null, (Decoder)decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <A> byte[] genericJsonToBytes(String json, Schema schema, int schemaId) {
        byte[] byArray;
        A avro = this.genericJsonToAvro(json, schema);
        GenericDatumWriter w = new GenericDatumWriter(schema);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            baos.write(0);
            baos.write(ByteBuffer.allocate(4).putInt(schemaId).array());
            BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
            w.write(avro, (Encoder)e);
            e.flush();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] b64ToBytes(String json, int schemaId) {
        byte[] byArray;
        String b64 = om.readTree(json).asText();
        byte[] decoded = Base64.getDecoder().decode(b64);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            baos.write(0);
            baos.write(ByteBuffer.allocate(4).putInt(schemaId).array());
            baos.write(decoded);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            nArray[Schema.Type.RECORD.ordinal()] = 1;
            nArray[Schema.Type.UNION.ordinal()] = 2;
            nArray[Schema.Type.BYTES.ordinal()] = 3;
            nArray[Schema.Type.ARRAY.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

