/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.conduktor.avro.AvroConversionException;
import io.conduktor.avro.AvroHelper;
import io.conduktor.avro.AvroTypeExceptions;
import io.conduktor.avro.JsonGenericRecordReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecordBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0002J@\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\b\u0002\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0018J:\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010!2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J>\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0002JD\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010-2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u00100\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J2\u00101\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\b\u00102\u001a\u0004\u0018\u00010!2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0002J&\u00103\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00102\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/conduktor/avro/JsonGenericRecordReader;", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "bytesForString", "Ljava/nio/ByteBuffer;", "string", "", "bytesForStringBase64", "convertToDate", "", "text", "convertToTimeMicros", "", "convertToTimeMillis", "convertToTimestampMicros", "convertToTimestampMillis", "failAvroType", "isTestingUnion", "", "path", "", "schema", "Lorg/apache/avro/Schema;", "type", "Lorg/apache/avro/Schema$Type;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "read", "Lorg/apache/avro/generic/GenericData$Record;", "json", "Lcom/fasterxml/jackson/databind/JsonNode;", "data", "", "field", "Lorg/apache/avro/Schema$Field;", "jsonValue", "readArray", "items", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "readFixed", "Lorg/apache/avro/generic/GenericFixed;", "readMap", "", "obj", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "readRecord", "readUnion", "value", "stringToEnumSymbol", "Lorg/apache/avro/generic/GenericData$EnumSymbol;", "Companion", "kafka"})
public final class JsonGenericRecordReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private static final Object INCOMPATIBLE = new Object();
    private static final DateTimeFormatter humanDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.ENGLISH).withZone(ZoneId.systemDefault());

    public JsonGenericRecordReader(@NotNull ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public /* synthetic */ JsonGenericRecordReader(ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            objectMapper = new ObjectMapper();
        }
        this(objectMapper);
    }

    @NotNull
    public final GenericData.Record read(@NotNull byte[] data, @NotNull Schema schema) {
        GenericData.Record record;
        try {
            JsonNode obj = this.mapper.readTree(data);
            record = this.read(obj, schema);
        }
        catch (IOException ex) {
            throw new AvroConversionException("Failed to parse json to map format.", ex);
        }
        return record;
    }

    private final GenericData.Record read(JsonNode json, Schema schema) {
        GenericData.Record record;
        if (!json.isObject()) {
            throw new AvroConversionException("JSON arrays at root are not supported");
        }
        try {
            record = this.readRecord((ObjectNode)json, schema, CollectionsKt.emptyList(), false);
        }
        catch (AvroRuntimeException ex) {
            throw new AvroConversionException("Failed to convert JSON to Avro", ex);
        }
        return record;
    }

    private final GenericData.Record readRecord(ObjectNode json, Schema schema, List<String> path, boolean isTestingUnion) {
        GenericRecordBuilder record = new GenericRecordBuilder(schema);
        Iterator $this$forEach$iv = json.fields();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Schema.Field field = schema.getField((String)it.getKey());
            if (field == null) continue;
            record.set(field, this.read(field, field.schema(), (JsonNode)it.getValue(), path, isTestingUnion));
        }
        return record.build();
    }

    private final Object read(Schema.Field field, Schema schema, JsonNode jsonValue, List<String> path, boolean isTestingUnion) {
        Object object;
        List childPath = CollectionsKt.plus((Collection)path, (Object)field.name());
        Schema.Type type = schema.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                object = this.readUnion(field, schema, jsonValue, childPath);
                break;
            }
            case 2: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isObject() : false;
                if (bl) {
                    JsonNode jsonNode2 = jsonValue;
                    if (jsonNode2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                    }
                    object = this.readRecord((ObjectNode)jsonNode2, schema, childPath, false);
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 3: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isArray() : false;
                if (bl) {
                    JsonNode jsonNode3 = jsonValue;
                    if (jsonNode3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
                    }
                    object = this.readArray(field, schema, (ArrayNode)jsonNode3, childPath, false);
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 4: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isObject() : false;
                if (bl) {
                    JsonNode jsonNode4 = jsonValue;
                    if (jsonNode4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                    }
                    object = this.readMap(field, schema, (ObjectNode)jsonNode4, childPath, false);
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 5: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isTextual() : false;
                if (bl) {
                    object = this.stringToEnumSymbol(schema, jsonValue.textValue(), childPath);
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 6: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isTextual() : false;
                if (bl) {
                    object = jsonValue.textValue();
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 7: {
                LogicalType lt = schema.getLogicalType();
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isTextual() : false;
                if (bl) {
                    Object dec2;
                    String str = jsonValue.textValue();
                    if (lt instanceof LogicalTypes.Decimal) {
                        Object dec2;
                        try {
                            dec2 = new BigDecimal(str).setScale(((LogicalTypes.Decimal)lt).getScale(), RoundingMode.HALF_EVEN);
                            dec2 = AvroHelper.INSTANCE.getDecimalConversion().toBytes((BigDecimal)dec2, schema, lt);
                        }
                        catch (Exception e) {
                            dec2 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, e);
                        }
                        object = dec2;
                        break;
                    }
                    try {
                        dec2 = this.bytesForStringBase64(str);
                    }
                    catch (Exception e) {
                        dec2 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, new Exception("Please encode bytes with a base64 encoding in your string"));
                    }
                    object = dec2;
                    break;
                }
                JsonNode jsonNode5 = jsonValue;
                boolean bl2 = jsonNode5 != null ? jsonNode5.isNumber() : false;
                if (bl2 && lt instanceof LogicalTypes.Decimal) {
                    Object object2;
                    double n = jsonValue.doubleValue();
                    try {
                        BigDecimal dec = new BigDecimal(n).setScale(((LogicalTypes.Decimal)lt).getScale(), RoundingMode.HALF_EVEN);
                        object2 = AvroHelper.INSTANCE.getDecimalConversion().toBytes(dec, schema, lt);
                    }
                    catch (Exception e) {
                        object2 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, e);
                    }
                    object = object2;
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 8: {
                LogicalType lt = schema.getLogicalType();
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.canConvertToInt() : false;
                if (bl) {
                    object = jsonValue.intValue();
                    break;
                }
                JsonNode jsonNode6 = jsonValue;
                boolean bl3 = jsonNode6 != null ? jsonNode6.isTextual() : false;
                if (bl3 && lt instanceof LogicalTypes.Date) {
                    Object object3;
                    try {
                        object3 = this.convertToDate(jsonValue.textValue());
                    }
                    catch (Exception e) {
                        object3 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, e);
                    }
                    object = object3;
                    break;
                }
                JsonNode jsonNode7 = jsonValue;
                boolean bl4 = jsonNode7 != null ? jsonNode7.isTextual() : false;
                if (bl4 && lt instanceof LogicalTypes.TimeMillis) {
                    Object object4;
                    try {
                        object4 = this.convertToTimeMillis(jsonValue.textValue());
                    }
                    catch (Exception e) {
                        object4 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, e);
                    }
                    object = object4;
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 9: {
                LogicalType lt = schema.getLogicalType();
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.canConvertToLong() : false;
                if (bl) {
                    object = jsonValue.longValue();
                    break;
                }
                JsonNode jsonNode8 = jsonValue;
                boolean bl5 = jsonNode8 != null ? jsonNode8.isTextual() : false;
                if (bl5 && lt instanceof LogicalTypes.TimestampMillis) {
                    Object object5;
                    try {
                        object5 = this.convertToTimestampMillis(jsonValue.textValue());
                    }
                    catch (Exception e) {
                        object5 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, e);
                    }
                    object = object5;
                    break;
                }
                JsonNode jsonNode9 = jsonValue;
                boolean bl6 = jsonNode9 != null ? jsonNode9.isTextual() : false;
                if (bl6 && lt instanceof LogicalTypes.TimestampMicros) {
                    Object object6;
                    try {
                        object6 = this.convertToTimestampMicros(jsonValue.textValue());
                    }
                    catch (Exception e) {
                        object6 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, e);
                    }
                    object = object6;
                    break;
                }
                JsonNode jsonNode10 = jsonValue;
                boolean bl7 = jsonNode10 != null ? jsonNode10.isTextual() : false;
                if (bl7 && lt instanceof LogicalTypes.TimeMicros) {
                    Object object7;
                    try {
                        object7 = this.convertToTimeMicros(jsonValue.textValue());
                    }
                    catch (Exception e) {
                        object7 = JsonGenericRecordReader.read$wrongTypeError(this, isTestingUnion, childPath, schema, e);
                    }
                    object = object7;
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 10: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isNumber() : false;
                if (bl) {
                    object = Float.valueOf(jsonValue.floatValue());
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 11: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isNumber() : false;
                if (bl) {
                    object = jsonValue.doubleValue();
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 12: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isBoolean() : false;
                if (bl) {
                    object = jsonValue.booleanValue();
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            case 13: {
                if (jsonValue == null || jsonValue.isNull()) {
                    object = null;
                    break;
                }
                object = INCOMPATIBLE;
                break;
            }
            case 14: {
                JsonNode jsonNode = jsonValue;
                boolean bl = jsonNode != null ? jsonNode.isArray() : false;
                if (bl) {
                    JsonNode jsonNode11 = jsonValue;
                    if (jsonNode11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
                    }
                    object = this.readFixed(schema, (ArrayNode)jsonNode11);
                    break;
                }
                object = JsonGenericRecordReader.read$wrongTypeError$default(this, isTestingUnion, childPath, schema, null, 16, null);
                break;
            }
            default: {
                throw new AvroTypeException("Unsupported type: " + field.schema().getType());
            }
        }
        return object;
    }

    private final long convertToTimestampMillis(String text) {
        long l;
        try {
            l = AvroHelper.INSTANCE.getTimestampConversion().toLong(Instant.parse(text), null, null);
        }
        catch (Exception e) {
            l = AvroHelper.INSTANCE.getTimestampConversion().toLong(ZonedDateTime.parse(text, humanDateTimeFormatter).toInstant(), null, null);
        }
        return l;
    }

    private final long convertToTimestampMicros(String text) {
        long l;
        try {
            l = AvroHelper.INSTANCE.getTimestampMicrosConversion().toLong(Instant.parse(text), null, null);
        }
        catch (Exception e) {
            l = AvroHelper.INSTANCE.getTimestampMicrosConversion().toLong(ZonedDateTime.parse(text, humanDateTimeFormatter).toInstant(), null, null);
        }
        return l;
    }

    private final long convertToTimeMicros(String text) {
        return AvroHelper.INSTANCE.getTimeMicrosConversion().toLong(LocalTime.parse(text), null, null);
    }

    private final int convertToTimeMillis(String text) {
        return AvroHelper.INSTANCE.getTimeConversion().toInt(LocalTime.parse(text), null, null);
    }

    private final int convertToDate(String text) {
        return AvroHelper.INSTANCE.getDateConversion().toInt(LocalDate.parse(text), null, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> readArray(Schema.Field field, Schema schema, ArrayNode items, List<String> path, boolean isTestingUnion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.read(field, schema.getElementType(), (JsonNode)item, path, isTestingUnion));
        }
        return (List)destination$iv$iv;
    }

    private final GenericFixed readFixed(Schema schema, ArrayNode items) {
        return new GenericFixed(schema, items){
            final /* synthetic */ Schema $schema;
            final /* synthetic */ ArrayNode $items;
            {
                this.$schema = $schema;
                this.$items = $items;
            }

            @NotNull
            public Schema getSchema() {
                return this.$schema;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public byte[] bytes() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)this.$items;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void item;
                    JsonNode jsonNode = (JsonNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((byte)item.intValue());
                }
                return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> readMap(Schema.Field field, Schema schema, ObjectNode obj, List<String> path, boolean isTestingUnion) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable iterable = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)obj.fields()));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var9_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String fieldName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            Pair pair = TuplesKt.to((Object)fieldName, (Object)this.read(field, schema.getValueType(), value, path, isTestingUnion));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final Object readUnion(Schema.Field field, Schema schema, JsonNode value, List<String> path) {
        List types = schema.getTypes();
        for (Schema type : types) {
            Object object;
            try {
                Object subObj = this.read(field, type, value, path, true);
                if (subObj == INCOMPATIBLE) continue;
                object = subObj;
            }
            catch (AvroRuntimeException e) {
                continue;
            }
            return object;
        }
        throw AvroTypeExceptions.INSTANCE.unionException(field.name(), CollectionsKt.joinToString$default((Iterable)types, (CharSequence)", ", null, null, (int)0, null, (Function1)readUnion.1.INSTANCE, (int)30, null), path);
    }

    private final GenericData.EnumSymbol stringToEnumSymbol(Schema schema, String value, List<String> path) {
        List symbols = schema.getEnumSymbols();
        if (symbols.contains(value)) {
            return new GenericData.EnumSymbol(schema, value);
        }
        throw AvroTypeExceptions.INSTANCE.enumException(path, CollectionsKt.joinToString$default((Iterable)symbols, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    private final ByteBuffer bytesForString(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return ByteBuffer.wrap(byArray);
    }

    private final ByteBuffer bytesForStringBase64(String string) {
        return ByteBuffer.wrap(Base64.getDecoder().decode(string));
    }

    private final Object failAvroType(boolean isTestingUnion, List<String> path, Schema schema, Schema.Type type, Exception e) {
        block4: {
            Object object;
            Object object2;
            String string;
            List<String> list;
            AvroTypeExceptions avroTypeExceptions;
            block8: {
                block7: {
                    Object object3;
                    String it;
                    AvroTypeExceptions avroTypeExceptions2;
                    List<String> list2;
                    String string2;
                    String detailedExpectedType;
                    block6: {
                        block5: {
                            if (isTestingUnion) break block4;
                            String expectedType = type.getName();
                            LogicalType lt = schema.getLogicalType();
                            String logicalTypeDetails = lt instanceof LogicalTypes.Decimal ? "decimal (" + ((LogicalTypes.Decimal)lt).getPrecision() + ", " + ((LogicalTypes.Decimal)lt).getScale() + ")" : (lt instanceof LogicalTypes.Date ? "date" : (lt instanceof LogicalTypes.TimeMicros ? "time-micros" : (lt instanceof LogicalTypes.TimeMillis ? "time-millis" : (lt instanceof LogicalTypes.TimestampMicros ? "timestamp-micros" : (lt instanceof LogicalTypes.TimestampMillis ? "timestamp-millis" : null)))));
                            detailedExpectedType = WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 7 ? "a string in JSON" : null;
                            avroTypeExceptions = AvroTypeExceptions.INSTANCE;
                            list = path;
                            string = expectedType;
                            object2 = logicalTypeDetails;
                            if (object2 == null) break block5;
                            String string3 = object2;
                            string2 = string;
                            list2 = list;
                            avroTypeExceptions2 = avroTypeExceptions;
                            boolean bl = false;
                            object3 = " (" + it + ")";
                            avroTypeExceptions = avroTypeExceptions2;
                            list = list2;
                            string = string2;
                            Object object4 = object3;
                            object2 = object4;
                            if (object4 != null) break block6;
                        }
                        object2 = "";
                    }
                    if ((object = detailedExpectedType) == null) break block7;
                    it = object;
                    object3 = object2;
                    string2 = string;
                    list2 = list;
                    avroTypeExceptions2 = avroTypeExceptions;
                    boolean bl = false;
                    String string4 = " (" + it + ")";
                    avroTypeExceptions = avroTypeExceptions2;
                    list = list2;
                    string = string2;
                    object2 = object3;
                    String string5 = string4;
                    object = string5;
                    if (string5 != null) break block8;
                }
                object = "";
            }
            throw avroTypeExceptions.typeException(list, string + (String)object2 + (String)object, e);
        }
        return INCOMPATIBLE;
    }

    static /* synthetic */ Object failAvroType$default(JsonGenericRecordReader jsonGenericRecordReader, boolean bl, List list, Schema schema, Schema.Type type, Exception exception, int n, Object object) {
        if ((n & 0x10) != 0) {
            exception = null;
        }
        return jsonGenericRecordReader.failAvroType(bl, list, schema, type, exception);
    }

    private static final Object read$wrongTypeError(JsonGenericRecordReader this$0, boolean $isTestingUnion, List<String> childPath, Schema $schema, Exception e) {
        return this$0.failAvroType($isTestingUnion, childPath, $schema, $schema.getType(), e);
    }

    static /* synthetic */ Object read$wrongTypeError$default(JsonGenericRecordReader jsonGenericRecordReader, boolean bl, List list, Schema schema, Exception exception, int n, Object object) {
        if ((n & 0x10) != 0) {
            exception = null;
        }
        return JsonGenericRecordReader.read$wrongTypeError(jsonGenericRecordReader, bl, list, schema, exception);
    }

    public JsonGenericRecordReader() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/conduktor/avro/JsonGenericRecordReader$Companion;", "", "()V", "INCOMPATIBLE", "humanDateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "kafka"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            nArray[Schema.Type.UNION.ordinal()] = 1;
            nArray[Schema.Type.RECORD.ordinal()] = 2;
            nArray[Schema.Type.ARRAY.ordinal()] = 3;
            nArray[Schema.Type.MAP.ordinal()] = 4;
            nArray[Schema.Type.ENUM.ordinal()] = 5;
            nArray[Schema.Type.STRING.ordinal()] = 6;
            nArray[Schema.Type.BYTES.ordinal()] = 7;
            nArray[Schema.Type.INT.ordinal()] = 8;
            nArray[Schema.Type.LONG.ordinal()] = 9;
            nArray[Schema.Type.FLOAT.ordinal()] = 10;
            nArray[Schema.Type.DOUBLE.ordinal()] = 11;
            nArray[Schema.Type.BOOLEAN.ordinal()] = 12;
            nArray[Schema.Type.NULL.ordinal()] = 13;
            nArray[Schema.Type.FIXED.ordinal()] = 14;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

