/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.avro;

import io.conduktor.avro.AvroHelper;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016JN\u0010\u0013\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u001c\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020 2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/conduktor/avro/AvroToJson;", "", "()V", "TOSTRING_CIRCULAR_REFERENCE_ERROR_TEXT", "", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "addDefaultBytesStructure", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bytes", "Ljava/nio/ByteBuffer;", "logicalType", "Lorg/apache/avro/LogicalType;", "fieldSchema", "Lorg/apache/avro/Schema;", "toString", "datum", "options", "Lio/conduktor/avro/AvroToJson$Options;", "logicalTypeFromProps", "seenObjects", "Ljava/util/IdentityHashMap;", "writeAsString", "writeEscapedString", "string", "", "builder", "writeLargeLongToString", "", "Options", "kafka"})
public final class AvroToJson {
    @NotNull
    public static final AvroToJson INSTANCE = new AvroToJson();
    @NotNull
    private static final String TOSTRING_CIRCULAR_REFERENCE_ERROR_TEXT = " \">>> CIRCULAR REFERENCE CANNOT BE PUT IN JSON STRING, ABORTING RECURSION <<<\" ";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.ENGLISH).withZone(ZoneId.systemDefault());

    private AvroToJson() {
    }

    @NotNull
    public final String toString(@NotNull Object datum, @NotNull Options options) {
        StringBuilder sb = new StringBuilder();
        this.toString(null, null, datum, sb, new IdentityHashMap<Object, Object>(128), options);
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void toString(Schema fieldSchema, LogicalType logicalTypeFromProps, Object datum, StringBuilder buffer, IdentityHashMap<Object, Object> seenObjects, Options options) {
        block75: {
            block73: {
                if (!AvroHelper.INSTANCE.isRecord(datum)) break block73;
                v0 = datum;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.apache.avro.generic.IndexedRecord");
                }
                rec = (IndexedRecord)v0;
                if (seenObjects.containsKey(rec)) {
                    buffer.append(" \">>> CIRCULAR REFERENCE CANNOT BE PUT IN JSON STRING, ABORTING RECURSION <<<\" ");
                    return;
                }
                ((Map)seenObjects).put(rec, rec);
                buffer.append("{");
                schema = AvroHelper.INSTANCE.getRecordSchema(rec);
                var9_22 = schema.getFields().iterator();
                var10_26 = 0;
                while (var9_22.hasNext()) {
                    count = var10_26++;
                    f = (Schema.Field)var9_22.next();
                    this.toString(null, null, f.name(), buffer, seenObjects, options);
                    buffer.append(": ");
                    schemaField = rec.getSchema().getField(f.name()).schema();
                    var15_38 = f.getProp("logicalType");
                    if (var15_38 == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var15_38.hashCode()) {
                        case 3076014: {
                            if (var15_38.equals("date")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case -752262865: {
                            if (var15_38.equals("time-micros")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 1922012870: {
                            if (var15_38.equals("timestamp-micros")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case -752000698: {
                            if (var15_38.equals("time-millis")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case 1542263633: {
                            if (var15_38.equals("decimal")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 1922275037: {
                            if (var15_38.equals("timestamp-millis")) {
                                tmp = 6;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 5: {
                            var16_39 = f.getObjectProp("precision");
                            v1 = var16_39 instanceof Integer != false ? (Integer)var16_39 : null;
                            var16_39 = f.getObjectProp("scale");
                            v2 = var16_39 instanceof Integer != false ? (Integer)var16_39 : null;
                            v3 = (LogicalType)LogicalTypes.decimal((int)(v1 != null ? v1 : 4), (int)(v2 != null ? v2 : 0));
                            break;
                        }
                        case 6: {
                            v3 = (LogicalType)LogicalTypes.timestampMillis();
                            break;
                        }
                        case 3: {
                            v3 = (LogicalType)LogicalTypes.timestampMicros();
                            break;
                        }
                        case 2: {
                            v3 = (LogicalType)LogicalTypes.timeMicros();
                            break;
                        }
                        case 4: {
                            v3 = (LogicalType)LogicalTypes.timeMillis();
                            break;
                        }
                        case 1: {
                            v3 = (LogicalType)LogicalTypes.date();
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v3 = null;
                        }
                    }
                    logicalType = v3;
                    this.toString(schemaField, logicalType, rec.get(f.pos()), buffer, seenObjects, options);
                    if (count + 1 >= schema.getFields().size()) continue;
                    buffer.append(", ");
                }
                buffer.append("}");
                seenObjects.remove(rec);
                break block75;
            }
            if (AvroHelper.INSTANCE.isArray(datum)) {
                v4 = datum;
                if (v4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<*>");
                }
                array = (Collection)v4;
                if (seenObjects.containsKey(array)) {
                    buffer.append(" \">>> CIRCULAR REFERENCE CANNOT BE PUT IN JSON STRING, ABORTING RECURSION <<<\" ");
                    return;
                }
                ((Map)seenObjects).put(array, array);
                buffer.append("[");
                last = (long)array.size() - 1L;
                var10_27 = array.iterator();
                count = 0;
                while (var10_27.hasNext()) {
                    i = count++;
                    element = var10_27.next();
                    this.toString(null, null, element, buffer, seenObjects, options);
                    if ((long)i >= last) continue;
                    buffer.append(", ");
                }
                buffer.append("]");
                seenObjects.remove(array);
            } else if (AvroHelper.INSTANCE.isMap(datum)) {
                v5 = datum;
                if (v5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.Any, kotlin.Any>");
                }
                map = (Map)v5;
                if (seenObjects.containsKey(map)) {
                    buffer.append(" \">>> CIRCULAR REFERENCE CANNOT BE PUT IN JSON STRING, ABORTING RECURSION <<<\" ");
                    return;
                }
                ((Map)seenObjects).put(map, map);
                buffer.append("{");
                count = 0;
                for (Map.Entry<K, V> var10_28 : map.entrySet()) {
                    key = var10_28.getKey();
                    value = var10_28.getValue();
                    this.toString(null, null, key, buffer, seenObjects, options);
                    buffer.append(": ");
                    this.toString(null, null, value, buffer, seenObjects, options);
                    if (++count >= map.size()) continue;
                    buffer.append(", ");
                }
                buffer.append("}");
                seenObjects.remove(map);
            } else if (AvroHelper.INSTANCE.isString(datum) || AvroHelper.INSTANCE.isEnum(datum)) {
                this.writeAsString(buffer, datum);
            } else if (AvroHelper.INSTANCE.isByteArray(datum)) {
                v6 = datum;
                if (v6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                buf = ByteBuffer.wrap((byte[])v6);
                this.toString(fieldSchema, logicalTypeFromProps, buf, buffer, seenObjects, options);
            } else if (AvroHelper.INSTANCE.isBytes(datum)) {
                v7 = datum;
                if (v7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
                }
                bytes = ((ByteBuffer)v7).duplicate();
                if (options.getBytesAsString()) {
                    if (fieldSchema != null) {
                        v8 = this.logicalType(fieldSchema);
                        if (v8 == null) {
                            v8 = logicalTypeFromProps;
                        }
                        if ((logicalType = v8) instanceof LogicalTypes.Decimal) {
                            numberAsString = AvroHelper.INSTANCE.getDecimalConversion().fromBytes(bytes, fieldSchema, logicalType).toString();
                            this.toString(null, null, numberAsString, buffer, seenObjects, options);
                        } else {
                            b64 = Base64.getEncoder().encodeToString(bytes.array());
                            this.writeAsString(buffer, b64);
                        }
                    } else {
                        b64 = Base64.getEncoder().encodeToString(bytes.array());
                        this.writeAsString(buffer, b64);
                    }
                } else {
                    this.addDefaultBytesStructure(buffer, bytes);
                }
            } else if (datum instanceof Float && (Float.isInfinite(((Number)datum).floatValue()) || Float.isNaN(((Number)datum).floatValue())) || datum instanceof Double && (Double.isInfinite(((Number)datum).doubleValue()) || Double.isNaN(((Number)datum).doubleValue()))) {
                this.writeAsString(buffer, datum);
            } else if (datum instanceof Long) {
                if (options.getDateTimeAsString() && fieldSchema != null) {
                    v9 = this.logicalType(fieldSchema);
                    if (v9 == null) {
                        v9 = logicalTypeFromProps;
                    }
                    if ((logicalType = v9) instanceof LogicalTypes.TimestampMillis) {
                        dateTimeAsString = AvroToJson.dateTimeFormatter.format(AvroHelper.INSTANCE.getTimestampConversion().fromLong((Long)datum, fieldSchema, logicalType));
                        this.toString(fieldSchema, null, dateTimeAsString, buffer, seenObjects, options);
                    } else if (logicalType instanceof LogicalTypes.TimestampMicros) {
                        dateTimeAsString = AvroToJson.dateTimeFormatter.format(AvroHelper.INSTANCE.getTimestampMicrosConversion().fromLong((Long)datum, fieldSchema, logicalType));
                        this.toString(fieldSchema, null, dateTimeAsString, buffer, seenObjects, options);
                    } else if (logicalType instanceof LogicalTypes.TimeMicros) {
                        localTimeAsString = AvroHelper.INSTANCE.getTimeMicrosConversion().fromLong((Long)datum, fieldSchema, logicalType).toString();
                        this.toString(fieldSchema, null, localTimeAsString, buffer, seenObjects, options);
                    } else {
                        this.writeLargeLongToString(((Number)datum).longValue(), buffer);
                    }
                } else {
                    this.writeLargeLongToString(((Number)datum).longValue(), buffer);
                }
            } else if (datum instanceof Integer && options.getDateTimeAsString() && fieldSchema != null) {
                v10 = this.logicalType(fieldSchema);
                if (v10 == null) {
                    v10 = logicalTypeFromProps;
                }
                if ((logicalType = v10) instanceof LogicalTypes.TimeMillis) {
                    this.toString(fieldSchema, null, AvroHelper.INSTANCE.getTimeConversion().fromInt((Integer)datum, fieldSchema, logicalType).toString(), buffer, seenObjects, options);
                } else if (logicalType instanceof LogicalTypes.Date) {
                    this.toString(fieldSchema, null, AvroHelper.INSTANCE.getDateConversion().fromInt((Integer)datum, fieldSchema, logicalType).toString(), buffer, seenObjects, options);
                } else {
                    buffer.append(((Number)datum).intValue());
                }
            } else if (datum instanceof GenericData) {
                if (seenObjects.containsKey(datum)) {
                    buffer.append(" \">>> CIRCULAR REFERENCE CANNOT BE PUT IN JSON STRING, ABORTING RECURSION <<<\" ");
                    return;
                }
                ((Map)seenObjects).put(datum, datum);
                this.toString(null, null, datum, buffer, seenObjects, options);
                seenObjects.remove(datum);
            } else {
                buffer.append(datum);
            }
        }
    }

    private final void writeAsString(StringBuilder buffer, Object datum) {
        buffer.append("\"");
        this.writeEscapedString(String.valueOf(datum), buffer);
        buffer.append("\"");
    }

    private final void writeLargeLongToString(long datum, StringBuilder buffer) {
        if (datum > 0x20000000000000L || datum < -9007199254740992L) {
            this.writeAsString(buffer, datum);
        } else {
            buffer.append(datum);
        }
    }

    private final LogicalType logicalType(Schema fieldSchema) {
        Object object = fieldSchema.getLogicalType();
        if (object == null) {
            Schema schema = AvroHelper.INSTANCE.unwrapOptional(fieldSchema);
            object = schema != null ? schema.getLogicalType() : null;
        }
        return object;
    }

    private final void addDefaultBytesStructure(StringBuilder buffer, ByteBuffer bytes) {
        buffer.append("{\"bytes\": \"");
        this.writeEscapedString(StandardCharsets.ISO_8859_1.decode(bytes), buffer);
        buffer.append("\"}");
    }

    private final void writeEscapedString(CharSequence string, StringBuilder builder) {
        for (int i = 0; i < string.length(); ++i) {
            char element;
            block13: {
                block12: {
                    element = string.charAt(i);
                    char c = element;
                    if (c == '\"') {
                        builder.append("\\\"");
                        continue;
                    }
                    if (c == '\\') {
                        builder.append("\\\\");
                        continue;
                    }
                    if (c == '\b') {
                        builder.append("\\b");
                        continue;
                    }
                    if (c == '\f') {
                        builder.append("\\f");
                        continue;
                    }
                    if (c == '\n') {
                        builder.append("\\n");
                        continue;
                    }
                    if (c == '\r') {
                        builder.append("\\r");
                        continue;
                    }
                    if (c == '\t') {
                        builder.append("\\t");
                        continue;
                    }
                    if ('\u0000' <= element ? element < ' ' : false) break block12;
                    if ('\u007f' <= element ? element < '\u00a0' : false) break block12;
                    boolean bl = '\u2000' <= element ? element < '\u2100' : false;
                    if (!bl) break block13;
                }
                String hex = Integer.toHexString(element);
                builder.append("\\u");
                for (int j = 0; j < 4 - hex.length(); ++j) {
                    builder.append('0');
                }
                String string2 = hex.toUpperCase(Locale.ENGLISH);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                builder.append(string2);
                continue;
            }
            builder.append(element);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/conduktor/avro/AvroToJson$Options;", "", "dateTimeAsString", "", "bytesAsString", "(ZZ)V", "getBytesAsString", "()Z", "getDateTimeAsString", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "kafka"})
    public static final class Options {
        private final boolean dateTimeAsString;
        private final boolean bytesAsString;

        public Options(boolean dateTimeAsString, boolean bytesAsString) {
            this.dateTimeAsString = dateTimeAsString;
            this.bytesAsString = bytesAsString;
        }

        public final boolean getDateTimeAsString() {
            return this.dateTimeAsString;
        }

        public final boolean getBytesAsString() {
            return this.bytesAsString;
        }

        public final boolean component1() {
            return this.dateTimeAsString;
        }

        public final boolean component2() {
            return this.bytesAsString;
        }

        @NotNull
        public final Options copy(boolean dateTimeAsString, boolean bytesAsString) {
            return new Options(dateTimeAsString, bytesAsString);
        }

        public static /* synthetic */ Options copy$default(Options options, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options.dateTimeAsString;
            }
            if ((n & 2) != 0) {
                bl2 = options.bytesAsString;
            }
            return options.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Options(dateTimeAsString=" + this.dateTimeAsString + ", bytesAsString=" + this.bytesAsString + ")";
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.dateTimeAsString ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.bytesAsString) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            if (this.dateTimeAsString != options.dateTimeAsString) {
                return false;
            }
            return this.bytesAsString == options.bytesAsString;
        }
    }
}

