/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.KeyPair;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Function;
import sun.security.jca.JCAUtil;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class X509CertificateCreator {
    private X509CertificateCreator() {
    }

    public static InitialStage creator() {
        return new InitialStageImpl();
    }

    private static class BuildFinalImpl
    implements BuildFinal {
        private final String algorithm;
        private final String subject;
        private final String issuer;
        private final Instant notBefore;
        private final Instant notAfter;
        private final PublicKey publicKey;
        private final PrivateKey privateKey;
        private final CertificateExtensions extensions;
        private final SecureRandom secureRandom;

        BuildFinalImpl(String algorithm, String subject, String issuer, Instant notBefore, Instant notAfter, PublicKey publicKey, PrivateKey privateKey, CertificateExtensions extensions, SecureRandom secureRandom) {
            this.algorithm = algorithm;
            this.subject = subject;
            this.issuer = issuer;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.extensions = extensions;
            this.secureRandom = secureRandom;
        }

        BuildFinalImpl(String algorithm, String subject, String issuer, Instant notBefore, Instant notAfter, PublicKey publicKey, PrivateKey privateKey, CertificateExtensions extensions) {
            this.algorithm = algorithm;
            this.subject = subject;
            this.issuer = issuer;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.extensions = extensions;
            this.secureRandom = JCAUtil.getSecureRandom();
        }

        @Override
        public BuildFinal withSecureRandom(SecureRandom secureRandom) {
            return new BuildFinalImpl(this.algorithm, this.subject, this.issuer, this.notBefore, this.notAfter, this.publicKey, this.privateKey, this.extensions, secureRandom);
        }

        @Override
        public X509Certificate create() throws GeneralSecurityException {
            try {
                X509CertInfo info = new X509CertInfo();
                CertificateValidity interval = new CertificateValidity(Date.from(this.notBefore), Date.from(this.notAfter));
                BigInteger sn = new BigInteger(64, this.secureRandom);
                info.set("validity", interval);
                info.set("subject", new X500Name(this.subject));
                info.set("issuer", new X500Name(this.issuer));
                info.set("serialNumber", new CertificateSerialNumber(sn));
                info.set("key", new CertificateX509Key(this.publicKey));
                info.set("version", new CertificateVersion(2));
                info.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(this.algorithm)));
                info.set("extensions", this.extensions);
                X509CertImpl cert = new X509CertImpl(info);
                cert.sign(this.privateKey, this.algorithm);
                AlgorithmId algo = (AlgorithmId)cert.get("x509.algorithm");
                info.set("algorithmID.algorithm", algo);
                X509CertImpl newCert = new X509CertImpl(info);
                newCert.sign(this.privateKey, this.algorithm);
                return newCert;
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage(), e);
            }
        }

        @Override
        public BuildChainFinal chain() {
            return () -> new X509Certificate[]{this.create()};
        }

        @Override
        public BuildChainFinal chain(PrivateKey issuerPrivateKey, Function<PublicKeyStage, BuildChainFinal> childBuilderFunction) {
            return () -> {
                X509Certificate issuerCertificate = this.create();
                PublicKeyStage publicKeyStage = X509CertificateCreator.creator().withSignatureAlgorithm(this.algorithm).withNotBefore(this.notBefore).withNotAfter(this.notAfter).withIssuer(issuerCertificate).withSigningKey(issuerPrivateKey);
                X509Certificate[] certs = ((BuildChainFinal)childBuilderFunction.apply(publicKeyStage)).create();
                ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(Arrays.asList(certs));
                list.add(issuerCertificate);
                return list.toArray(new X509Certificate[0]);
            };
        }
    }

    private static class ExtensionsStageImpl
    implements ExtensionsStage {
        private final String algorithm;
        private final String subject;
        private final String issuer;
        private final Instant notBefore;
        private final Instant notAfter;
        private final PublicKey publicKey;
        private final PrivateKey privateKey;

        ExtensionsStageImpl(String algorithm, Instant notBefore, Instant notAfter, String issuer, PrivateKey privateKey, PublicKey publicKey, String subject) {
            this.algorithm = algorithm;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.subject = subject;
            this.issuer = issuer;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        @Override
        public BuildFinal withExtensions(CertificateExtensions extensions) {
            return new BuildFinalImpl(this.algorithm, this.subject, this.issuer, this.notBefore, this.notAfter, this.publicKey, this.privateKey, extensions, JCAUtil.getSecureRandom());
        }

        @Override
        public BuildFinal withEndEntityExtensions() {
            try {
                CertificateExtensions extensions = new CertificateExtensions();
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
                keyUsageExtension.set("key_encipherment", Boolean.TRUE);
                keyUsageExtension.set("digital_signature", Boolean.TRUE);
                extensions.set("KeyUsage", keyUsageExtension);
                return new BuildFinalImpl(this.algorithm, this.subject, this.issuer, this.notBefore, this.notAfter, this.publicKey, this.privateKey, extensions);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public BuildFinal withCertificateAuthorityExtensions(int pathLenConstraint) {
            try {
                CertificateExtensions extensions = new CertificateExtensions();
                extensions.set("BasicConstraints", new BasicConstraintsExtension(true, true, pathLenConstraint));
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
                keyUsageExtension.set("key_certsign", Boolean.TRUE);
                extensions.set("KeyUsage", keyUsageExtension);
                return new BuildFinalImpl(this.algorithm, this.subject, this.issuer, this.notBefore, this.notAfter, this.publicKey, this.privateKey, extensions);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public BuildFinal withClientCertificateExtensions() {
            try {
                CertificateExtensions extensions = new CertificateExtensions();
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
                keyUsageExtension.set("digital_signature", Boolean.TRUE);
                extensions.set("KeyUsage", keyUsageExtension);
                return new BuildFinalImpl(this.algorithm, this.subject, this.issuer, this.notBefore, this.notAfter, this.publicKey, this.privateKey, extensions);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class SubjectStageImpl
    implements SubjectStage {
        private final String algorithm;
        private final Instant notBefore;
        private final Instant notAfter;
        private final String issuer;
        private final PrivateKey privateKey;
        private final PublicKey publicKey;

        SubjectStageImpl(String algorithm, Instant notBefore, Instant notAfter, String issuer, PrivateKey privateKey, PublicKey publicKey) {
            this.algorithm = algorithm;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.issuer = issuer;
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        @Override
        public ExtensionsStage withSubject(String subject) {
            return new ExtensionsStageImpl(this.algorithm, this.notBefore, this.notAfter, this.issuer, this.privateKey, this.publicKey, subject);
        }
    }

    private static class PublicKeyStageImpl
    implements PublicKeyStage {
        private final String algorithm;
        private final Instant notBefore;
        private final Instant notAfter;
        private final String issuer;
        private final PrivateKey privateKey;

        PublicKeyStageImpl(String algorithm, Instant notBefore, Instant notAfter, String issuer, PrivateKey privateKey) {
            this.algorithm = algorithm;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.issuer = issuer;
            this.privateKey = privateKey;
        }

        @Override
        public SubjectStage withPublicKey(PublicKey publicKey) {
            return new SubjectStageImpl(this.algorithm, this.notBefore, this.notAfter, this.issuer, this.privateKey, publicKey);
        }
    }

    private static class PrivateKeyStageImpl<PK extends PrivateKey>
    implements PrivateKeyStage<PK> {
        private final String algorithm;
        private final String issuer;
        private final Instant notBefore;
        private final Instant notAfter;

        PrivateKeyStageImpl(String algorithm, Instant notBefore, Instant notAfter, String issuer) {
            this.algorithm = algorithm;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.issuer = issuer;
        }

        @Override
        public PublicKeyStage withSigningKey(PK privateKey) {
            return new PublicKeyStageImpl(this.algorithm, this.notBefore, this.notAfter, this.issuer, (PrivateKey)privateKey);
        }
    }

    private static class IssuerStageImpl<PK extends PrivateKey>
    implements IssuerStage<PK> {
        private final String algorithm;
        private final Instant notBefore;
        private final Instant notAfter;

        IssuerStageImpl(String algorithm, Instant notBefore, Instant notAfter) {
            this.algorithm = algorithm;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
        }

        @Override
        public PrivateKeyStage<PK> withIssuer(String issuer) {
            return new PrivateKeyStageImpl(this.algorithm, this.notBefore, this.notAfter, issuer);
        }

        @Override
        public PrivateKeyStage<PK> withIssuer(X509Certificate issuerCert) {
            return new PrivateKeyStageImpl(this.algorithm, this.notBefore, this.notAfter, issuerCert.getSubjectDN().getName());
        }

        @Override
        public BuildFinal withRootCA(String dn, java.security.KeyPair keyPair, int pathLenConstraint) {
            return new ExtensionsStageImpl(this.algorithm, this.notBefore, this.notAfter, dn, keyPair.getPrivate(), keyPair.getPublic(), dn).withCertificateAuthorityExtensions(pathLenConstraint);
        }

        @Override
        public BuildFinal withRootCA(String dn, KeyPair<? extends PublicKey, PK> keyPair, int pathLenConstraint) {
            return new ExtensionsStageImpl(this.algorithm, this.notBefore, this.notAfter, dn, (PrivateKey)keyPair.getPrivate(), keyPair.getPublic(), dn).withCertificateAuthorityExtensions(pathLenConstraint);
        }
    }

    private static class NotAfterStageImpl<PK extends PrivateKey>
    implements NotAfterStage<PK> {
        private final String algorithm;
        private final Instant notBefore;

        NotAfterStageImpl(String algorithm, Instant notBefore) {
            this.algorithm = algorithm;
            this.notBefore = notBefore;
        }

        @Override
        public IssuerStage<PK> withNotAfter(Instant notAfter) {
            return new IssuerStageImpl(this.algorithm, this.notBefore, notAfter);
        }

        @Override
        public IssuerStage<PK> withDuration(Duration duration) {
            return new IssuerStageImpl(this.algorithm, this.notBefore, this.notBefore.plus(duration));
        }
    }

    private static class NotBeforeStageImpl<PK extends PrivateKey>
    implements NotBeforeStage<PK> {
        private final String algorithm;

        NotBeforeStageImpl(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public NotAfterStage<PK> withNotBefore(Instant notBefore) {
            return new NotAfterStageImpl(this.algorithm, notBefore);
        }

        @Override
        public NotAfterStage<PK> withNotBeforeNow() {
            return new NotAfterStageImpl(this.algorithm, Instant.now());
        }

        @Override
        public IssuerStage<PK> withDuration(Duration duration) {
            return this.withDuration(Instant.now(), duration);
        }

        @Override
        public IssuerStage<PK> withDuration(Instant notBefore, Duration duration) {
            return new IssuerStageImpl(this.algorithm, notBefore, notBefore.plus(duration));
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public <PK extends PrivateKey> NotBeforeStage<PK> withSignatureAlgorithm(String algorithm) {
            return new NotBeforeStageImpl(algorithm);
        }

        @Override
        public NotBeforeStage<RSAPrivateKey> withSHA256withRSA() {
            return new NotBeforeStageImpl<RSAPrivateKey>("SHA256withRSA");
        }

        @Override
        public NotBeforeStage<RSAPrivateKey> withSHA384withRSA() {
            return new NotBeforeStageImpl<RSAPrivateKey>("SHA384withRSA");
        }

        @Override
        public NotBeforeStage<RSAPrivateKey> withSHA512withRSA() {
            return new NotBeforeStageImpl<RSAPrivateKey>("SHA512withRSA");
        }

        @Override
        public NotBeforeStage<ECPrivateKey> withSHA224withECDSA() {
            return new NotBeforeStageImpl<ECPrivateKey>("SHA224withECDSA");
        }

        @Override
        public NotBeforeStage<ECPrivateKey> withSHA256withECDSA() {
            return new NotBeforeStageImpl<ECPrivateKey>("SHA256withECDSA");
        }

        @Override
        public NotBeforeStage<ECPrivateKey> withSHA384withECDSA() {
            return new NotBeforeStageImpl<ECPrivateKey>("SHA384withECDSA");
        }

        @Override
        public NotBeforeStage<ECPrivateKey> withSHA512withECDSA() {
            return new NotBeforeStageImpl<ECPrivateKey>("SHA512withECDSA");
        }
    }

    public static interface BuildChainFinal {
        public X509Certificate[] create() throws IOException, GeneralSecurityException;
    }

    public static interface BuildFinal {
        public BuildFinal withSecureRandom(SecureRandom var1);

        public BuildChainFinal chain();

        public BuildChainFinal chain(PrivateKey var1, Function<PublicKeyStage, BuildChainFinal> var2);

        public X509Certificate create() throws IOException, GeneralSecurityException;
    }

    public static interface ExtensionsStage {
        public BuildFinal withExtensions(CertificateExtensions var1);

        public BuildFinal withEndEntityExtensions();

        public BuildFinal withCertificateAuthorityExtensions(int var1);

        public BuildFinal withClientCertificateExtensions();
    }

    public static interface SubjectStage {
        public ExtensionsStage withSubject(String var1);
    }

    public static interface PublicKeyStage {
        public SubjectStage withPublicKey(PublicKey var1);
    }

    public static interface PrivateKeyStage<PK extends PrivateKey> {
        public PublicKeyStage withSigningKey(PK var1);
    }

    public static interface IssuerStage<PK extends PrivateKey> {
        public PrivateKeyStage<PK> withIssuer(String var1);

        public PrivateKeyStage<PK> withIssuer(X509Certificate var1);

        public BuildFinal withRootCA(String var1, java.security.KeyPair var2, int var3);

        public BuildFinal withRootCA(String var1, KeyPair<? extends PublicKey, PK> var2, int var3);
    }

    public static interface NotAfterStage<PK extends PrivateKey> {
        public IssuerStage<PK> withNotAfter(Instant var1);

        public IssuerStage<PK> withDuration(Duration var1);
    }

    public static interface NotBeforeStage<PK extends PrivateKey> {
        public NotAfterStage<PK> withNotBefore(Instant var1);

        public NotAfterStage<PK> withNotBeforeNow();

        public IssuerStage<PK> withDuration(Duration var1);

        public IssuerStage<PK> withDuration(Instant var1, Duration var2);
    }

    public static interface InitialStage {
        public <PK extends PrivateKey> NotBeforeStage<PK> withSignatureAlgorithm(String var1);

        public NotBeforeStage<RSAPrivateKey> withSHA256withRSA();

        public NotBeforeStage<RSAPrivateKey> withSHA384withRSA();

        public NotBeforeStage<RSAPrivateKey> withSHA512withRSA();

        public NotBeforeStage<ECPrivateKey> withSHA224withECDSA();

        public NotBeforeStage<ECPrivateKey> withSHA256withECDSA();

        public NotBeforeStage<ECPrivateKey> withSHA384withECDSA();

        public NotBeforeStage<ECPrivateKey> withSHA512withECDSA();
    }
}

