/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.AbstractKeyStore;
import com.tersesystems.securitybuilder.RuntimeKeyStoreException;
import com.tersesystems.securitybuilder.TrustStore;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TrustStoreImpl
extends AbstractKeyStore<KeyStore.TrustedCertificateEntry>
implements TrustStore {
    protected TrustStoreImpl(KeyStore.Builder builder) {
        super(builder);
    }

    @Override
    public KeyStore.TrustedCertificateEntry putCertificate(String key, Certificate certificate) {
        return this.put(key, new KeyStore.TrustedCertificateEntry(certificate));
    }

    @Override
    public Optional<String> getCertificateAlias(Certificate certificate) throws RuntimeKeyStoreException {
        try {
            return Optional.ofNullable(this.getKeyStore().getCertificateAlias(certificate));
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    @Override
    public KeyStore.TrustedCertificateEntry put(String alias, KeyStore.TrustedCertificateEntry value) {
        try {
            this.getKeyStore().setEntry(alias, value, null);
            return value;
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    public String toString() {
        return String.format("TrustStoreImpl(size = %s)", this.size());
    }

    class TrustStoreEntry
    implements Map.Entry<String, KeyStore.TrustedCertificateEntry> {
        private final String alias;

        TrustStoreEntry(String alias) {
            this.alias = alias;
        }

        @Override
        public String getKey() {
            return this.alias;
        }

        @Override
        public KeyStore.TrustedCertificateEntry getValue() {
            try {
                return (KeyStore.TrustedCertificateEntry)TrustStoreImpl.this.getKeyStore().getEntry(this.alias, null);
            }
            catch (Exception e) {
                throw new RuntimeKeyStoreException(e);
            }
        }

        @Override
        public KeyStore.TrustedCertificateEntry setValue(KeyStore.TrustedCertificateEntry value) {
            try {
                TrustStoreImpl.this.getKeyStore().setEntry(this.alias, value, null);
                return value;
            }
            catch (KeyStoreException e) {
                throw new RuntimeKeyStoreException(e);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrustStoreEntry that = (TrustStoreEntry)o;
            KeyStore.TrustedCertificateEntry thisCertEntry = this.getValue();
            KeyStore.TrustedCertificateEntry thatCertEntry = that.getValue();
            return Objects.equals(this.alias, that.alias) && Objects.equals(thisCertEntry.getTrustedCertificate(), thatCertEntry.getTrustedCertificate()) && Objects.equals(thisCertEntry.getAttributes(), thatCertEntry.getAttributes());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.alias, this.getValue());
        }
    }
}

