/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.KeyStoreBuilder;
import com.tersesystems.securitybuilder.KeyStoreDefaults;
import com.tersesystems.securitybuilder.RuntimeKeyStoreException;
import com.tersesystems.securitybuilder.TrustStoreImpl;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public interface TrustStore
extends Map<String, KeyStore.TrustedCertificateEntry> {
    public static TrustStore create(final KeyStore keyStore) {
        return new TrustStoreImpl(new KeyStore.Builder(){

            @Override
            public KeyStore getKeyStore() throws KeyStoreException {
                return keyStore;
            }

            @Override
            public KeyStore.ProtectionParameter getProtectionParameter(String alias) throws KeyStoreException {
                return null;
            }
        });
    }

    public static TrustStore create(Map<? extends String, ? extends Certificate> certificates) {
        TrustStore trustStore = TrustStore.create();
        certificates.forEach((alias, cert) -> trustStore.put(alias, new KeyStore.TrustedCertificateEntry((Certificate)cert)));
        return trustStore;
    }

    public static <T extends Certificate> TrustStore create(List<T> certificates, Function<T, String> aliasFunction) {
        TrustStore trustStore = TrustStore.create();
        certificates.forEach((? super T cert) -> {
            String alias = (String)aliasFunction.apply(cert);
            trustStore.put(alias, new KeyStore.TrustedCertificateEntry((Certificate)cert));
        });
        return trustStore;
    }

    public static TrustStore create(CertStore certStore, Function<Certificate, String> aliasFunction) {
        try {
            TrustStore trustStore = TrustStore.create();
            certStore.getCertificates(new X509CertSelector()).forEach((? super T cert) -> {
                String alias = (String)aliasFunction.apply((Certificate)cert);
                trustStore.put(alias, new KeyStore.TrustedCertificateEntry((Certificate)cert));
            });
            return trustStore;
        }
        catch (CertStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static TrustStore create(KeyStore.Builder builder) {
        return new TrustStoreImpl(builder);
    }

    public static TrustStore create() {
        return TrustStore.create(KeyStoreBuilder.empty());
    }

    public static TrustStore system() {
        try {
            return TrustStore.create(KeyStoreDefaults.getCacertsKeyStore());
        }
        catch (Exception e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    public KeyStore getKeyStore();

    public KeyStore.TrustedCertificateEntry putCertificate(String var1, Certificate var2);

    public Optional<String> getCertificateAlias(Certificate var1) throws RuntimeKeyStoreException;
}

