/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import com.tersesystems.securitybuilder.KeyStoreDefaults;
import com.tersesystems.securitybuilder.TrustStore;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXBuilderParameters;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slieb.throwables.SupplierWithThrowable;

public class TrustManagerBuilder {
    private TrustManagerBuilder() {
    }

    public static InstanceStage builder() {
        return new InstanceStageImpl();
    }

    private static class BuilderFinalParametersImpl
    implements BuilderFinal {
        private final SupplierWithThrowable<PKIXBuilderParameters, Exception> parameters;
        private final SupplierWithThrowable<TrustManagerFactory, GeneralSecurityException> trustManagerFactory;

        BuilderFinalParametersImpl(SupplierWithThrowable<TrustManagerFactory, GeneralSecurityException> tmf, SupplierWithThrowable<PKIXBuilderParameters, Exception> parameters) {
            this.trustManagerFactory = tmf;
            this.parameters = parameters;
        }

        @Override
        public X509ExtendedTrustManager build() throws Exception {
            TrustManagerFactory tmf = (TrustManagerFactory)this.trustManagerFactory.getWithThrowable();
            tmf.init(new CertPathTrustManagerParameters((CertPathParameters)this.parameters.getWithThrowable()));
            return (X509ExtendedTrustManager)tmf.getTrustManagers()[0];
        }
    }

    private static class BuilderFinalKeyStoreImpl
    implements BuilderFinal {
        private final SupplierWithThrowable<KeyStore, Exception> keyStore;
        private final SupplierWithThrowable<TrustManagerFactory, GeneralSecurityException> trustManagerFactory;

        BuilderFinalKeyStoreImpl(SupplierWithThrowable<TrustManagerFactory, GeneralSecurityException> tmf, SupplierWithThrowable<KeyStore, Exception> keyStore) {
            this.trustManagerFactory = tmf;
            this.keyStore = keyStore;
        }

        @Override
        public X509ExtendedTrustManager build() throws Exception {
            TrustManagerFactory tmf = (TrustManagerFactory)this.trustManagerFactory.getWithThrowable();
            tmf.init((KeyStore)this.keyStore.getWithThrowable());
            return (X509ExtendedTrustManager)tmf.getTrustManagers()[0];
        }
    }

    private static class ParametersStageImpl
    implements ParametersStage {
        private final SupplierWithThrowable<TrustManagerFactory, GeneralSecurityException> trustManagerFactory;

        ParametersStageImpl(SupplierWithThrowable<TrustManagerFactory, GeneralSecurityException> trustManagerFactory) {
            this.trustManagerFactory = trustManagerFactory;
        }

        @Override
        public BuilderFinal withKeyStore(KeyStore keyStore) {
            return new BuilderFinalKeyStoreImpl(this.trustManagerFactory, (SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)() -> keyStore));
        }

        @Override
        public BuilderFinal withKeyStore(SupplierWithThrowable<KeyStore, Exception> keyStoreSupplier) {
            return new BuilderFinalKeyStoreImpl(this.trustManagerFactory, keyStoreSupplier);
        }

        @Override
        public BuilderFinal withDefaultKeystore() {
            return new BuilderFinalKeyStoreImpl(this.trustManagerFactory, (SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)KeyStoreDefaults::getCacertsKeyStore));
        }

        @Override
        public BuilderFinal withTrustStore(TrustStore trustStore) {
            return new BuilderFinalKeyStoreImpl(this.trustManagerFactory, (SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)trustStore::getKeyStore));
        }

        @Override
        public BuilderFinal withPKIXBuilderParameters(PKIXBuilderParameters params) {
            return new BuilderFinalParametersImpl(this.trustManagerFactory, (SupplierWithThrowable<PKIXBuilderParameters, Exception>)((SupplierWithThrowable)() -> params));
        }

        @Override
        public BuilderFinal withPKIXBuilderParameters(SupplierWithThrowable<PKIXBuilderParameters, Exception> params) {
            return new BuilderFinalParametersImpl(this.trustManagerFactory, params);
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<TrustManagerFactory, GeneralSecurityException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public ParametersStage withAlgorithm(String algorithm) {
            return new ParametersStageImpl(this.getInstance().withAlgorithm(algorithm));
        }

        @Override
        public ParametersStage withAlgorithmAndProvider(String algorithm, String provider) {
            return new ParametersStageImpl(this.getInstance().withAlgorithmAndProvider(algorithm, provider));
        }

        @Override
        public ParametersStage withDefaultAlgorithm() {
            return new ParametersStageImpl(this.getInstance().withDefaultAlgorithm());
        }
    }

    public static interface BuilderFinal {
        public X509ExtendedTrustManager build() throws Exception;
    }

    public static interface ParametersStage {
        public BuilderFinal withKeyStore(KeyStore var1);

        public BuilderFinal withKeyStore(SupplierWithThrowable<KeyStore, Exception> var1);

        public BuilderFinal withDefaultKeystore();

        public BuilderFinal withPKIXBuilderParameters(PKIXBuilderParameters var1);

        public BuilderFinal withPKIXBuilderParameters(SupplierWithThrowable<PKIXBuilderParameters, Exception> var1);

        public BuilderFinal withTrustStore(TrustStore var1);
    }

    public static interface InstanceStage {
        public ParametersStage withAlgorithm(String var1);

        public ParametersStage withAlgorithmAndProvider(String var1, String var2);

        public ParametersStage withDefaultAlgorithm();
    }
}

