/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.slieb.throwables.SupplierWithThrowable;

public class SignatureBuilder {
    public static InstanceStage builder() {
        return new InstanceStageImpl();
    }

    private static class BuildFinalImpl
    implements BuildFinal {
        private final SupplierWithThrowable<Signature, GeneralSecurityException> supplier;

        BuildFinalImpl(SupplierWithThrowable<Signature, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal setParameter(AlgorithmParameterSpec params) {
            return new BuildFinalImpl((SupplierWithThrowable<Signature, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Signature signature = (Signature)this.supplier.getWithThrowable();
                signature.setParameter(params);
                return signature;
            }));
        }

        @Override
        public Signature build() throws GeneralSecurityException {
            return (Signature)this.supplier.getWithThrowable();
        }
    }

    private static class InitializeStageImpl<PR extends PrivateKey, PU extends PublicKey>
    implements InitializeStage<PR, PU> {
        private final SupplierWithThrowable<Signature, GeneralSecurityException> supplier;

        InitializeStageImpl(SupplierWithThrowable<Signature, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal signing(PR privateKey) {
            return new BuildFinalImpl((SupplierWithThrowable<Signature, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Signature signature = (Signature)this.supplier.getWithThrowable();
                signature.initSign((PrivateKey)privateKey);
                return signature;
            }));
        }

        @Override
        public BuildFinal signing(PR privateKey, SecureRandom secureRandom) {
            return new BuildFinalImpl((SupplierWithThrowable<Signature, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Signature signature = (Signature)this.supplier.getWithThrowable();
                signature.initSign((PrivateKey)privateKey, secureRandom);
                return signature;
            }));
        }

        @Override
        public BuildFinal verifying(Certificate certificate) {
            return new BuildFinalImpl((SupplierWithThrowable<Signature, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Signature signature = (Signature)this.supplier.getWithThrowable();
                signature.initVerify(certificate);
                return signature;
            }));
        }

        @Override
        public BuildFinal verifying(PU publicKey) {
            return new BuildFinalImpl((SupplierWithThrowable<Signature, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Signature signature = (Signature)this.supplier.getWithThrowable();
                signature.initVerify((PublicKey)publicKey);
                return signature;
            }));
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<Signature, GeneralSecurityException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public <PR extends PrivateKey, PU extends PublicKey> InitializeStage<PR, PU> withAlgorithm(String algorithm) {
            return new InitializeStageImpl(this.getInstance().withAlgorithm(algorithm));
        }

        @Override
        public <PR extends PrivateKey, PU extends PublicKey> InitializeStage<PR, PU> withAlgorithmAndProvider(String algorithm, String provider) {
            return new InitializeStageImpl(this.getInstance().withAlgorithmAndProvider(algorithm, provider));
        }

        @Override
        public InitializeStage<RSAPrivateKey, RSAPublicKey> withSHA256withRSA() {
            return this.withAlgorithm("SHA256withRSA");
        }

        @Override
        public InitializeStage<RSAPrivateKey, RSAPublicKey> withSHA384withRSA() {
            return this.withAlgorithm("SHA384withRSA");
        }

        @Override
        public InitializeStage<RSAPrivateKey, RSAPublicKey> withSHA512withRSA() {
            return this.withAlgorithm("SHA512withRSA");
        }

        @Override
        public InitializeStage<DSAPrivateKey, DSAPublicKey> withSHA256withDSA() {
            return this.withAlgorithm("SHA256withDSA");
        }

        @Override
        public InitializeStage<DSAPrivateKey, DSAPublicKey> withSHA512withDSA() {
            return this.withAlgorithm("SHA512withDSA");
        }

        @Override
        public InitializeStage<ECPrivateKey, ECPublicKey> withSHA256withECDSA() {
            return this.withAlgorithm("SHA256withECDSA");
        }

        @Override
        public InitializeStage<ECPrivateKey, ECPublicKey> withSHA384withECDSA() {
            return this.withAlgorithm("SHA384withECDSA");
        }

        @Override
        public InitializeStage<ECPrivateKey, ECPublicKey> withSHA512withECDSA() {
            return this.withAlgorithm("SHA512withECDSA");
        }
    }

    public static interface BuildFinal {
        public BuildFinal setParameter(AlgorithmParameterSpec var1);

        public Signature build() throws GeneralSecurityException;
    }

    public static interface InitializeStage<PR extends PrivateKey, PU extends PublicKey> {
        public BuildFinal signing(PR var1);

        public BuildFinal signing(PR var1, SecureRandom var2);

        public BuildFinal verifying(Certificate var1);

        public BuildFinal verifying(PU var1);
    }

    public static interface InstanceStage {
        public <PR extends PrivateKey, PU extends PublicKey> InitializeStage<PR, PU> withAlgorithm(String var1);

        public <PR extends PrivateKey, PU extends PublicKey> InitializeStage<PR, PU> withAlgorithmAndProvider(String var1, String var2);

        public InitializeStage<RSAPrivateKey, RSAPublicKey> withSHA256withRSA();

        public InitializeStage<RSAPrivateKey, RSAPublicKey> withSHA384withRSA();

        public InitializeStage<RSAPrivateKey, RSAPublicKey> withSHA512withRSA();

        public InitializeStage<DSAPrivateKey, DSAPublicKey> withSHA256withDSA();

        public InitializeStage<DSAPrivateKey, DSAPublicKey> withSHA512withDSA();

        public InitializeStage<ECPrivateKey, ECPublicKey> withSHA256withECDSA();

        public InitializeStage<ECPrivateKey, ECPublicKey> withSHA384withECDSA();

        public InitializeStage<ECPrivateKey, ECPublicKey> withSHA512withECDSA();
    }
}

