/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.PasswordSpecificKeyStoreBuilder;
import com.tersesystems.securitybuilder.SecretKeyStoreImpl;
import java.security.KeyStore;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public interface SecretKeyStore
extends Map<String, KeyStore.SecretKeyEntry> {
    public static SecretKeyStore create(KeyStore keyStore, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        KeyStore.Builder builder = PasswordSpecificKeyStoreBuilder.newInstance(keyStore, passwordFunction);
        return SecretKeyStore.create(builder);
    }

    public static SecretKeyStore create(Supplier<KeyStore> keyStoreSupplier, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        KeyStore.Builder builder = PasswordSpecificKeyStoreBuilder.newInstance(keyStoreSupplier, passwordFunction);
        return SecretKeyStore.create(builder);
    }

    public static SecretKeyStore create(KeyStore.Builder builder) {
        return new SecretKeyStoreImpl(builder);
    }

    public KeyStore getKeyStore();
}

