/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.security.GeneralSecurityException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slieb.throwables.FunctionWithThrowable;
import org.slieb.throwables.SupplierWithThrowable;

public class SecretKeyBuilder {
    public static InitialStage builder() {
        return new InitialStageImpl();
    }

    private static class SecretKeyFactoryBuildFinal
    implements BuildFinal {
        private final SupplierWithThrowable<SecretKey, GeneralSecurityException> secretKeySupplier;

        SecretKeyFactoryBuildFinal(SupplierWithThrowable<SecretKey, GeneralSecurityException> secretKeySupplier) {
            this.secretKeySupplier = secretKeySupplier;
        }

        @Override
        public SecretKey build() throws GeneralSecurityException {
            return (SecretKey)this.secretKeySupplier.getWithThrowable();
        }
    }

    private static class SecretKeySpecBuildFinal<T extends SecretKey>
    implements BuildFinal {
        private final SupplierWithThrowable<SecretKey, GeneralSecurityException> keySpecSupplier;

        SecretKeySpecBuildFinal(SupplierWithThrowable<SecretKey, GeneralSecurityException> keySpecSupplier) {
            this.keySpecSupplier = keySpecSupplier;
        }

        @Override
        public SecretKey build() throws GeneralSecurityException {
            return (SecretKey)this.keySpecSupplier.getWithThrowable();
        }
    }

    private static class SecretKeySpecDataStageImpl
    implements DataStage {
        private final FunctionWithThrowable<byte[], SecretKey, GeneralSecurityException> keySpecFunction;

        SecretKeySpecDataStageImpl(FunctionWithThrowable<byte[], SecretKey, GeneralSecurityException> keySpecFunction) {
            this.keySpecFunction = keySpecFunction;
        }

        @Override
        public BuildFinal withData(byte[] bytes) {
            return new SecretKeySpecBuildFinal((SupplierWithThrowable<SecretKey, GeneralSecurityException>)((SupplierWithThrowable)() -> this.keySpecFunction.apply((Object)bytes)));
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public DataStage withSecretKeySpec(String algorithm) {
            return new SecretKeySpecDataStageImpl((FunctionWithThrowable<byte[], SecretKey, GeneralSecurityException>)((FunctionWithThrowable)bytes -> new SecretKeySpec((byte[])bytes, algorithm)));
        }

        @Override
        public DataStage withAES() {
            return new SecretKeySpecDataStageImpl((FunctionWithThrowable<byte[], SecretKey, GeneralSecurityException>)((FunctionWithThrowable)bytes -> new SecretKeySpec((byte[])bytes, "AES")));
        }
    }

    public static interface BuildFinal {
        public SecretKey build() throws GeneralSecurityException;
    }

    public static interface DataStage {
        public BuildFinal withData(byte[] var1);
    }

    public static interface KeyStage {
        public BuildFinal withKeySpec(KeySpec var1);
    }

    public static interface InitialStage {
        public DataStage withAES();

        public DataStage withSecretKeySpec(String var1);
    }
}

