/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slieb.throwables.SupplierWithThrowable;

public class SSLContextBuilder {
    private SSLContextBuilder() {
    }

    public static InstanceStage builder() {
        return new InstanceStageImpl();
    }

    private static class BuildFinalImpl
    implements BuildFinal {
        private final SupplierWithThrowable<SSLContext, GeneralSecurityException> supplier;
        private Supplier<TrustManager> trustManagerSupplier = () -> null;
        private Supplier<KeyManager> keyManagerSupplier = () -> null;
        private Supplier<SecureRandom> secureRandomSupplier = () -> null;

        BuildFinalImpl(SupplierWithThrowable<SSLContext, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal withTrustManager(TrustManager trustManager) {
            this.trustManagerSupplier = () -> trustManager;
            return this;
        }

        @Override
        public BuildFinal withTrustManager(Supplier<TrustManager> trustManagerSupplier) {
            this.trustManagerSupplier = trustManagerSupplier;
            return this;
        }

        @Override
        public BuildFinal withKeyManager(KeyManager keyManager) {
            this.keyManagerSupplier = () -> keyManager;
            return this;
        }

        @Override
        public BuildFinal withKeyManager(Supplier<KeyManager> keyManagerSupplier) {
            this.keyManagerSupplier = keyManagerSupplier;
            return this;
        }

        @Override
        public BuildFinal withSecureRandom(SecureRandom secureRandom) {
            this.secureRandomSupplier = () -> secureRandom;
            return this;
        }

        @Override
        public BuildFinal withSecureRandom(Supplier<SecureRandom> secureRandomSupplier) {
            this.secureRandomSupplier = secureRandomSupplier;
            return this;
        }

        @Override
        public SSLContext build() throws GeneralSecurityException {
            TrustManager[] trustManagerArray;
            KeyManager[] keyManagerArray;
            KeyManager km = this.keyManagerSupplier.get();
            if (km == null) {
                keyManagerArray = null;
            } else {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = km;
            }
            KeyManager[] kms = keyManagerArray;
            TrustManager tm = this.trustManagerSupplier.get();
            if (tm == null) {
                trustManagerArray = null;
            } else {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = tm;
            }
            TrustManager[] tms = trustManagerArray;
            SSLContext sslContext = (SSLContext)this.supplier.getWithThrowable();
            sslContext.init(kms, tms, this.secureRandomSupplier.get());
            return sslContext;
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<SSLContext, GeneralSecurityException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public BuildFinal withTLS() {
            return new BuildFinalImpl(this.getInstance().withProtocol("TLS"));
        }

        @Override
        public BuildFinal withTLS12() {
            return new BuildFinalImpl(this.getInstance().withProtocol("TLSv1.2"));
        }

        @Override
        public BuildFinal withProtocol(String protocol) {
            return new BuildFinalImpl(this.getInstance().withProtocol(protocol));
        }

        @Override
        public BuildFinal withProtocolAndProvider(String protocol, String provider) {
            return new BuildFinalImpl(this.getInstance().withProtocolAndProvider(protocol, provider));
        }
    }

    public static interface BuildFinal {
        public BuildFinal withTrustManager(TrustManager var1);

        public BuildFinal withTrustManager(Supplier<TrustManager> var1);

        public BuildFinal withKeyManager(KeyManager var1);

        public BuildFinal withKeyManager(Supplier<KeyManager> var1);

        public BuildFinal withSecureRandom(SecureRandom var1);

        public BuildFinal withSecureRandom(Supplier<SecureRandom> var1);

        public SSLContext build() throws GeneralSecurityException;
    }

    public static interface InstanceStage {
        public BuildFinal withTLS();

        public BuildFinal withTLS12();

        public BuildFinal withProtocol(String var1);

        public BuildFinal withProtocolAndProvider(String var1, String var2);
    }
}

