/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public interface RSAKeyPair
extends KeyPair<RSAPublicKey, RSAPrivateKey> {
    public static RSAKeyPair create(final RSAPublicKey publicKey, final RSAPrivateKey privateKey) {
        return new RSAKeyPair(){

            @Override
            public RSAPublicKey getPublic() {
                return publicKey;
            }

            @Override
            public RSAPrivateKey getPrivate() {
                return privateKey;
            }
        };
    }

    public static RSAKeyPair create(final java.security.KeyPair keyPair) {
        return new RSAKeyPair(){

            @Override
            public RSAPublicKey getPublic() {
                return (RSAPublicKey)keyPair.getPublic();
            }

            @Override
            public RSAPrivateKey getPrivate() {
                return (RSAPrivateKey)keyPair.getPrivate();
            }
        };
    }
}

