/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.AbstractKeyStore;
import com.tersesystems.securitybuilder.PrivateKeyStore;
import com.tersesystems.securitybuilder.RuntimeKeyStoreException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Objects;

public class PrivateKeyStoreImpl
extends AbstractKeyStore<KeyStore.PrivateKeyEntry>
implements PrivateKeyStore {
    protected PrivateKeyStoreImpl(KeyStore.Builder builder) {
        super(builder);
    }

    @Override
    public KeyStore.PrivateKeyEntry get(Object key) {
        if (key instanceof String) {
            String alias = (String)key;
            Objects.requireNonNull(alias, "Null alias!");
            try {
                KeyStore keyStore = this.getKeyStore();
                if (keyStore.getCertificateChain(alias) == null) {
                    String msg = "No entry available because there is no certificate chain for " + alias;
                    KeyStoreException e = new KeyStoreException(msg);
                    throw new RuntimeKeyStoreException(e);
                }
                return (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, this.protectionParameter(alias));
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeKeyStoreException(e);
            }
        }
        return null;
    }

    @Override
    public KeyStore.Builder getBuilder() {
        return this.builder;
    }

    public String toString() {
        return String.format("PrivateKeyStoreImpl(size = %s)", this.size());
    }
}

