/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.EncodedKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHPrivateKeySpec;
import org.slieb.throwables.SupplierWithThrowable;

public class PrivateKeyBuilder {
    public static InstanceStage builder() {
        return new InstanceStageImpl();
    }

    private static class BuildFinalImpl<T extends PrivateKey>
    implements BuildFinal<T> {
        private final SupplierWithThrowable<T, GeneralSecurityException> supplier;

        BuildFinalImpl(SupplierWithThrowable<T, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T build() throws GeneralSecurityException {
            return (T)((PrivateKey)this.supplier.getWithThrowable());
        }
    }

    private static class DHPrivateKeySpecStageImpl
    implements DHPrivateKeySpecStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        DHPrivateKeySpecStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<DHPrivateKey> withKeySpec(DHPrivateKeySpec keySpec) {
            return new BuildFinalImpl<DHPrivateKey>(() -> (DHPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }

        @Override
        public BuildFinal<DHPrivateKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<DHPrivateKey>(() -> (DHPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }
    }

    private static class ECPrivateKeySpecStageImpl
    implements ECPrivateKeySpecStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        ECPrivateKeySpecStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<ECPrivateKey> withKeySpec(ECPrivateKeySpec keySpec) {
            return new BuildFinalImpl<ECPrivateKey>(() -> (ECPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }

        @Override
        public BuildFinal<ECPrivateKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<ECPrivateKey>(() -> (ECPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }
    }

    private static class RSAPrivateKeySpecStageImpl
    implements RSAPrivateKeySpecStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        RSAPrivateKeySpecStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<RSAPrivateKey> withKeySpec(RSAPrivateKeySpec keySpec) {
            return new BuildFinalImpl<RSAPrivateKey>(() -> (RSAPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }

        @Override
        public BuildFinal<RSAPrivateKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<RSAPrivateKey>(() -> (RSAPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }
    }

    private static class DSAPrivateKeySpecStageImpl
    implements DSAPrivateKeySpecStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        DSAPrivateKeySpecStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<DSAPrivateKey> withKeySpec(DSAPrivateKeySpec keySpec) {
            return new BuildFinalImpl<DSAPrivateKey>(() -> (DSAPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }

        @Override
        public BuildFinal<DSAPrivateKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<DSAPrivateKey>(() -> (DSAPrivateKey)((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }
    }

    private static class PrivateKeySpecStageImpl<T extends PrivateKey>
    implements PrivateKeySpecStage<T> {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        PrivateKeySpecStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<T> withKeySpec(KeySpec keySpec) {
            return new BuildFinalImpl(() -> ((KeyFactory)this.supplier.getWithThrowable()).generatePrivate(keySpec));
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<KeyFactory, GeneralSecurityException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public <T extends PrivateKey> PrivateKeySpecStage<T> withAlgorithm(String algorithm) {
            return new PrivateKeySpecStageImpl(this.getInstance().withAlgorithm(algorithm));
        }

        @Override
        public <T extends PrivateKey> PrivateKeySpecStage<T> withAlgorithmAndProvider(String algorithm, String provider) {
            return new PrivateKeySpecStageImpl(this.getInstance().withAlgorithmAndProvider(algorithm, provider));
        }

        @Override
        public RSAPrivateKeySpecStage withRSA() {
            return new RSAPrivateKeySpecStageImpl(this.getInstance().withAlgorithm("RSA"));
        }

        @Override
        public ECPrivateKeySpecStage withEC() {
            return new ECPrivateKeySpecStageImpl(this.getInstance().withAlgorithm("EC"));
        }

        @Override
        public DHPrivateKeySpecStage withDH() {
            return new DHPrivateKeySpecStageImpl(this.getInstance().withAlgorithm("DH"));
        }

        @Override
        public DSAPrivateKeySpecStage withDSA() {
            return new DSAPrivateKeySpecStageImpl(this.getInstance().withAlgorithm("DSA"));
        }
    }

    public static interface BuildFinal<T extends PrivateKey> {
        public T build() throws GeneralSecurityException;
    }

    public static interface EncodedPrivateKeySpecStage<T extends PrivateKey> {
        public BuildFinal<T> withKeySpec(EncodedKeySpec var1);
    }

    public static interface DHPrivateKeySpecStage
    extends EncodedPrivateKeySpecStage<DHPrivateKey> {
        public BuildFinal<DHPrivateKey> withKeySpec(DHPrivateKeySpec var1);
    }

    public static interface ECPrivateKeySpecStage
    extends EncodedPrivateKeySpecStage<ECPrivateKey> {
        public BuildFinal<ECPrivateKey> withKeySpec(ECPrivateKeySpec var1);
    }

    public static interface DSAPrivateKeySpecStage
    extends EncodedPrivateKeySpecStage<DSAPrivateKey> {
        public BuildFinal<DSAPrivateKey> withKeySpec(DSAPrivateKeySpec var1);
    }

    public static interface RSAPrivateKeySpecStage
    extends EncodedPrivateKeySpecStage<RSAPrivateKey> {
        public BuildFinal<RSAPrivateKey> withKeySpec(RSAPrivateKeySpec var1);
    }

    public static interface PrivateKeySpecStage<T extends PrivateKey> {
        public BuildFinal<T> withKeySpec(KeySpec var1);
    }

    public static interface InstanceStage {
        public <T extends PrivateKey> PrivateKeySpecStage<T> withAlgorithm(String var1);

        public <T extends PrivateKey> PrivateKeySpecStage<T> withAlgorithmAndProvider(String var1, String var2);

        public RSAPrivateKeySpecStage withRSA();

        public DSAPrivateKeySpecStage withDSA();

        public ECPrivateKeySpecStage withEC();

        public DHPrivateKeySpecStage withDH();
    }
}

