/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slieb.throwables.SupplierWithThrowable;

public class MacBuilder {
    public static InitialStage builder() {
        return new InitialStageImpl();
    }

    private static class BuildFinalImpl
    implements BuildFinal {
        private final SupplierWithThrowable<Mac, GeneralSecurityException> supplier;

        BuildFinalImpl(SupplierWithThrowable<Mac, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Mac build() throws GeneralSecurityException {
            return (Mac)this.supplier.getWithThrowable();
        }
    }

    private static class SecretKeySpecStageImpl
    implements SecretKeySpecStage {
        private final SupplierWithThrowable<Mac, GeneralSecurityException> supplier;

        SecretKeySpecStageImpl(SupplierWithThrowable<Mac, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal withBytes(byte[] privateBytes) {
            return new BuildFinalImpl((SupplierWithThrowable<Mac, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Mac mac = (Mac)this.supplier.get();
                mac.init(new SecretKeySpec(privateBytes, mac.getAlgorithm()));
                return mac;
            }));
        }

        @Override
        public BuildFinal withString(String privateString) {
            return new BuildFinalImpl((SupplierWithThrowable<Mac, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Mac mac = (Mac)this.supplier.get();
                mac.init(new SecretKeySpec(privateString.getBytes(StandardCharsets.UTF_8), mac.getAlgorithm()));
                return mac;
            }));
        }
    }

    private static class InitializeStageImpl
    implements InitializeStage {
        private final SupplierWithThrowable<Mac, GeneralSecurityException> supplier;

        InitializeStageImpl(SupplierWithThrowable<Mac, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal withKey(SecretKey key) {
            return new BuildFinalImpl((SupplierWithThrowable<Mac, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Mac mac = (Mac)this.supplier.get();
                mac.init(key);
                return mac;
            }));
        }

        @Override
        public BuildFinal withKeyAndSpec(SecretKey key, AlgorithmParameterSpec params) {
            return new BuildFinalImpl((SupplierWithThrowable<Mac, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                Mac mac = (Mac)this.supplier.get();
                mac.init(key, params);
                return mac;
            }));
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public SecretKeySpecStage withHmacSHA256() {
            return this.withSecretKeySpec("HmacSHA256");
        }

        @Override
        public SecretKeySpecStage withHmacSHA384() {
            return this.withSecretKeySpec("HmacSHA384");
        }

        @Override
        public SecretKeySpecStage withHmacSHA512() {
            return this.withSecretKeySpec("HmacSHA512");
        }

        @Override
        public SecretKeySpecStage withPBEWithHmacSHA256() {
            return this.withSecretKeySpec("PBEWithHmacSHA256");
        }

        @Override
        public SecretKeySpecStage withPBEWithHmacSHA384() {
            return this.withSecretKeySpec("PBEWithHmacSHA384");
        }

        @Override
        public SecretKeySpecStage withPBEWithHmacSHA512() {
            return this.withSecretKeySpec("PBEWithHmacSHA512");
        }

        @Override
        public SecretKeySpecStage withSecretKeySpec(String algorithm) {
            return new SecretKeySpecStageImpl((SupplierWithThrowable<Mac, GeneralSecurityException>)((SupplierWithThrowable)() -> Mac.getInstance(algorithm)));
        }

        @Override
        public InitializeStage withAlgorithm(String algorithm) {
            return new InitializeStageImpl((SupplierWithThrowable<Mac, GeneralSecurityException>)((SupplierWithThrowable)() -> Mac.getInstance(algorithm)));
        }

        @Override
        public InitializeStage withAlgorithm(String algorithm, String provider) {
            return new InitializeStageImpl((SupplierWithThrowable<Mac, GeneralSecurityException>)((SupplierWithThrowable)() -> Mac.getInstance(algorithm, provider)));
        }
    }

    public static interface BuildFinal {
        public Mac build() throws GeneralSecurityException;
    }

    public static interface SecretKeySpecStage {
        public BuildFinal withBytes(byte[] var1);

        public BuildFinal withString(String var1);
    }

    public static interface InitializeStage {
        public BuildFinal withKey(SecretKey var1);

        public BuildFinal withKeyAndSpec(SecretKey var1, AlgorithmParameterSpec var2);
    }

    public static interface InitialStage {
        public SecretKeySpecStage withHmacSHA256();

        public SecretKeySpecStage withHmacSHA384();

        public SecretKeySpecStage withHmacSHA512();

        public SecretKeySpecStage withPBEWithHmacSHA256();

        public SecretKeySpecStage withPBEWithHmacSHA384();

        public SecretKeySpecStage withPBEWithHmacSHA512();

        public SecretKeySpecStage withSecretKeySpec(String var1);

        public InitializeStage withAlgorithm(String var1);

        public InitializeStage withAlgorithm(String var1, String var2);
    }
}

