/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.KeyStoreBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class KeyStoreDefaults {
    private KeyStoreDefaults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore() throws Exception {
        String NONE = "NONE";
        HashMap props = new HashMap();
        AccessController.doPrivileged(() -> {
            props.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
            props.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
            props.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
            props.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
            return null;
        });
        String defaultKeyStore = (String)props.get("keyStore");
        String defaultKeyStoreType = (String)props.get("keyStoreType");
        String defaultKeyStoreProvider = (String)props.get("keyStoreProvider");
        InputStream fs = null;
        KeyStore ks = null;
        char[] passwd = null;
        try {
            String defaultKeyStorePassword;
            if (defaultKeyStore.length() != 0 && !"NONE".equals(defaultKeyStore)) {
                FileSystem fileSystem = FileSystems.getDefault();
                fs = AccessController.doPrivileged(() -> Files.newInputStream(fileSystem.getPath(defaultKeyStore, new String[0]), new OpenOption[0]));
            }
            if ((defaultKeyStorePassword = (String)props.get("keyStorePasswd")).length() != 0) {
                passwd = defaultKeyStorePassword.toCharArray();
            }
            if (defaultKeyStoreType.length() != 0) {
                ks = defaultKeyStoreProvider.length() == 0 ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
                ks.load(fs, passwd);
            }
            KeyStore keyStore = ks == null ? KeyStoreBuilder.empty() : ks;
            return keyStore;
        }
        finally {
            if (fs != null) {
                fs.close();
                fs = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getCacertsKeyStore() throws Exception {
        String storeFileName = null;
        File storeFile = null;
        FileInputStream fis = null;
        HashMap props = new HashMap();
        String sep = File.separator;
        KeyStore ks = null;
        AccessController.doPrivileged(() -> {
            props.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
            props.put("javaHome", System.getProperty("java.home"));
            props.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
            props.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
            props.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
            return null;
        });
        try {
            storeFileName = (String)props.get("trustStore");
            if (!"NONE".equals(storeFileName)) {
                if (storeFileName != null) {
                    storeFile = new File(storeFileName);
                    fis = KeyStoreDefaults.getFileInputStream(storeFile);
                } else {
                    String javaHome = (String)props.get("javaHome");
                    storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "jssecacerts");
                    fis = KeyStoreDefaults.getFileInputStream(storeFile);
                    if (fis == null) {
                        storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "cacerts");
                        fis = KeyStoreDefaults.getFileInputStream(storeFile);
                    }
                }
                storeFileName = fis != null ? storeFile.getPath() : "No File Available, using empty keystore.";
            }
            String defaultTrustStoreType = (String)props.get("trustStoreType");
            String defaultTrustStoreProvider = (String)props.get("trustStoreProvider");
            if (defaultTrustStoreType.length() != 0) {
                ks = defaultTrustStoreProvider.length() == 0 ? KeyStore.getInstance(defaultTrustStoreType) : KeyStore.getInstance(defaultTrustStoreType, defaultTrustStoreProvider);
                char[] passwd = null;
                String defaultTrustStorePassword = (String)props.get("trustStorePasswd");
                if (defaultTrustStorePassword.length() != 0) {
                    passwd = defaultTrustStorePassword.toCharArray();
                }
                ks.load(fis, passwd);
                if (passwd != null) {
                    for (int i = 0; i < passwd.length; ++i) {
                        passwd[i] = '\u0000';
                    }
                }
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return ks == null ? KeyStoreBuilder.empty() : ks;
    }

    private static FileInputStream getFileInputStream(final File file) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    if (file.exists()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        });
    }
}

