/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DomainLoadStoreParameter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import org.slieb.throwables.SupplierWithThrowable;

public class KeyStoreBuilder {
    private KeyStoreBuilder() {
    }

    public static InstanceStage builder() {
        return new InstanceStageImpl();
    }

    public static KeyStore empty() {
        return KeyStoreBuilder.empty(KeyStore.getDefaultType());
    }

    public static KeyStore empty(String type) {
        try {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)() -> {
                KeyStore keyStore = KeyStore.getInstance(type);
                keyStore.load(null);
                return keyStore;
            })).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static KeyStore empty(String type, String provider) {
        try {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)() -> {
                KeyStore keyStore = KeyStore.getInstance(type, provider);
                keyStore.load(null);
                return keyStore;
            })).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class BuilderFinalImpl
    implements BuilderFinal {
        private final SupplierWithThrowable<KeyStore, Exception> supplier;

        BuilderFinalImpl(SupplierWithThrowable<KeyStore, Exception> supplier) {
            this.supplier = supplier;
        }

        @Override
        public KeyStore build() throws Exception {
            return (KeyStore)this.supplier.getWithThrowable();
        }
    }

    private static class PasswordStageImpl
    implements PasswordStage {
        private final SupplierWithThrowable<KeyStore, GeneralSecurityException> keyStore;
        private final SupplierWithThrowable<InputStream, Exception> inputStream;

        PasswordStageImpl(SupplierWithThrowable<KeyStore, GeneralSecurityException> keyStore, SupplierWithThrowable<InputStream, Exception> inputStream) {
            this.keyStore = keyStore;
            this.inputStream = inputStream;
        }

        @Override
        public BuilderFinal withPassword(char[] password) {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)() -> {
                KeyStore keyStore = (KeyStore)this.keyStore.getWithThrowable();
                keyStore.load((InputStream)this.inputStream.getWithThrowable(), password);
                return keyStore;
            }));
        }

        @Override
        public BuilderFinal withNoPassword() {
            return this.withPassword(null);
        }
    }

    private static class DomainParametersStageImpl
    implements DomainParametersStage {
        private final SupplierWithThrowable<KeyStore, GeneralSecurityException> supplier;

        DomainParametersStageImpl(SupplierWithThrowable<KeyStore, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuilderFinal withURIAndPasswordMap(URI uri, Map<String, KeyStore.ProtectionParameter> passwordMap) {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)() -> {
                KeyStore keyStore = (KeyStore)this.supplier.getWithThrowable();
                keyStore.load(new DomainLoadStoreParameter(uri, passwordMap));
                return keyStore;
            }));
        }
    }

    private static class ParametersStageImpl
    implements ParametersStage {
        private final SupplierWithThrowable<KeyStore, GeneralSecurityException> supplier;

        ParametersStageImpl(SupplierWithThrowable<KeyStore, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public PasswordStage withInputStream(InputStream inputStream) {
            return new PasswordStageImpl(this.supplier, (SupplierWithThrowable<InputStream, Exception>)((SupplierWithThrowable)() -> inputStream));
        }

        @Override
        public PasswordStage withPath(Path path) {
            return new PasswordStageImpl(this.supplier, (SupplierWithThrowable<InputStream, Exception>)((SupplierWithThrowable)() -> Files.newInputStream(path, new OpenOption[0])));
        }

        @Override
        public PasswordStage withFile(File file) {
            return this.withPath(file.toPath());
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<KeyStore, GeneralSecurityException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public ParametersStage withDefaultType() {
            return new ParametersStageImpl(this.getInstance().withDefaultType());
        }

        @Override
        public ParametersStage withType(String type) {
            return new ParametersStageImpl(this.getInstance().withType(type));
        }

        @Override
        public DomainParametersStage withDomainType() {
            return new DomainParametersStageImpl(this.getInstance().withType("DKS"));
        }

        @Override
        public ParametersStage withTypeAndProvider(String type, String provider) {
            return new ParametersStageImpl(this.getInstance().withTypeAndProvider(type, provider));
        }
    }

    public static interface BuilderFinal {
        public KeyStore build() throws Exception;
    }

    public static interface PasswordStage {
        public BuilderFinal withPassword(char[] var1);

        public BuilderFinal withNoPassword();
    }

    public static interface ParametersStage {
        public PasswordStage withInputStream(InputStream var1);

        public PasswordStage withPath(Path var1);

        public PasswordStage withFile(File var1);
    }

    public static interface DomainParametersStage {
        public BuilderFinal withURIAndPasswordMap(URI var1, Map<String, KeyStore.ProtectionParameter> var2);
    }

    public static interface InstanceStage {
        public ParametersStage withType(String var1);

        public ParametersStage withTypeAndProvider(String var1, String var2);

        public ParametersStage withDefaultType();

        public DomainParametersStage withDomainType();
    }
}

