/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.DHKeyPair;
import com.tersesystems.securitybuilder.DSAKeyPair;
import com.tersesystems.securitybuilder.ECKeyPair;
import com.tersesystems.securitybuilder.InstanceGenerator;
import com.tersesystems.securitybuilder.KeyPair;
import com.tersesystems.securitybuilder.RSAKeyPair;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.slieb.throwables.SupplierWithThrowable;

public class KeyPairCreator {
    public static InstanceStage creator() {
        return new InstanceStageImpl();
    }

    private static class FinalStageImpl<KP extends KeyPair<?, ?>>
    implements FinalStage<KP> {
        private final SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException> supplier;
        private final Function<java.security.KeyPair, KP> transform;

        FinalStageImpl(SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException> supplier, Function<java.security.KeyPair, KP> transform) {
            this.supplier = supplier;
            this.transform = transform;
        }

        @Override
        public KP create() throws GeneralSecurityException {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)this.supplier.get();
            return (KP)((KeyPair)this.transform.apply(keyPairGenerator.generateKeyPair()));
        }
    }

    private static class InitializeStageImpl<KP extends KeyPair<?, ?>>
    implements InitializeStage<KP> {
        private final SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException> supplier;
        private final Function<java.security.KeyPair, KP> transform;

        InitializeStageImpl(SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException> supplier, Function<java.security.KeyPair, KP> transform) {
            this.supplier = supplier;
            this.transform = transform;
        }

        @Override
        public FinalStage<KP> withKeySize(int keySize) {
            return new FinalStageImpl<KP>((SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyPairGenerator kpg = (KeyPairGenerator)this.supplier.getWithThrowable();
                kpg.initialize(keySize);
                return kpg;
            }), this.transform);
        }

        @Override
        public FinalStage<KP> withKeySizeAndSecureRandom(int keySize, SecureRandom sr) {
            return new FinalStageImpl<KP>((SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyPairGenerator kpg = (KeyPairGenerator)this.supplier.getWithThrowable();
                kpg.initialize(keySize, sr);
                return kpg;
            }), this.transform);
        }

        @Override
        public FinalStage<KP> withKeySpec(AlgorithmParameterSpec spec) {
            return new FinalStageImpl<KP>((SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyPairGenerator kpg = (KeyPairGenerator)this.supplier.getWithThrowable();
                kpg.initialize(spec);
                return kpg;
            }), this.transform);
        }

        @Override
        public FinalStage<KP> withKeySpecAndSecureRandom(AlgorithmParameterSpec spec, SecureRandom sr) {
            return new FinalStageImpl<KP>((SupplierWithThrowable<KeyPairGenerator, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyPairGenerator kpg = (KeyPairGenerator)this.supplier.getWithThrowable();
                kpg.initialize(spec, sr);
                return kpg;
            }), this.transform);
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<KeyPairGenerator, GeneralSecurityException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public <KP extends KeyPair<?, ?>> InitializeStage<KP> withAlgorithm(String algorithm) {
            return new InitializeStageImpl<KeyPair>(this.getInstance().withAlgorithm(algorithm), keyPair -> KeyPair.create(keyPair));
        }

        @Override
        public <KP extends KeyPair<?, ?>> InitializeStage<KP> withAlgorithm(String algorithm, String provider) {
            return new InitializeStageImpl<KeyPair>(this.getInstance().withAlgorithmAndProvider(algorithm, provider), keyPair -> KeyPair.create(keyPair));
        }

        @Override
        public InitializeStage<RSAKeyPair> withRSA() {
            return new InitializeStageImpl<RSAKeyPair>(this.getInstance().withAlgorithm("RSA"), RSAKeyPair::create);
        }

        @Override
        public InitializeStage<ECKeyPair> withEC() {
            return new InitializeStageImpl<ECKeyPair>(this.getInstance().withAlgorithm("EC"), ECKeyPair::create);
        }

        @Override
        public InitializeStage<DSAKeyPair> withDSA() {
            return new InitializeStageImpl<DSAKeyPair>(this.getInstance().withAlgorithm("DSA"), DSAKeyPair::create);
        }

        @Override
        public InitializeStage<DHKeyPair> withDH() {
            return new InitializeStageImpl<DHKeyPair>(this.getInstance().withAlgorithm("DH"), DHKeyPair::create);
        }
    }

    public static interface FinalStage<SKP extends KeyPair<?, ?>> {
        public SKP create() throws GeneralSecurityException;
    }

    public static interface InitializeStage<SKP extends KeyPair<?, ?>> {
        public FinalStage<SKP> withKeySize(int var1);

        public FinalStage<SKP> withKeySizeAndSecureRandom(int var1, SecureRandom var2);

        public FinalStage<SKP> withKeySpec(AlgorithmParameterSpec var1);

        public FinalStage<SKP> withKeySpecAndSecureRandom(AlgorithmParameterSpec var1, SecureRandom var2);
    }

    public static interface InstanceStage {
        public <KP extends KeyPair<?, ?>> InitializeStage<KP> withAlgorithm(String var1);

        public <KP extends KeyPair<?, ?>> InitializeStage<KP> withAlgorithm(String var1, String var2);

        public InitializeStage<RSAKeyPair> withRSA();

        public InitializeStage<ECKeyPair> withEC();

        public InitializeStage<DSAKeyPair> withDSA();

        public InitializeStage<DHKeyPair> withDH();
    }
}

