/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.TrustStore;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CertificateChainValidator {
    public static InitialStage validator() {
        return new InitialStageImpl();
    }

    private static class FinalStageImpl
    implements FinalStage {
        private final Supplier<Set<TrustAnchor>> anchorsSupplier;
        private final Supplier<List<? extends Certificate>> certSupplier;

        private FinalStageImpl(Supplier<Set<TrustAnchor>> anchorsSupplier, Supplier<List<? extends Certificate>> certSupplier) {
            this.anchorsSupplier = anchorsSupplier;
            this.certSupplier = certSupplier;
        }

        @Override
        public PKIXCertPathValidatorResult validate() throws GeneralSecurityException {
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
            PKIXParameters params = new PKIXParameters(this.anchorsSupplier.get());
            params.setRevocationEnabled(false);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            List<? extends Certificate> certificates = this.certSupplier.get();
            CertPath certPath = certificateFactory.generateCertPath(certificates.subList(0, certificates.size() - 1));
            return (PKIXCertPathValidatorResult)cpv.validate(certPath, params);
        }
    }

    private static class CertificatesStageImpl
    implements CertificatesStage {
        private final Supplier<Set<TrustAnchor>> anchorsSupplier;

        CertificatesStageImpl(Supplier<Set<TrustAnchor>> anchorsSupplier) {
            this.anchorsSupplier = anchorsSupplier;
        }

        @Override
        public FinalStage withCertificates(Certificate[] certificates) {
            return new FinalStageImpl(this.anchorsSupplier, () -> Arrays.asList(certificates));
        }

        @Override
        public FinalStage withCertificates(List<? extends Certificate> certificates) {
            return new FinalStageImpl(this.anchorsSupplier, () -> certificates);
        }

        @Override
        public FinalStage withCertificates(Supplier<List<? extends Certificate>> supplier) {
            return new FinalStageImpl(this.anchorsSupplier, supplier);
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public CertificatesStage withTrustedCertificates(Certificate ... certificates) {
            return new CertificatesStageImpl(() -> Arrays.stream(certificates).map(certificate -> new TrustAnchor((X509Certificate)certificate, null)).collect(Collectors.toSet()));
        }

        @Override
        public CertificatesStage withTrustStore(TrustStore trustStore) {
            return new CertificatesStageImpl(() -> trustStore.entrySet().stream().map(entry -> {
                Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry.getValue()).getTrustedCertificate();
                return new TrustAnchor((X509Certificate)certificate, null);
            }).collect(Collectors.toSet()));
        }

        @Override
        public CertificatesStage withKeyStore(KeyStore keyStore) {
            return this.withTrustStore(TrustStore.create(keyStore));
        }

        @Override
        public CertificatesStage withAnchors(TrustAnchor ... anchors) {
            return new CertificatesStageImpl(() -> Arrays.stream(anchors).collect(Collectors.toSet()));
        }

        @Override
        public CertificatesStage withAnchors(Set<TrustAnchor> anchors) {
            return new CertificatesStageImpl(() -> anchors);
        }

        @Override
        public CertificatesStage withAnchors(Supplier<Set<TrustAnchor>> supplier) {
            return new CertificatesStageImpl(supplier);
        }
    }

    public static interface FinalStage {
        public PKIXCertPathValidatorResult validate() throws GeneralSecurityException;
    }

    public static interface CertificatesStage {
        public FinalStage withCertificates(Certificate[] var1);

        public FinalStage withCertificates(List<? extends Certificate> var1);

        public FinalStage withCertificates(Supplier<List<? extends Certificate>> var1);
    }

    public static interface InitialStage {
        public CertificatesStage withTrustedCertificates(Certificate ... var1);

        public CertificatesStage withTrustStore(TrustStore var1);

        public CertificatesStage withKeyStore(KeyStore var1);

        public CertificatesStage withAnchors(TrustAnchor ... var1);

        public CertificatesStage withAnchors(Set<TrustAnchor> var1);

        public CertificatesStage withAnchors(Supplier<Set<TrustAnchor>> var1);
    }
}

