/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.RuntimeKeyStoreException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractKeyStore<T extends KeyStore.Entry>
implements Map<String, T> {
    protected final KeyStore.Builder builder;

    protected AbstractKeyStore(KeyStore.Builder builder) {
        this.builder = builder;
    }

    public KeyStore getKeyStore() {
        try {
            return this.builder.getKeyStore();
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    public KeyStore.ProtectionParameter protectionParameter(String alias) {
        try {
            return this.builder.getProtectionParameter(alias);
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    @Override
    public int size() {
        try {
            return this.getKeyStore().size();
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.getKeyStore().size() == 0;
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String alias = (String)key;
            try {
                return this.getKeyStore().containsAlias(alias);
            }
            catch (KeyStoreException e) {
                throw new RuntimeKeyStoreException(e);
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        KeyStore.Entry entry = (KeyStore.Entry)value;
        return this.values().stream().anyMatch(thisEntry -> thisEntry.equals(entry));
    }

    @Override
    public T get(Object key) {
        if (key instanceof String) {
            String alias = (String)key;
            Objects.requireNonNull(alias, "Null alias!");
            try {
                return (T)this.getKeyStore().getEntry(alias, this.protectionParameter(alias));
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeKeyStoreException(e);
            }
        }
        return null;
    }

    @Override
    public T put(String alias, T value) {
        try {
            Objects.requireNonNull(alias, "Null alias!");
            KeyStore.ProtectionParameter protectionParameter = this.protectionParameter(alias);
            if (protectionParameter == null) {
                throw new IllegalStateException(String.format("Null protection parameter found with alias %s", alias));
            }
            this.getKeyStore().setEntry(alias, (KeyStore.Entry)value, protectionParameter);
            return value;
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    @Override
    public T remove(Object key) {
        if (key instanceof String) {
            String alias = (String)key;
            if (this.containsKey(key)) {
                try {
                    KeyStore.Entry entry = this.getKeyStore().getEntry(alias, this.protectionParameter(alias));
                    this.getKeyStore().deleteEntry(alias);
                    return (T)entry;
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                    throw new RuntimeKeyStoreException(e);
                }
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        map.forEach((alias, privateKey) -> {
            try {
                this.getKeyStore().setEntry((String)alias, (KeyStore.Entry)privateKey, this.protectionParameter((String)alias));
            }
            catch (KeyStoreException e) {
                throw new RuntimeKeyStoreException(e);
            }
        });
    }

    @Override
    public void clear() {
        this.keySet().forEach((? super T object) -> this.remove(object));
    }

    @Override
    public Set<String> keySet() {
        try {
            return new HashSet<String>(Collections.list(this.getKeyStore().aliases()));
        }
        catch (KeyStoreException e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    @Override
    public Collection<T> values() {
        return this.keySet().stream().map(object -> this.get(object)).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.keySet().stream().map(alias -> {
            try {
                KeyStore.Entry privateKeyEntry = this.getKeyStore().getEntry((String)alias, this.protectionParameter((String)alias));
                return new MyEntry(this, alias, privateKeyEntry);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeKeyStoreException(e);
            }
        }).collect(Collectors.toSet());
    }

    static class MyEntry
    implements Map.Entry<String, T> {
        private final String alias;
        private final T keyEntry;
        final /* synthetic */ AbstractKeyStore this$0;

        MyEntry(String alias, T keyEntry) {
            this.this$0 = this$0;
            this.alias = alias;
            this.keyEntry = keyEntry;
        }

        @Override
        public String getKey() {
            return this.alias;
        }

        @Override
        public T getValue() {
            return this.keyEntry;
        }

        @Override
        public T setValue(T value) {
            try {
                this.this$0.getKeyStore().setEntry(this.alias, (KeyStore.Entry)value, this.this$0.protectionParameter(this.alias));
            }
            catch (KeyStoreException e) {
                throw new RuntimeKeyStoreException(e);
            }
            return value;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MyEntry) {
                MyEntry o = (MyEntry)obj;
                return o.keyEntry.equals(this.keyEntry) && o.alias.equals(this.alias);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.alias, this.keyEntry);
        }
    }
}

