/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.amazonaws.DefaultRequest;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.http.HttpMethodName;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.msk.auth.iam.internals.AuthenticationRequestParams;
import software.amazon.msk.auth.iam.internals.PayloadGenerationException;
import software.amazon.msk.auth.iam.internals.SignedPayloadGenerator;

class AWS4SignedPayloadGenerator
implements SignedPayloadGenerator {
    private static final Logger log = LoggerFactory.getLogger(AWS4SignedPayloadGenerator.class);
    private static final String ACTION_KEY = "Action";
    private static final String ACTION_VALUE = "kafka-cluster:Connect";
    private static final String VERSION_KEY = "version";
    private static final String USER_AGENT_KEY = "user-agent";
    private static final int EXPIRY_DURATION_MINUTES = 15;

    AWS4SignedPayloadGenerator() {
    }

    @Override
    public byte[] signedPayload(@NonNull AuthenticationRequestParams params) throws PayloadGenerationException {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        AWS4Signer signer = this.getConfiguredSigner(params);
        DefaultRequest request = this.createRequestForSigning(params);
        signer.presignRequest((SignableRequest)request, params.getAwsCredentials(), this.getExpiryDate());
        try {
            return this.toPayloadBytes(request, params);
        }
        catch (IOException e) {
            throw new PayloadGenerationException("Failure to create authentication payload ", e);
        }
    }

    private DefaultRequest createRequestForSigning(AuthenticationRequestParams params) {
        DefaultRequest request = new DefaultRequest(params.getServiceScope());
        request.setHttpMethod(HttpMethodName.GET);
        try {
            request.setEndpoint(new URI("kafka://" + params.getHost()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse host URI", e);
        }
        request.addParameter(ACTION_KEY, ACTION_VALUE);
        return request;
    }

    private java.util.Date getExpiryDate() {
        return Date.from(Instant.ofEpochMilli(Instant.now().toEpochMilli() + TimeUnit.MINUTES.toMillis(15L)));
    }

    private AWS4Signer getConfiguredSigner(AuthenticationRequestParams params) {
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setServiceName(params.getServiceScope());
        aws4Signer.setRegionName(params.getRegion().getName());
        if (log.isDebugEnabled()) {
            log.debug("Signer configured for {} service and {} region", (Object)aws4Signer.getServiceName(), (Object)aws4Signer.getRegionName());
        }
        return aws4Signer;
    }

    private byte[] toPayloadBytes(DefaultRequest request, AuthenticationRequestParams params) throws IOException {
        Map<String, String> keyValueMap = this.toKeyValueMap(request, params);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsBytes(keyValueMap);
    }

    private Map<String, String> toKeyValueMap(DefaultRequest request, AuthenticationRequestParams params) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        Set parameterEntries = request.getParameters().entrySet();
        parameterEntries.stream().forEach(e -> keyValueMap.put(((String)e.getKey()).toLowerCase(), this.generateParameterValue((String)e.getKey(), (List)e.getValue())));
        keyValueMap.put(VERSION_KEY, params.getVersion());
        keyValueMap.put(USER_AGENT_KEY, params.getUserAgent());
        Set headerEntries = request.getHeaders().entrySet();
        headerEntries.stream().forEach(e -> {
            String cfr_ignored_0 = (String)keyValueMap.put(((String)e.getKey()).toLowerCase(), (String)e.getValue());
        });
        return keyValueMap;
    }

    private String generateParameterValue(String key, List<String> value) {
        if (value.isEmpty()) {
            return "";
        }
        if (value.size() > 1) {
            if (!"X-Amz-SignedHeaders".equals(key)) {
                throw new IllegalArgumentException("Unexpected number of arguments " + value.size() + " for query parameter " + key);
            }
            StringJoiner joiner = new StringJoiner(";");
            value.stream().forEach(joiner::add);
            return joiner.toString();
        }
        return value.get(0);
    }
}

