/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.utils;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import io.conduktor.schemaregistry.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.apache.avro.Schema;
import org.apache.kafka.common.errors.SerializationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lio/conduktor/utils/KafkaAvroHelper;", "", "()V", "fetchSchemaFromAvroData", "Larrow/core/Either;", "", "Lkotlin/Pair;", "", "Lorg/apache/avro/Schema;", "payload", "", "schemaRegistry", "Lio/conduktor/schemaregistry/SchemaRegistryConfig;", "getByteBuffer", "Lorg/apache/kafka/common/errors/SerializationException;", "Ljava/nio/ByteBuffer;", "getSchemaId", "desktop"})
public final class KafkaAvroHelper {
    @NotNull
    public static final KafkaAvroHelper INSTANCE = new KafkaAvroHelper();

    private KafkaAvroHelper() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Either<Throwable, Pair<Integer, Schema>> fetchSchemaFromAvroData(@NotNull byte[] payload, @NotNull SchemaRegistryConfig schemaRegistry2) {
        Either.Companion companion;
        void $this$flatMap$iv;
        CachedSchemaRegistryClient client2 = new CachedSchemaRegistryClient(schemaRegistry2.getUrl(), 10, schemaRegistry2.getSchemaRegistryAllAttributes());
        Either<SerializationException, Integer> either2 = this.getSchemaId(payload);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        if (var6_6 instanceof Either.Right) {
            Either either3;
            int schemaId2 = ((Number)((Either.Right)$this$flatMap$iv).getValue()).intValue();
            boolean bl = false;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl2 = false;
                either3 = EitherKt.right((Object)client2.getById(schemaId2));
            }
            catch (Throwable t$iv) {
                either3 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            this_$iv = either3;
            boolean $i$f$map = false;
            Either.Companion $this$flatMap$iv$iv = this_$iv;
            boolean $i$f$flatMap2 = false;
            Either.Companion companion2 = $this$flatMap$iv$iv;
            if (companion2 instanceof Either.Right) {
                Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                boolean bl3 = false;
                Schema it = (Schema)it$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)schemaId2, (Object)it);
                companion = (Either)new Either.Right((Object)pair);
                return companion;
            } else {
                if (!(companion2 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                companion = $this$flatMap$iv$iv;
            }
            return companion;
        }
        if (!(var6_6 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
        companion = $this$flatMap$iv;
        return companion;
    }

    @NotNull
    public final Either<SerializationException, Integer> getSchemaId(@NotNull byte[] payload) {
        Either either2;
        Either this_$iv = this.getByteBuffer(payload);
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either3 = $this$flatMap$iv$iv;
        if (either3 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            ByteBuffer it = (ByteBuffer)it$iv;
            boolean bl2 = false;
            Integer n = it.getInt();
            either2 = (Either)new Either.Right((Object)n);
        } else if (either3 instanceof Either.Left) {
            either2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either2;
    }

    private final Either<SerializationException, ByteBuffer> getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        return buffer.get() != 0 ? (Either)new Either.Left((Object)new SerializationException("Unknown magic byte!")) : (Either)new Either.Right((Object)buffer);
    }
}

