/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.utils;

import io.conduktor.utils.OS;
import java.lang.reflect.Method;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/conduktor/utils/BrowserOpener;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "openBrowserNative", "", "uri", "", "desktop"})
public final class BrowserOpener {
    @NotNull
    public static final BrowserOpener INSTANCE = new BrowserOpener();
    private static final Logger logger = LoggerFactory.getLogger(BrowserOpener.class);

    private BrowserOpener() {
    }

    public final void openBrowserNative(@NotNull String uri) {
        if (OS.INSTANCE.isMac()) {
            try {
                logger.debug("Invoking com.apple.eio.FileManager.openURL " + uri);
                Object[] objectArray = new Class[]{String.class};
                Method method = Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", (Class<?>[])objectArray);
                objectArray = new Object[]{uri};
                method.invoke(null, objectArray);
            }
            catch (Exception e) {
                String cmd = "open " + uri;
                logger.debug("Executing: " + cmd);
                Runtime.getRuntime().exec(cmd);
            }
        } else if (OS.INSTANCE.isWindows()) {
            String cmd = "rundll32 url.dll,FileProtocolHandler " + uri;
            logger.debug("Executing: " + cmd);
            Runtime.getRuntime().exec(cmd);
        } else {
            String cmd = "xdg-open " + uri;
            logger.debug("Executing: " + cmd);
            Runtime.getRuntime().exec(cmd);
        }
    }
}

