/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.security;

import arrow.core.Either;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import io.conduktor.JavaFxExtensionsKt;
import io.conduktor.analytics.tracking.AnalyticsTracker;
import io.conduktor.analytics.tracking.Application;
import io.conduktor.analytics.tracking.Links;
import io.conduktor.analytics.tracking.TrackableFragment;
import io.conduktor.app.Conduktor;
import io.conduktor.config.ConfigurationExtension;
import io.conduktor.controllers.CertificateConfigJson;
import io.conduktor.controllers.NetworkOptionsController;
import io.conduktor.controllers.NetworkOptionsJson;
import io.conduktor.kjavafx.KUnion;
import io.conduktor.kjavafx.kComponents;
import io.conduktor.kjavafx.kExtensions;
import io.conduktor.security.CertificateManager;
import io.conduktor.security.Proxy;
import io.conduktor.security.ProxyJson;
import io.conduktor.security.SecuritySetupDialog;
import io.conduktor.styles.ConduktorStyles;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.javafx.JavaFxDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tornadofx.CSSKt;
import tornadofx.Component;
import tornadofx.ConfigProperties;
import tornadofx.ControlsKt;
import tornadofx.CssRule;
import tornadofx.DialogsKt;
import tornadofx.FXKt;
import tornadofx.Field;
import tornadofx.Fieldset;
import tornadofx.FileChooserMode;
import tornadofx.Form;
import tornadofx.FormsKt;
import tornadofx.ItemControlsKt;
import tornadofx.JsonModel;
import tornadofx.LayoutsKt;
import tornadofx.LibKt;
import tornadofx.NodesKt;
import tornadofx.Scope;
import tornadofx.TabPaneKt;
import tornadofx.UIComponent;
import tornadofx.ViewModel;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lio/conduktor/security/SecuritySetupDialog;", "Lio/conduktor/analytics/tracking/TrackableFragment;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "certificates", "Ljavafx/collections/ObservableList;", "", "kotlin.jvm.PlatformType", "cm", "Lio/conduktor/security/CertificateManager;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "dirtyCertificates", "Ljavafx/beans/property/SimpleBooleanProperty;", "logger", "Lorg/slf4j/Logger;", "networkOptionsController", "Lio/conduktor/controllers/NetworkOptionsController;", "getNetworkOptionsController", "()Lio/conduktor/controllers/NetworkOptionsController;", "networkOptionsController$delegate", "Lkotlin/properties/ReadOnlyProperty;", "networkSettingsModel", "Lio/conduktor/controllers/NetworkOptionsJson;", "proxyModel", "Lio/conduktor/security/ProxyJson;", "root", "Ljavafx/scene/layout/BorderPane;", "getRoot", "()Ljavafx/scene/layout/BorderPane;", "importCertificate", "", "refreshList", "desktop"})
public final class SecuritySetupDialog
extends TrackableFragment
implements CoroutineScope {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final /* synthetic */ CoroutineScope $$delegate_0;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private final ReadOnlyProperty networkOptionsController$delegate;
    @NotNull
    private final ProxyJson proxyModel;
    private final ObservableList<String> certificates;
    @Nullable
    private final CertificateManager cm;
    @NotNull
    private final SimpleBooleanProperty dirtyCertificates;
    @NotNull
    private final NetworkOptionsJson networkSettingsModel;
    @NotNull
    private final BorderPane root;

    /*
     * WARNING - void declaration
     */
    public SecuritySetupDialog() {
        super(Application.Security.INSTANCE, "Conduktor Security Configuration", null, 4, null);
        void $this$root_u24lambda_u2d2_u24lambda_u2d1;
        void $this$root_u24lambda_u2d2;
        BorderPane borderPane;
        ProxyJson proxyJson;
        JsonModel jsonModel2;
        JsonObject $this$toModel$iv$iv;
        BorderPane this_$iv;
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)JavaFxDispatcherKt.getJavaFx((Dispatchers)Dispatchers.INSTANCE)));
        Scope overrideScope$iv = ((Component)this).getScope();
        Map params$iv = null;
        boolean $i$f$inject = false;
        this.networkOptionsController$delegate = (ReadOnlyProperty)new ReadOnlyProperty<Component, NetworkOptionsController>(overrideScope$iv, params$iv){
            final /* synthetic */ Scope $overrideScope;
            final /* synthetic */ Map $params;
            {
                this.$overrideScope = $captured_local_variable$0;
                this.$params = $captured_local_variable$1;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public NetworkOptionsController getValue(@NotNull Component thisRef, @NotNull KProperty<?> property) {
                void scope$iv;
                Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
                Intrinsics.checkParameterIsNotNull(property, (String)"property");
                Scope scope = this.$overrideScope;
                Map params$iv = this.$params;
                boolean $i$f$find = false;
                return FXKt.find((KClass)Reflection.getOrCreateKotlinClass(NetworkOptionsController.class), (Scope)scope$iv, (Map)params$iv);
            }
        };
        params$iv = this.getApp().getConfig();
        String key$iv = "proxy";
        boolean $i$f$jsonModel22 = false;
        JsonObject jsonObject = this_$iv.jsonObject(key$iv);
        if (jsonObject != null) {
            $this$toModel$iv$iv = jsonObject;
            boolean $i$f$toModel = false;
            JsonModel model$iv$iv = (JsonModel)ProxyJson.class.newInstance();
            model$iv$iv.updateModel($this$toModel$iv$iv);
            JsonModel jsonModel3 = model$iv$iv;
            jsonModel2 = jsonModel3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonModel3, (String)"model");
        } else {
            jsonModel2 = null;
        }
        if ((proxyJson = (ProxyJson)jsonModel2) == null) {
            proxyJson = new ProxyJson(Proxy.Companion.getDefault());
        }
        this.proxyModel = proxyJson;
        this.certificates = FXCollections.observableArrayList();
        this.cm = Conduktor.Companion.getCertificateManager();
        this.dirtyCertificates = new SimpleBooleanProperty(false);
        this.networkSettingsModel = (NetworkOptionsJson)this.getNetworkOptionsController().getNetworkOptions().copy();
        this.refreshList();
        LibKt.onChange((ObservableBooleanValue)((ObservableBooleanValue)((CertificateConfigJson)this.networkSettingsModel.getCertificateConfig().getValue()).getAllowNonTrusted()), (Function1)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                dirtyCertificates.setValue(Boolean.valueOf(true));
            }
        }));
        this_$iv = borderPane = new BorderPane();
        SecuritySetupDialog securitySetupDialog = this;
        boolean bl = false;
        TabPane $i$f$jsonModel22 = new TabPane[]{ConduktorStyles.Companion.getCard()};
        CSSKt.addClass((Styleable)((Styleable)$this$root_u24lambda_u2d2), (CssRule[])$i$f$jsonModel22);
        LayoutsKt.setPaddingAll((Region)((Region)$this$root_u24lambda_u2d2), (Number)10);
        $this$root_u24lambda_u2d2.setPrefWidth(600.0);
        $i$f$jsonModel22 = new TabPane();
        $this$toModel$iv$iv = $i$f$jsonModel22;
        void var6_10 = $this$root_u24lambda_u2d2;
        boolean bl2 = false;
        $this$root_u24lambda_u2d2_u24lambda_u2d1.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        TabPaneKt.tab$default((TabPane)$this$root_u24lambda_u2d2_u24lambda_u2d1, (String)"Proxy", null, (Function1)((Function1)new Function1<Tab, Unit>(this){
            final /* synthetic */ SecuritySetupDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Tab $this$tab) {
                LayoutsKt.vbox$default((EventTarget)((EventTarget)$this$tab), null, null, (Function1)((Function1)new Function1<VBox, Unit>(this.this$0){
                    final /* synthetic */ SecuritySetupDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull VBox $this$vbox) {
                        FormsKt.form((EventTarget)((EventTarget)$this$vbox), (Function1)((Function1)new Function1<Form, Unit>(this.this$0){
                            final /* synthetic */ SecuritySetupDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Form $this$form) {
                                NodesKt.plusAssign((EventTarget)((EventTarget)$this$form), (Node)((Node)kComponents.klabel$default(kComponents.INSTANCE, new KUnion.Raw<String>("Consider *restarting* Conduktor after changing proxy configuration."), null, KUnion.Companion.fa(FontAwesomeIcon.INFO_CIRCLE), 2, null)));
                                NodesKt.plusAssign((EventTarget)((EventTarget)$this$form), (Node)((Node)kComponents.INSTANCE.separatorV()));
                                FormsKt.fieldset$default((EventTarget)((EventTarget)$this$form), null, null, null, null, (Function1)((Function1)new Function1<Fieldset, Unit>(this.this$0){
                                    final /* synthetic */ SecuritySetupDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Fieldset $this$fieldset) {
                                        FormsKt.field$default((EventTarget)((EventTarget)$this$fieldset), (String)"Auto-detect", null, (boolean)false, (Function1)((Function1)new Function1<Field, Unit>(this.this$0){
                                            final /* synthetic */ SecuritySetupDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Field $this$field) {
                                                ControlsKt.checkbox$default((EventTarget)((EventTarget)$this$field), null, (Property)((Property)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getAutoDetect()), null, (int)4, null);
                                            }
                                        }), (int)6, null);
                                        FormsKt.field$default((EventTarget)((EventTarget)$this$fieldset), (String)"Proxy Server", null, (boolean)false, (Function1)((Function1)new Function1<Field, Unit>(this.this$0){
                                            final /* synthetic */ SecuritySetupDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final void invoke(@NotNull Field $this$field) {
                                                void $this$spinner$iv;
                                                Node node;
                                                void editable$iv;
                                                void amountToStepBy$iv;
                                                void initialValue$iv;
                                                void max$iv;
                                                void min$iv;
                                                void property$iv;
                                                ControlsKt.textfield((EventTarget)((EventTarget)$this$field), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getHost()), (Function1)((Function1)new Function1<TextField, Unit>(this.this$0){
                                                    final /* synthetic */ SecuritySetupDialog this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(1);
                                                    }

                                                    public final void invoke(@NotNull TextField $this$textfield) {
                                                        NodesKt.enableWhen((Node)((Node)$this$textfield), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getAutoDetect().not()));
                                                    }
                                                }));
                                                ControlsKt.label$default((EventTarget)((EventTarget)$this$field), (String)":", null, null, (int)6, null);
                                                EventTarget eventTarget = (EventTarget)$this$field;
                                                boolean bl = true;
                                                int n = 65535;
                                                int n2 = 8080;
                                                boolean bl2 = true;
                                                boolean bl3 = true;
                                                Property property = (Property)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getPort();
                                                boolean bl4 = true;
                                                Function1 op$iv = (Function1)new Function1<Spinner<Number>, Unit>(this.this$0){
                                                    final /* synthetic */ SecuritySetupDialog this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(1);
                                                    }

                                                    public final void invoke(@NotNull Spinner<Number> $this$spinner) {
                                                        NodesKt.enableWhen((Node)((Node)$this$spinner), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getAutoDetect().not()));
                                                    }
                                                };
                                                boolean $i$f$spinner = false;
                                                Spinner spinner$iv = null;
                                                if (!(property$iv instanceof IntegerProperty) || property$iv instanceof DoubleProperty || property$iv instanceof FloatProperty) {
                                                    // empty if block
                                                }
                                                boolean isInt$iv = true;
                                                spinner$iv = new Spinner((int)min$iv, (int)max$iv, (int)initialValue$iv, (int)amountToStepBy$iv);
                                                if (property$iv != null) {
                                                    spinner$iv.getValueFactory().valueProperty().bindBidirectional((Property)property$iv);
                                                    ObjectProperty objectProperty = spinner$iv.getValueFactory().valueProperty();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)objectProperty, (String)"spinner.valueFactory.valueProperty()");
                                                    ViewModel.Companion.register((ObservableValue)objectProperty, (ObservableValue)property$iv);
                                                }
                                                spinner$iv.setEditable((boolean)editable$iv);
                                                spinner$iv.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(spinner$iv){
                                                    final /* synthetic */ Spinner $spinner;
                                                    {
                                                        this.$spinner = spinner2;
                                                    }

                                                    public final void handle(ScrollEvent event) {
                                                        ScrollEvent scrollEvent = event;
                                                        Intrinsics.checkExpressionValueIsNotNull((Object)scrollEvent, (String)"event");
                                                        if (scrollEvent.getDeltaY() > 0.0) {
                                                            this.$spinner.increment();
                                                        }
                                                        if (event.getDeltaY() < 0.0) {
                                                            this.$spinner.decrement();
                                                        }
                                                    }
                                                });
                                                spinner$iv.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(spinner$iv){
                                                    final /* synthetic */ Spinner $spinner;
                                                    {
                                                        this.$spinner = spinner2;
                                                    }

                                                    public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean newValue) {
                                                        if (!newValue.booleanValue()) {
                                                            this.$spinner.increment(0);
                                                        }
                                                    }
                                                });
                                                Node $this$attachTo$iv$iv = (Node)spinner$iv;
                                                boolean $i$f$attachTo = false;
                                                boolean $i$f$opcr = false;
                                                Node $this$apply$iv$iv$iv = node = $this$attachTo$iv$iv;
                                                boolean bl5 = false;
                                                FXKt.addChildIfPossible$default((EventTarget)$this$spinner$iv, (Node)$this$apply$iv$iv$iv, null, (int)2, null);
                                                op$iv.invoke((Object)$this$apply$iv$iv$iv);
                                                Spinner cfr_ignored_0 = (Spinner)node;
                                            }
                                        }), (int)6, null);
                                        FormsKt.field$default((EventTarget)((EventTarget)$this$fieldset), (String)"Username", null, (boolean)false, (Function1)((Function1)new Function1<Field, Unit>(this.this$0){
                                            final /* synthetic */ SecuritySetupDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Field $this$field) {
                                                ControlsKt.textfield((EventTarget)((EventTarget)$this$field), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getUser()), (Function1)((Function1)new Function1<TextField, Unit>(this.this$0){
                                                    final /* synthetic */ SecuritySetupDialog this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(1);
                                                    }

                                                    public final void invoke(@NotNull TextField $this$textfield) {
                                                        $this$textfield.setPromptText("(optional)");
                                                        NodesKt.enableWhen((Node)((Node)$this$textfield), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getAutoDetect().not()));
                                                    }
                                                }));
                                            }
                                        }), (int)6, null);
                                        FormsKt.field$default((EventTarget)((EventTarget)$this$fieldset), (String)"Password", null, (boolean)false, (Function1)((Function1)new Function1<Field, Unit>(this.this$0){
                                            final /* synthetic */ SecuritySetupDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Field $this$field) {
                                                ControlsKt.passwordfield((EventTarget)((EventTarget)$this$field), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getPassword()), (Function1)((Function1)new Function1<PasswordField, Unit>(this.this$0){
                                                    final /* synthetic */ SecuritySetupDialog this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(1);
                                                    }

                                                    public final void invoke(@NotNull PasswordField $this$passwordfield) {
                                                        $this$passwordfield.setPromptText("(optional)");
                                                        NodesKt.enableWhen((Node)((Node)$this$passwordfield), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getAutoDetect().not()));
                                                    }
                                                }));
                                            }
                                        }), (int)6, null);
                                    }
                                }), (int)15, null);
                            }
                        }));
                        FormsKt.form((EventTarget)((EventTarget)$this$vbox), (Function1)((Function1)new Function1<Form, Unit>(this.this$0){
                            final /* synthetic */ SecuritySetupDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Form $this$form) {
                                FormsKt.fieldset$default((EventTarget)((EventTarget)$this$form), null, null, (Orientation)Orientation.VERTICAL, null, (Function1)((Function1)new Function1<Fieldset, Unit>(this.this$0){
                                    final /* synthetic */ SecuritySetupDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Fieldset $this$fieldset) {
                                        FormsKt.field$default((EventTarget)((EventTarget)$this$fieldset), (String)"Do not use proxy for these hosts (separated by commas)", null, (boolean)false, (Function1)((Function1)new Function1<Field, Unit>(this.this$0){
                                            final /* synthetic */ SecuritySetupDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Field $this$field) {
                                                ControlsKt.textarea((EventTarget)((EventTarget)$this$field), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getNonProxyHosts()), (Function1)((Function1)new Function1<TextArea, Unit>(this.this$0){
                                                    final /* synthetic */ SecuritySetupDialog this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(1);
                                                    }

                                                    public final void invoke(@NotNull TextArea $this$textarea) {
                                                        $this$textarea.setPrefRowCount(3);
                                                        NodesKt.enableWhen((Node)((Node)$this$textarea), (ObservableValue)((ObservableValue)SecuritySetupDialog.access$getProxyModel$p(this.this$0).getAutoDetect().not()));
                                                        $this$textarea.setPromptText("eg: *.foo.com|localhost");
                                                    }
                                                }));
                                            }
                                        }), (int)6, null);
                                    }
                                }), (int)11, null);
                            }
                        }));
                    }
                }), (int)3, null);
            }
        }), (int)2, null);
        TabPaneKt.tab$default((TabPane)$this$root_u24lambda_u2d2_u24lambda_u2d1, (String)"Trusted Certificates", null, (Function1)((Function1)new Function1<Tab, Unit>(this){
            final /* synthetic */ SecuritySetupDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Tab $this$tab) {
                LayoutsKt.vbox$default((EventTarget)((EventTarget)$this$tab), (Number)5.0, null, (Function1)((Function1)new Function1<VBox, Unit>(this.this$0){
                    final /* synthetic */ SecuritySetupDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull VBox $this$vbox) {
                        NodesKt.setVgrow((Node)((Node)$this$vbox), (Priority)Priority.ALWAYS);
                        ControlsKt.checkbox$default((EventTarget)((EventTarget)$this$vbox), (String)"Allow non-trusted certificates automatically", (Property)((Property)((CertificateConfigJson)SecuritySetupDialog.access$getNetworkSettingsModel$p(this.this$0).getCertificateConfig().getValue()).getAllowNonTrusted()), null, (int)4, null);
                        ItemControlsKt.listview((EventTarget)((EventTarget)$this$vbox), (ObservableList)SecuritySetupDialog.access$getCertificates$p(this.this$0), (Function1)((Function1)new Function1<ListView<String>, Unit>(this.this$0){
                            final /* synthetic */ SecuritySetupDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull ListView<String> $this$listview) {
                                void $this$invoke_u24lambda_u2d0;
                                Node[] nodeArray = kExtensions.INSTANCE.wrap((Labeled)new Label("Add self-signed certificates, or signed by your company CA, within Conduktor trust store (.crt, .pem)"));
                                Label label2 = (Label)nodeArray;
                                kComponents kComponents2 = kComponents.INSTANCE;
                                ListView<String> listView = $this$listview;
                                boolean bl = false;
                                $this$invoke_u24lambda_u2d0.setMaxWidth(400.0);
                                $this$invoke_u24lambda_u2d0.setTextAlignment(TextAlignment.CENTER);
                                Unit unit = Unit.INSTANCE;
                                Node node = (Node)nodeArray;
                                nodeArray = new Node[]{(Node)kComponents.kbuttonMain$default(kComponents.INSTANCE, new KUnion.Raw<String>("Import"), null, null, (Function1)new Function1<Button, Unit>(this.this$0){
                                    final /* synthetic */ SecuritySetupDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Button $this$kbuttonMain) {
                                        SecuritySetupDialog.access$importCertificate(this.this$0);
                                    }
                                }, 6, null)};
                                listView.setPlaceholder((Node)kComponents2.kvbox(node, nodeArray));
                                nodeArray = new CssRule[]{ConduktorStyles.Companion.getHoverListView(), ConduktorStyles.Companion.getWithSelection()};
                                CSSKt.addClass((Styleable)((Styleable)$this$listview), (CssRule[])nodeArray);
                                $this$listview.setCellFactory(kExtensions.ktemplate$default(kExtensions.INSTANCE, (Function2)new Function2<ListCell<String>, String, Node>(this.this$0){
                                    final /* synthetic */ SecuritySetupDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2);
                                    }

                                    @NotNull
                                    public final Node invoke(@NotNull ListCell<String> $this$ktemplate, String cell) {
                                        HBox hBox = new HBox(5.0);
                                        SecuritySetupDialog securitySetupDialog = this.this$0;
                                        HBox $this$invoke_u24lambda_u2d0 = hBox;
                                        boolean bl = false;
                                        $this$invoke_u24lambda_u2d0.setAlignment(Pos.CENTER_LEFT);
                                        ControlsKt.button$default((EventTarget)((EventTarget)$this$invoke_u24lambda_u2d0), null, (Node)((Node)new FontAwesomeIconView(FontAwesomeIcon.TRASH)), (Function1)((Function1)new Function1<Button, Unit>(securitySetupDialog, cell){
                                            final /* synthetic */ SecuritySetupDialog this$0;
                                            final /* synthetic */ String $cell;
                                            {
                                                this.this$0 = $receiver;
                                                this.$cell = $cell;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Button $this$button) {
                                                CssRule[] cssRuleArray = new CssRule[]{ConduktorStyles.Companion.getMediumButton(), ConduktorStyles.Companion.getWarningButton()};
                                                CSSKt.addClass((Styleable)((Styleable)$this$button), (CssRule[])cssRuleArray);
                                                CSSKt.style$default((Styleable)((Styleable)$this$button), (boolean)false, (Function1)root.1.1.1.1.INSTANCE, (int)1, null);
                                                NodesKt.tooltip$default((Node)((Node)$this$button), (String)"Remove this certificate", null, null, (int)6, null);
                                                ControlsKt.action((ButtonBase)((ButtonBase)$this$button), (Function0)((Function0)new Function0<Unit>(this.this$0, this.$cell){
                                                    final /* synthetic */ SecuritySetupDialog this$0;
                                                    final /* synthetic */ String $cell;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$cell = $cell;
                                                        super(0);
                                                    }

                                                    public final void invoke() {
                                                        SecuritySetupDialog.access$getDirtyCertificates$p(this.this$0).setValue(Boolean.valueOf(true));
                                                        CertificateManager certificateManager = SecuritySetupDialog.access$getCm$p(this.this$0);
                                                        if (certificateManager != null) {
                                                            certificateManager.remove(this.$cell);
                                                        }
                                                        SecuritySetupDialog.access$getCertificates$p(this.this$0).remove((Object)this.$cell);
                                                    }
                                                }));
                                            }
                                        }), (int)1, null);
                                        ControlsKt.label$default((EventTarget)((EventTarget)$this$invoke_u24lambda_u2d0), (String)cell, null, null, (int)6, null);
                                        return (Node)hBox;
                                    }
                                }, null, 2, null));
                            }
                        }));
                        NodesKt.plusAssign((EventTarget)((EventTarget)$this$vbox), (Node)((Node)kComponents.kbuttonMain$default(kComponents.INSTANCE, new KUnion.Raw<String>("Import"), null, null, (Function1)new Function1<Button, Unit>(this.this$0){
                            final /* synthetic */ SecuritySetupDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Button $this$kbuttonMain) {
                                SecuritySetupDialog.access$importCertificate(this.this$0);
                            }
                        }, 6, null)));
                    }
                }), (int)2, null);
            }
        }), (int)2, null);
        TabPaneKt.tab$default((TabPane)$this$root_u24lambda_u2d2_u24lambda_u2d1, (String)"Options", null, (Function1)((Function1)new Function1<Tab, Unit>(this){
            final /* synthetic */ SecuritySetupDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Tab $this$tab) {
                LayoutsKt.vbox$default((EventTarget)((EventTarget)$this$tab), (Number)5.0, null, (Function1)((Function1)new Function1<VBox, Unit>(this.this$0){
                    final /* synthetic */ SecuritySetupDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull VBox $this$vbox) {
                        NodesKt.setVgrow((Node)((Node)$this$vbox), (Priority)Priority.ALWAYS);
                        FormsKt.form((EventTarget)((EventTarget)$this$vbox), (Function1)((Function1)new Function1<Form, Unit>(this.this$0){
                            final /* synthetic */ SecuritySetupDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Form $this$form) {
                                FormsKt.fieldset$default((EventTarget)((EventTarget)$this$form), null, null, null, null, (Function1)((Function1)new Function1<Fieldset, Unit>(this.this$0){
                                    final /* synthetic */ SecuritySetupDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Fieldset $this$fieldset) {
                                        FormsKt.field$default((EventTarget)((EventTarget)$this$fieldset), (String)"Enable offline login", null, (boolean)false, (Function1)((Function1)new Function1<Field, Unit>(this.this$0){
                                            final /* synthetic */ SecuritySetupDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Field $this$field) {
                                                ControlsKt.checkbox$default((EventTarget)((EventTarget)$this$field), null, (Property)((Property)SecuritySetupDialog.access$getNetworkSettingsModel$p(this.this$0).getOfflineEnabled()), null, (int)4, null);
                                            }
                                        }), (int)6, null);
                                        JavaFxExtensionsKt.fixedSpacer((VBox)$this$fieldset, 15.0);
                                        ControlsKt.label$default((EventTarget)((EventTarget)$this$fieldset), (String)"Check if you work in a closed environment (not connected to the Internet), and if your company has offline licenses available.", null, (Function1)root.1.1.2.INSTANCE, (int)2, null);
                                        ControlsKt.hyperlink$default((EventTarget)((EventTarget)$this$fieldset), (String)"Documentation", null, (Function1)root.1.1.3.INSTANCE, (int)2, null);
                                    }
                                }), (int)15, null);
                                FormsKt.fieldset$default((EventTarget)((EventTarget)$this$form), null, null, null, null, (Function1)root.1.1.2.INSTANCE, (int)15, null);
                            }
                        }));
                    }
                }), (int)2, null);
            }
        }), (int)2, null);
        var6_10.setCenter((Node)$i$f$jsonModel22);
        Hyperlink special = JavaFxExtensionsKt.hyperlinkUrl$default((EventTarget)$this$root_u24lambda_u2d2, "HELP", "https://docs.conduktor.io/sign-in-section/login-troubleshooting", Links.Conduktor.Documentation.INSTANCE, false, null, null, 56, null);
        $this$root_u24lambda_u2d2.setBottom((Node)kComponents.kbuttonbar$default(kComponents.INSTANCE, this, Application.Security.INSTANCE, (UIComponent)this, new KUnion.Raw<String>("Save"), KUnion.Companion.fa(FontAwesomeIcon.SAVE), null, (Node)special, (Function1)new Function1<Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ SecuritySetupDialog this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean dirtyProxy;
                        ProxyJson proxyJson;
                        JsonModel jsonModel2;
                        void this_$iv;
                        ResultKt.throwOnFailure((Object)object);
                        SecuritySetupDialog.access$getLogger$p(this.this$0).info("Saving new security configuration. Consider restarting Conduktor now.");
                        Proxy proxy = SecuritySetupDialog.access$getProxyModel$p(this.this$0).raw();
                        ConfigProperties configProperties = this.this$0.getApp().getConfig();
                        String key$iv = "proxy";
                        boolean $i$f$jsonModel2 = false;
                        JsonObject jsonObject = this_$iv.jsonObject(key$iv);
                        if (jsonObject != null) {
                            JsonObject $this$toModel$iv$iv = jsonObject;
                            boolean $i$f$toModel = false;
                            JsonModel model$iv$iv = (JsonModel)ProxyJson.class.newInstance();
                            model$iv$iv.updateModel($this$toModel$iv$iv);
                            JsonModel jsonModel3 = model$iv$iv;
                            jsonModel2 = jsonModel3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsonModel3, (String)"model");
                        } else {
                            jsonModel2 = null;
                        }
                        if ((proxyJson = (ProxyJson)jsonModel2) == null) {
                            proxyJson = new ProxyJson(Proxy.Companion.getDefault());
                        }
                        boolean bl = dirtyProxy = !Intrinsics.areEqual((Object)proxy, (Object)proxyJson.raw());
                        if (dirtyProxy) {
                            this.this$0.getApp().getConfig().set("proxy", SecuritySetupDialog.access$getProxyModel$p(this.this$0).toJSON().toString());
                            ConfigurationExtension.INSTANCE.atomicSave(this.this$0.getApp().getConfig());
                        }
                        SecuritySetupDialog.access$getNetworkOptionsController(this.this$0).saveNetworkOptions(SecuritySetupDialog.access$getNetworkSettingsModel$p(this.this$0).raw());
                        AnalyticsTracker.action$default(Conduktor.Companion.getTracker(), Application.Security.INSTANCE.saved(), null, 2, null);
                        if (!SecuritySetupDialog.access$getNetworkSettingsModel$p(this.this$0).raw().getOfflineEnabled() && Conduktor.Companion.getAuth().isLoggedInOffline() || SecuritySetupDialog.access$getNetworkSettingsModel$p(this.this$0).raw().getOfflineEnabled() && Conduktor.Companion.getAuth().isLoggedInOnline()) {
                            Conduktor.Companion.getAuth().clearAllAuthInfoAndLogoutUser();
                        }
                        if (SecuritySetupDialog.access$getDirtyCertificates$p(this.this$0).getValue().booleanValue() || dirtyProxy) {
                            Optional buttonClicked$iv;
                            String string;
                            Alert.AlertType type$iv = Alert.AlertType.CONFIRMATION;
                            String header$iv = "";
                            String content$iv = "Would you like to close Conduktor now and restart it (manually), to take your modification into account?";
                            ButtonType[] $i$f$jsonModel2 = new ButtonType[]{ButtonType.YES, ButtonType.NO};
                            ButtonType[] buttons$iv = $i$f$jsonModel2;
                            Window owner$iv = (Window)this.this$0.getCurrentStage();
                            String title$iv = "Restarting Conduktor";
                            Node graphic$iv = null;
                            boolean $i$f$alert = false;
                            Alert alert$iv = new Alert(type$iv, content$iv, Arrays.copyOf(buttons$iv, buttons$iv.length));
                            String it$iv = string = title$iv;
                            boolean bl2 = false;
                            alert$iv.setTitle(it$iv);
                            alert$iv.setHeaderText(header$iv);
                            Window window = owner$iv;
                            if (window != null) {
                                it$iv = string = window;
                                boolean bl3 = false;
                                alert$iv.initOwner((Window)it$iv);
                            }
                            Optional optional = buttonClicked$iv = alert$iv.showAndWait();
                            Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"buttonClicked");
                            if (optional.isPresent()) {
                                T t = buttonClicked$iv.get();
                                Intrinsics.checkExpressionValueIsNotNull(t, (String)"buttonClicked.get()");
                                ButtonType it = (ButtonType)t;
                                boolean bl4 = false;
                                if (Intrinsics.areEqual((Object)it, (Object)ButtonType.YES)) {
                                    System.exit(0);
                                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                                }
                            }
                        }
                        return Boxing.boxBoolean((boolean)true);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Boolean> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, 16, null));
        securitySetupDialog.root = borderPane;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    private final NetworkOptionsController getNetworkOptionsController() {
        return (NetworkOptionsController)((Object)this.networkOptionsController$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    private final void refreshList() {
        if (this.cm != null) {
            Object object;
            ObservableList<String> observableList = this.certificates;
            Either $this$getOrElse$iv = this.cm.list();
            boolean $i$f$getOrElse = false;
            Either this_$iv$iv = $this$getOrElse$iv;
            boolean $i$f$fold = false;
            Either either2 = this_$iv$iv;
            if (either2 instanceof Either.Right) {
                Object p1$iv = ((Either.Right)this_$iv$iv).getValue();
                boolean bl = false;
                boolean $i$f$identity = false;
                object = p1$iv;
            } else if (either2 instanceof Either.Left) {
                Object it$iv = ((Either.Left)this_$iv$iv).getValue();
                boolean bl = false;
                ObservableList<String> observableList2 = observableList;
                boolean bl2 = false;
                object = CollectionsKt.emptyList();
                observableList = observableList2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            observableList.setAll((Collection)object);
        }
    }

    @NotNull
    public BorderPane getRoot() {
        return this.root;
    }

    private final void importCertificate() {
        CertificateManager certificateManager = Conduktor.Companion.getCertificateManager();
        if (certificateManager == null) {
            JavaFxExtensionsKt.safeAlert$default((UIComponent)this, "Couldn't load cacerts", null, null, 6, null);
            return;
        }
        CertificateManager cm = certificateManager;
        FileChooser.ExtensionFilter[] extensionFilterArray = new FileChooser.ExtensionFilter[1];
        String[] stringArray = new String[]{"*.pem", "*.*"};
        extensionFilterArray[0] = new FileChooser.ExtensionFilter("*.crt", stringArray);
        List files2 = DialogsKt.chooseFile$default((String)"Choose certificate(s) to import into the JVM", (FileChooser.ExtensionFilter[])extensionFilterArray, null, null, (FileChooserMode)FileChooserMode.Multi, null, null, (int)108, null);
        if (!((Collection)files2).isEmpty()) {
            this.dirtyCertificates.setValue(Boolean.valueOf(true));
            Iterable $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                Either either2 = cm.import(it.toPath());
                if (either2 instanceof Either.Left) {
                    JavaFxExtensionsKt.safeAlert$default((UIComponent)this, "Error adding certificate to Conduktor: " + it.getName() + " (" + ((Throwable)((Either.Left)either2).getValue()).getMessage() + ")", null, null, 6, null);
                    continue;
                }
                if (!(either2 instanceof Either.Right)) continue;
                AnalyticsTracker.action$default(Conduktor.Companion.getTracker(), Application.Security.Certificate.INSTANCE.imported(), null, 2, null);
                this.refreshList();
            }
        }
    }

    public static final /* synthetic */ ProxyJson access$getProxyModel$p(SecuritySetupDialog $this) {
        return $this.proxyModel;
    }

    public static final /* synthetic */ NetworkOptionsJson access$getNetworkSettingsModel$p(SecuritySetupDialog $this) {
        return $this.networkSettingsModel;
    }

    public static final /* synthetic */ ObservableList access$getCertificates$p(SecuritySetupDialog $this) {
        return $this.certificates;
    }

    public static final /* synthetic */ void access$importCertificate(SecuritySetupDialog $this) {
        $this.importCertificate();
    }

    public static final /* synthetic */ CertificateManager access$getCm$p(SecuritySetupDialog $this) {
        return $this.cm;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SecuritySetupDialog $this) {
        return $this.logger;
    }

    public static final /* synthetic */ NetworkOptionsController access$getNetworkOptionsController(SecuritySetupDialog $this) {
        return $this.getNetworkOptionsController();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SecuritySetupDialog.class, "networkOptionsController", "getNetworkOptionsController()Lio/conduktor/controllers/NetworkOptionsController;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

