/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.exporter;

import io.conduktor.exporter.ObjectStringifier;
import io.conduktor.models.PartitionSize;
import io.conduktor.models.TopicPartitionInfo;
import io.conduktor.models.settings.ConduktorConfig;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f0\t2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lio/conduktor/exporter/TopicPartitionInfoToCsvStringifier;", "Lio/conduktor/exporter/ObjectStringifier;", "Lio/conduktor/models/TopicPartitionInfo;", "config", "Lio/conduktor/models/settings/ConduktorConfig;", "(Lio/conduktor/models/settings/ConduktorConfig;)V", "getConfig", "()Lio/conduktor/models/settings/ConduktorConfig;", "columns", "", "", "toStrings", "", "a", "desktop"})
final class TopicPartitionInfoToCsvStringifier
implements ObjectStringifier<TopicPartitionInfo> {
    @NotNull
    private final ConduktorConfig config;

    public TopicPartitionInfoToCsvStringifier(@NotNull ConduktorConfig config) {
        this.config = config;
    }

    @NotNull
    public final ConduktorConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public List<String> columns() {
        Object[] objectArray = new String[]{"Partition", "Leader", "Beginning Offset", "Ending Offset"};
        List l = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.config.getShowTopicSizeColumn()) {
            l.add("Size");
        }
        l.add("ISR");
        l.add("Replicas");
        if (this.config.getShowTopicLastWriteColumn()) {
            l.add("Last Write");
        }
        return l;
    }

    @Override
    @NotNull
    public List<String[]> toStrings(@NotNull TopicPartitionInfo a) {
        Object[] objectArray = new String[4];
        objectArray[0] = String.valueOf(a.getPartition());
        Object object = a.getLeaderId();
        if (object == null || (object = ((Integer)object).toString()) == null) {
            object = "";
        }
        objectArray[1] = object;
        objectArray[2] = a.getBeginningOffset().toString();
        objectArray[3] = a.getEndOffset().toString();
        List l = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.config.getShowTopicSizeColumn()) {
            PartitionSize partitionSize = a.getSize();
            l.add(partitionSize instanceof PartitionSize.Default ? String.valueOf(((PartitionSize.Default)partitionSize).getValue()) : "");
        }
        l.add(CollectionsKt.joinToString$default((Iterable)a.getIsrText(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        List<Integer> list2 = a.getReplicasText();
        if (list2 == null || (list2 = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)) == null) {
            list2 = "";
        }
        l.add(list2);
        if (this.config.getShowTopicLastWriteColumn()) {
            Object object2 = a.getLastWrite().getMillisUTC();
            if (object2 == null || (object2 = ((Long)object2).toString()) == null) {
                object2 = "";
            }
            l.add(object2);
        }
        Collection $this$toTypedArray$iv = l;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return CollectionsKt.listOf((Object)stringArray);
    }
}

