/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.exporter;

import io.conduktor.NonNullWrapper;
import io.conduktor.NonNullWrapperOrdered;
import io.conduktor.exporter.ObjectStringifier;
import io.conduktor.models.ConsumerGroupActivity;
import io.conduktor.models.TopicDescription;
import io.conduktor.models.TopicSize;
import io.conduktor.models.settings.ConduktorConfig;
import io.conduktor.repository.models.TopicLastWrite;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lio/conduktor/exporter/TopicDescriptionToCsvStringifier;", "Lio/conduktor/exporter/ObjectStringifier;", "Lio/conduktor/models/TopicDescription;", "config", "Lio/conduktor/models/settings/ConduktorConfig;", "withMetrics", "", "numBrokers", "", "customConfigColumnName", "", "(Lio/conduktor/models/settings/ConduktorConfig;ZILjava/lang/String;)V", "getConfig", "()Lio/conduktor/models/settings/ConduktorConfig;", "getCustomConfigColumnName", "()Ljava/lang/String;", "getNumBrokers", "()I", "getWithMetrics", "()Z", "columns", "", "toStrings", "", "a", "desktop"})
final class TopicDescriptionToCsvStringifier
implements ObjectStringifier<TopicDescription> {
    @NotNull
    private final ConduktorConfig config;
    private final boolean withMetrics;
    private final int numBrokers;
    @Nullable
    private final String customConfigColumnName;

    public TopicDescriptionToCsvStringifier(@NotNull ConduktorConfig config, boolean withMetrics, int numBrokers, @Nullable String customConfigColumnName) {
        this.config = config;
        this.withMetrics = withMetrics;
        this.numBrokers = numBrokers;
        this.customConfigColumnName = customConfigColumnName;
    }

    @NotNull
    public final ConduktorConfig getConfig() {
        return this.config;
    }

    public final boolean getWithMetrics() {
        return this.withMetrics;
    }

    public final int getNumBrokers() {
        return this.numBrokers;
    }

    @Nullable
    public final String getCustomConfigColumnName() {
        return this.customConfigColumnName;
    }

    @Override
    @NotNull
    public List<String> columns() {
        List p1;
        block6: {
            Object[] objectArray = new String[]{"Topic", "Replication Factor", "Partitions"};
            p1 = CollectionsKt.mutableListOf((Object[])objectArray);
            if (this.config.getShowTopicCountColumn()) {
                p1.add("Count");
            }
            if (this.config.getShowTopicSizeColumn()) {
                p1.add("Size");
            }
            if (this.config.getShowTopicConsumerGroupsColumn()) {
                p1.add("Consumers");
            }
            if (this.config.getShowTopicLastWriteColumn()) {
                p1.add("Last Write");
            }
            if (this.withMetrics) {
                objectArray = new String[]{"Bytes in", "Bytes out", "Records in"};
                CollectionsKt.addAll((Collection)p1, (Object[])objectArray);
            }
            if (this.config.getShowTopicSpreadColumn()) {
                p1.add("Spread");
            }
            String string = this.customConfigColumnName;
            if (string == null) break block6;
            String it = string;
            boolean bl = false;
            p1.add(it);
        }
        return p1;
    }

    @Override
    @NotNull
    public List<String[]> toStrings(@NotNull TopicDescription a) {
        Object[] topicSize;
        Object object;
        Object[] objectArray = new String[3];
        objectArray[0] = a.getName();
        Object object2 = a.getReplicationFactor();
        if (object2 == null || (object2 = ((Integer)object2).toString()) == null) {
            object2 = objectArray[1] = "";
        }
        if ((object = (Integer)((NonNullWrapperOrdered)a.getPartitionsCountNonNullProperty().getValue()).getValue()) == null || (object = ((Integer)object).toString()) == null) {
            object = "";
        }
        objectArray[2] = object;
        List p1 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.config.getShowTopicCountColumn()) {
            Object object3 = (Long)((NonNullWrapperOrdered)a.getCountNonNullProperty().getValue()).getValue();
            if (object3 == null || (object3 = ((Long)object3).toString()) == null) {
                object3 = "";
            }
            p1.add(object3);
        }
        if (this.config.getShowTopicSizeColumn()) {
            topicSize = (Object[])((NonNullWrapperOrdered)a.getSizeNonNullProperty().getValue()).getValue();
            p1.add(topicSize instanceof TopicSize.Default ? String.valueOf(((TopicSize.Default)topicSize).getValue()) : "");
        }
        if (this.config.getShowTopicConsumerGroupsColumn()) {
            Object object4 = (ConsumerGroupActivity)((NonNullWrapper)a.getConsumerGroupsStateNonNullProperty().getValue()).getValue();
            if (object4 == null || (object4 = Integer.valueOf(((ConsumerGroupActivity)object4).getActive()).toString()) == null) {
                object4 = "";
            }
            p1.add(object4);
        }
        if (this.config.getShowTopicLastWriteColumn()) {
            Object object5 = (TopicLastWrite)a.getLastWriteProperty().getValue();
            if (object5 == null || (object5 = object5.getMillisUTC()) == null || (object5 = ((Long)object5).toString()) == null) {
                object5 = "";
            }
            p1.add(object5);
        }
        if (this.withMetrics) {
            topicSize = new String[]{String.valueOf(a.getMetrics().getBytesInProperty().getValue()), String.valueOf(a.getMetrics().getBytesOutProperty().getValue()), String.valueOf(a.getMetrics().getMessagesInProperty().getValue())};
            CollectionsKt.addAll((Collection)p1, (Object[])topicSize);
        }
        if (this.config.getShowTopicSpreadColumn()) {
            p1.add(a.spread(this.numBrokers));
        }
        String string = this.customConfigColumnName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            p1.add(a.customConfigColumnData(it));
        }
        Collection $this$toTypedArray$iv = p1;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return CollectionsKt.listOf((Object)stringArray);
    }
}

