/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.exporter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.conduktor.NonNullWrapper;
import io.conduktor.NonNullWrapperOrdered;
import io.conduktor.exporter.ObjectJsonifier;
import io.conduktor.models.ConsumerGroupActivity;
import io.conduktor.models.TopicDescription;
import io.conduktor.models.TopicSize;
import io.conduktor.models.settings.ConduktorConfig;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lio/conduktor/exporter/TopicDescriptionJsonifier;", "Lio/conduktor/exporter/ObjectJsonifier;", "Lio/conduktor/models/TopicDescription;", "config", "Lio/conduktor/models/settings/ConduktorConfig;", "withMetrics", "", "numBrokers", "", "customConfigColumnName", "", "(Lio/conduktor/models/settings/ConduktorConfig;ZILjava/lang/String;)V", "getConfig", "()Lio/conduktor/models/settings/ConduktorConfig;", "getCustomConfigColumnName", "()Ljava/lang/String;", "getNumBrokers", "()I", "om", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getWithMetrics", "()Z", "toJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "a", "desktop"})
final class TopicDescriptionJsonifier
implements ObjectJsonifier<TopicDescription> {
    @NotNull
    private final ConduktorConfig config;
    private final boolean withMetrics;
    private final int numBrokers;
    @Nullable
    private final String customConfigColumnName;
    @NotNull
    private final ObjectMapper om;

    public TopicDescriptionJsonifier(@NotNull ConduktorConfig config, boolean withMetrics, int numBrokers, @Nullable String customConfigColumnName) {
        this.config = config;
        this.withMetrics = withMetrics;
        this.numBrokers = numBrokers;
        this.customConfigColumnName = customConfigColumnName;
        this.om = new ObjectMapper();
    }

    @NotNull
    public final ConduktorConfig getConfig() {
        return this.config;
    }

    public final boolean getWithMetrics() {
        return this.withMetrics;
    }

    public final int getNumBrokers() {
        return this.numBrokers;
    }

    @Nullable
    public final String getCustomConfigColumnName() {
        return this.customConfigColumnName;
    }

    @Override
    @NotNull
    public JsonNode toJson(@NotNull TopicDescription a) {
        ObjectNode node;
        block6: {
            node = this.om.createObjectNode();
            node.put("topic", a.getName()).put("replication_factor", a.getReplicationFactor()).put("partitions", (Integer)((NonNullWrapperOrdered)a.getPartitionsCountNonNullProperty().getValue()).getValue());
            if (this.config.getShowTopicCountColumn()) {
                node.put("count", (Long)((NonNullWrapperOrdered)a.getCountNonNullProperty().getValue()).getValue());
            }
            TopicSize topicSize = (TopicSize)((NonNullWrapperOrdered)a.getSizeNonNullProperty().getValue()).getValue();
            if (this.config.getShowTopicSizeColumn() && topicSize instanceof TopicSize.Default) {
                node.put("size", ((TopicSize.Default)topicSize).getValue());
            }
            if (this.config.getShowTopicConsumerGroupsColumn()) {
                ConsumerGroupActivity consumerGroupActivity = (ConsumerGroupActivity)((NonNullWrapper)a.getConsumerGroupsStateNonNullProperty().getValue()).getValue();
                node.put("consumers", consumerGroupActivity != null ? Integer.valueOf(consumerGroupActivity.getActive()) : null);
            }
            if (this.config.getShowTopicLastWriteColumn()) {
                node.put("last_write", a.getLastWrite().getMillisUTC());
            }
            if (this.withMetrics) {
                node.put("bytes_in", ((Number)a.getMetrics().getBytesInProperty().getValue()).doubleValue());
                node.put("bytes_out", ((Number)a.getMetrics().getBytesOutProperty().getValue()).doubleValue());
                node.put("records_in", ((Number)a.getMetrics().getMessagesInProperty().getValue()).doubleValue());
            }
            if (this.config.getShowTopicSpreadColumn()) {
                node.put("spread", a.spread(this.numBrokers));
            }
            String string = this.customConfigColumnName;
            if (string == null) break block6;
            String key2 = string;
            boolean bl = false;
            node.put(key2, a.customConfigColumnData(key2));
        }
        return (JsonNode)node;
    }
}

